package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0007;
import cn.ibizlab.core.sample.service.IIBIZSample0007Service;
import cn.ibizlab.core.sample.filter.IBIZSample0007SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"嵌套流程（子）" })
@RestController("DemoAPI-ibizsample0007")
@RequestMapping("")
public class IBIZSample0007Resource {

    @Autowired
    public IIBIZSample0007Service ibizsample0007Service;

    @Autowired
    @Lazy
    public IBIZSample0007Mapping ibizsample0007Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0007Mapping.toDomain(#ibizsample0007dto),'DemoSys-IBIZSample0007-Create')")
    @ApiOperation(value = "新建嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "新建嵌套流程（子）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0007s")
    public ResponseEntity<IBIZSample0007DTO> create(@Validated @RequestBody IBIZSample0007DTO ibizsample0007dto) {
        IBIZSample0007 domain = ibizsample0007Mapping.toDomain(ibizsample0007dto);
		ibizsample0007Service.create(domain);
        IBIZSample0007DTO dto = ibizsample0007Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0007Mapping.toDomain(#ibizsample0007dtos),'DemoSys-IBIZSample0007-Create')")
    @ApiOperation(value = "批量新建嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "批量新建嵌套流程（子）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0007s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0007DTO> ibizsample0007dtos) {
        ibizsample0007Service.createBatch(ibizsample0007Mapping.toDomain(ibizsample0007dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0007" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0007Service.get(#ibizsample0007_id),'DemoSys-IBIZSample0007-Update')")
    @ApiOperation(value = "更新嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "更新嵌套流程（子）")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0007s/{ibizsample0007_id}")
    public ResponseEntity<IBIZSample0007DTO> update(@PathVariable("ibizsample0007_id") String ibizsample0007_id, @RequestBody IBIZSample0007DTO ibizsample0007dto) {
		IBIZSample0007 domain  = ibizsample0007Mapping.toDomain(ibizsample0007dto);
        domain .setIbizsample0007id(ibizsample0007_id);
		ibizsample0007Service.update(domain );
		IBIZSample0007DTO dto = ibizsample0007Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0007Service.getIbizsample0007ByEntities(this.ibizsample0007Mapping.toDomain(#ibizsample0007dtos)),'DemoSys-IBIZSample0007-Update')")
    @ApiOperation(value = "批量更新嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "批量更新嵌套流程（子）")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0007s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0007DTO> ibizsample0007dtos) {
        ibizsample0007Service.updateBatch(ibizsample0007Mapping.toDomain(ibizsample0007dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0007Service.get(#ibizsample0007_id),'DemoSys-IBIZSample0007-Remove')")
    @ApiOperation(value = "删除嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "删除嵌套流程（子）")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0007s/{ibizsample0007_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0007_id") String ibizsample0007_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0007Service.remove(ibizsample0007_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0007Service.getIbizsample0007ByIds(#ids),'DemoSys-IBIZSample0007-Remove')")
    @ApiOperation(value = "批量删除嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "批量删除嵌套流程（子）")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0007s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0007Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0007Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0007-Get')")
    @ApiOperation(value = "获取嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "获取嵌套流程（子）")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0007s/{ibizsample0007_id}")
    public ResponseEntity<IBIZSample0007DTO> get(@PathVariable("ibizsample0007_id") String ibizsample0007_id) {
        IBIZSample0007 domain = ibizsample0007Service.get(ibizsample0007_id);
        IBIZSample0007DTO dto = ibizsample0007Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取嵌套流程（子）草稿", tags = {"嵌套流程（子）" },  notes = "获取嵌套流程（子）草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0007s/getdraft")
    public ResponseEntity<IBIZSample0007DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0007Mapping.toDto(ibizsample0007Service.getDraft(new IBIZSample0007())));
    }

    @ApiOperation(value = "检查嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "检查嵌套流程（子）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0007s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0007DTO ibizsample0007dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0007Service.checkKey(ibizsample0007Mapping.toDomain(ibizsample0007dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0007Mapping.toDomain(#ibizsample0007dto),'DemoSys-IBIZSample0007-Save')")
    @ApiOperation(value = "保存嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "保存嵌套流程（子）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0007s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0007DTO ibizsample0007dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0007Service.save(ibizsample0007Mapping.toDomain(ibizsample0007dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0007Mapping.toDomain(#ibizsample0007dtos),'DemoSys-IBIZSample0007-Save')")
    @ApiOperation(value = "批量保存嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "批量保存嵌套流程（子）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0007s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0007DTO> ibizsample0007dtos) {
        ibizsample0007Service.saveBatch(ibizsample0007Mapping.toDomain(ibizsample0007dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-searchCurGW-all') and hasPermission(#context,'DemoSys-IBIZSample0007-Get')")
	@ApiOperation(value = "获取当前公文", tags = {"嵌套流程（子）" } ,notes = "获取当前公文")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0007s/fetchcurgw")
	public ResponseEntity<List<IBIZSample0007DTO>> fetchCurGW(IBIZSample0007SearchContext context) {
        Page<IBIZSample0007> domains = ibizsample0007Service.searchCurGW(context) ;
        List<IBIZSample0007DTO> list = ibizsample0007Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-searchCurGW-all') and hasPermission(#context,'DemoSys-IBIZSample0007-Get')")
	@ApiOperation(value = "查询当前公文", tags = {"嵌套流程（子）" } ,notes = "查询当前公文")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0007s/searchcurgw")
	public ResponseEntity<Page<IBIZSample0007DTO>> searchCurGW(@RequestBody IBIZSample0007SearchContext context) {
        Page<IBIZSample0007> domains = ibizsample0007Service.searchCurGW(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0007Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0007-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"嵌套流程（子）" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0007s/fetchdefault")
	public ResponseEntity<List<IBIZSample0007DTO>> fetchDefault(IBIZSample0007SearchContext context) {
        Page<IBIZSample0007> domains = ibizsample0007Service.searchDefault(context) ;
        List<IBIZSample0007DTO> list = ibizsample0007Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0007-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"嵌套流程（子）" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0007s/searchdefault")
	public ResponseEntity<Page<IBIZSample0007DTO>> searchDefault(@RequestBody IBIZSample0007SearchContext context) {
        Page<IBIZSample0007> domains = ibizsample0007Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0007Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

