package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZTASK;
import cn.ibizlab.core.sample.service.IIBIZTASKService;
import cn.ibizlab.core.sample.filter.IBIZTASKSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;
import cn.ibizlab.core.sample.filter.IBIZTASKTEAMSearchContext;
import cn.ibizlab.core.sample.domain.IBIZTASKTEAM;
import cn.ibizlab.core.sample.service.IIBIZTASKTEAMService;

@Slf4j
@Api(tags = {"任务" })
@RestController("DemoAPI-ibiztask")
@RequestMapping("")
public class IBIZTASKResource {

    @Autowired
    public IIBIZTASKService ibiztaskService;

    @Autowired
    @Lazy
    public IBIZTASKMapping ibiztaskMapping;

    @Autowired
    private IIBIZTASKTEAMService ibiztaskteamService;
    @PreAuthorize("hasPermission(this.ibiztaskMapping.toDomain(#ibiztaskdto),'DemoSys-IBIZTASK-Create')")
    @ApiOperation(value = "新建任务", tags = {"任务" },  notes = "新建任务")
	@RequestMapping(method = RequestMethod.POST, value = "/ibiztasks")
    public ResponseEntity<IBIZTASKDTO> create(@Validated @RequestBody IBIZTASKDTO ibiztaskdto) {
        IBIZTASK domain = ibiztaskMapping.toDomain(ibiztaskdto);
		ibiztaskService.create(domain);
        IBIZTASKDTO dto = ibiztaskMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibiztaskMapping.toDomain(#ibiztaskdtos),'DemoSys-IBIZTASK-Create')")
    @ApiOperation(value = "批量新建任务", tags = {"任务" },  notes = "批量新建任务")
	@RequestMapping(method = RequestMethod.POST, value = "/ibiztasks/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZTASKDTO> ibiztaskdtos) {
        ibiztaskService.createBatch(ibiztaskMapping.toDomain(ibiztaskdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibiztaskMapping.toDomain(returnObject.body),'DemoSys-IBIZTASK-Get')")
    @ApiOperation(value = "获取任务", tags = {"任务" },  notes = "获取任务")
	@RequestMapping(method = RequestMethod.GET, value = "/ibiztasks/{ibiztask_id}")
    public ResponseEntity<IBIZTASKDTO> get(@PathVariable("ibiztask_id") String ibiztask_id) {
        IBIZTASK domain = ibiztaskService.get(ibiztask_id);
        IBIZTASKDTO dto = ibiztaskMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibiztaskService.get(#ibiztask_id),'DemoSys-IBIZTASK-Remove')")
    @ApiOperation(value = "删除任务", tags = {"任务" },  notes = "删除任务")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibiztasks/{ibiztask_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibiztask_id") String ibiztask_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibiztaskService.remove(ibiztask_id));
    }

    @PreAuthorize("hasPermission(this.ibiztaskService.getIbiztaskByIds(#ids),'DemoSys-IBIZTASK-Remove')")
    @ApiOperation(value = "批量删除任务", tags = {"任务" },  notes = "批量删除任务")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibiztasks/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibiztaskService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibiztask" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibiztaskService.get(#ibiztask_id),'DemoSys-IBIZTASK-Update')")
    @ApiOperation(value = "更新任务", tags = {"任务" },  notes = "更新任务")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibiztasks/{ibiztask_id}")
    public ResponseEntity<IBIZTASKDTO> update(@PathVariable("ibiztask_id") String ibiztask_id, @RequestBody IBIZTASKDTO ibiztaskdto) {
		IBIZTASK domain  = ibiztaskMapping.toDomain(ibiztaskdto);
        domain .setIbiztaskid(ibiztask_id);
		ibiztaskService.update(domain );
		IBIZTASKDTO dto = ibiztaskMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibiztaskService.getIbiztaskByEntities(this.ibiztaskMapping.toDomain(#ibiztaskdtos)),'DemoSys-IBIZTASK-Update')")
    @ApiOperation(value = "批量更新任务", tags = {"任务" },  notes = "批量更新任务")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibiztasks/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZTASKDTO> ibiztaskdtos) {
        ibiztaskService.updateBatch(ibiztaskMapping.toDomain(ibiztaskdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查任务", tags = {"任务" },  notes = "检查任务")
	@RequestMapping(method = RequestMethod.POST, value = "/ibiztasks/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZTASKDTO ibiztaskdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibiztaskService.checkKey(ibiztaskMapping.toDomain(ibiztaskdto)));
    }

    @ApiOperation(value = "获取任务草稿", tags = {"任务" },  notes = "获取任务草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibiztasks/getdraft")
    public ResponseEntity<IBIZTASKDTO> getDraft(IBIZTASKDTO dto) {
        IBIZTASK domain = ibiztaskMapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(ibiztaskMapping.toDto(ibiztaskService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.ibiztaskMapping.toDomain(#ibiztaskdto),'DemoSys-IBIZTASK-Save')")
    @ApiOperation(value = "保存任务", tags = {"任务" },  notes = "保存任务")
	@RequestMapping(method = RequestMethod.POST, value = "/ibiztasks/save")
    public ResponseEntity<IBIZTASKDTO> save(@RequestBody IBIZTASKDTO ibiztaskdto) {
        IBIZTASK domain = ibiztaskMapping.toDomain(ibiztaskdto);
        ibiztaskService.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibiztaskMapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.ibiztaskMapping.toDomain(#ibiztaskdtos),'DemoSys-IBIZTASK-Save')")
    @ApiOperation(value = "批量保存任务", tags = {"任务" },  notes = "批量保存任务")
	@RequestMapping(method = RequestMethod.POST, value = "/ibiztasks/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZTASKDTO> ibiztaskdtos) {
        ibiztaskService.saveBatch(ibiztaskMapping.toDomain(ibiztaskdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZTASK-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZTASK-Get')")
	@ApiOperation(value = "获取数据集", tags = {"任务" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/ibiztasks/fetchdefault")
	public ResponseEntity<List<IBIZTASKDTO>> fetchDefault(IBIZTASKSearchContext context) {
        Page<IBIZTASK> domains = ibiztaskService.searchDefault(context) ;
        List<IBIZTASKDTO> list = ibiztaskMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZTASK-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZTASK-Get')")
	@ApiOperation(value = "查询数据集", tags = {"任务" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/ibiztasks/searchdefault")
	public ResponseEntity<Page<IBIZTASKDTO>> searchDefault(@RequestBody IBIZTASKSearchContext context) {
        Page<IBIZTASK> domains = ibiztaskService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibiztaskMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

