package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0004;
import cn.ibizlab.core.sample.service.IIBIZSample0004Service;
import cn.ibizlab.core.sample.filter.IBIZSample0004SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"多版本流程" })
@RestController("DemoAPI-ibizsample0004")
@RequestMapping("")
public class IBIZSample0004Resource {

    @Autowired
    public IIBIZSample0004Service ibizsample0004Service;

    @Autowired
    @Lazy
    public IBIZSample0004Mapping ibizsample0004Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0004Mapping.toDomain(#ibizsample0004dto),'DemoSys-IBIZSample0004-Create')")
    @ApiOperation(value = "新建多版本流程", tags = {"多版本流程" },  notes = "新建多版本流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0004s")
    public ResponseEntity<IBIZSample0004DTO> create(@Validated @RequestBody IBIZSample0004DTO ibizsample0004dto) {
        IBIZSample0004 domain = ibizsample0004Mapping.toDomain(ibizsample0004dto);
		ibizsample0004Service.create(domain);
        IBIZSample0004DTO dto = ibizsample0004Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0004Mapping.toDomain(#ibizsample0004dtos),'DemoSys-IBIZSample0004-Create')")
    @ApiOperation(value = "批量新建多版本流程", tags = {"多版本流程" },  notes = "批量新建多版本流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0004s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0004DTO> ibizsample0004dtos) {
        ibizsample0004Service.createBatch(ibizsample0004Mapping.toDomain(ibizsample0004dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0004Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0004-Get')")
    @ApiOperation(value = "获取多版本流程", tags = {"多版本流程" },  notes = "获取多版本流程")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0004s/{ibizsample0004_id}")
    public ResponseEntity<IBIZSample0004DTO> get(@PathVariable("ibizsample0004_id") String ibizsample0004_id) {
        IBIZSample0004 domain = ibizsample0004Service.get(ibizsample0004_id);
        IBIZSample0004DTO dto = ibizsample0004Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0004Service.get(#ibizsample0004_id),'DemoSys-IBIZSample0004-Remove')")
    @ApiOperation(value = "删除多版本流程", tags = {"多版本流程" },  notes = "删除多版本流程")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0004s/{ibizsample0004_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0004_id") String ibizsample0004_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0004Service.remove(ibizsample0004_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0004Service.getIbizsample0004ByIds(#ids),'DemoSys-IBIZSample0004-Remove')")
    @ApiOperation(value = "批量删除多版本流程", tags = {"多版本流程" },  notes = "批量删除多版本流程")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0004s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0004Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0004" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0004Service.get(#ibizsample0004_id),'DemoSys-IBIZSample0004-Update')")
    @ApiOperation(value = "更新多版本流程", tags = {"多版本流程" },  notes = "更新多版本流程")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0004s/{ibizsample0004_id}")
    public ResponseEntity<IBIZSample0004DTO> update(@PathVariable("ibizsample0004_id") String ibizsample0004_id, @RequestBody IBIZSample0004DTO ibizsample0004dto) {
		IBIZSample0004 domain  = ibizsample0004Mapping.toDomain(ibizsample0004dto);
        domain .setIbizsample0004id(ibizsample0004_id);
		ibizsample0004Service.update(domain );
		IBIZSample0004DTO dto = ibizsample0004Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0004Service.getIbizsample0004ByEntities(this.ibizsample0004Mapping.toDomain(#ibizsample0004dtos)),'DemoSys-IBIZSample0004-Update')")
    @ApiOperation(value = "批量更新多版本流程", tags = {"多版本流程" },  notes = "批量更新多版本流程")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0004s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0004DTO> ibizsample0004dtos) {
        ibizsample0004Service.updateBatch(ibizsample0004Mapping.toDomain(ibizsample0004dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查多版本流程", tags = {"多版本流程" },  notes = "检查多版本流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0004s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0004DTO ibizsample0004dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0004Service.checkKey(ibizsample0004Mapping.toDomain(ibizsample0004dto)));
    }

    @ApiOperation(value = "获取多版本流程草稿", tags = {"多版本流程" },  notes = "获取多版本流程草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0004s/getdraft")
    public ResponseEntity<IBIZSample0004DTO> getDraft(IBIZSample0004DTO dto) {
        IBIZSample0004 domain = ibizsample0004Mapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0004Mapping.toDto(ibizsample0004Service.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0004Mapping.toDomain(#ibizsample0004dto),'DemoSys-IBIZSample0004-Save')")
    @ApiOperation(value = "保存多版本流程", tags = {"多版本流程" },  notes = "保存多版本流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0004s/save")
    public ResponseEntity<IBIZSample0004DTO> save(@RequestBody IBIZSample0004DTO ibizsample0004dto) {
        IBIZSample0004 domain = ibizsample0004Mapping.toDomain(ibizsample0004dto);
        ibizsample0004Service.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0004Mapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.ibizsample0004Mapping.toDomain(#ibizsample0004dtos),'DemoSys-IBIZSample0004-Save')")
    @ApiOperation(value = "批量保存多版本流程", tags = {"多版本流程" },  notes = "批量保存多版本流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0004s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0004DTO> ibizsample0004dtos) {
        ibizsample0004Service.saveBatch(ibizsample0004Mapping.toDomain(ibizsample0004dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0004-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0004-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"多版本流程" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0004s/fetchdefault")
	public ResponseEntity<List<IBIZSample0004DTO>> fetchDefault(IBIZSample0004SearchContext context) {
        Page<IBIZSample0004> domains = ibizsample0004Service.searchDefault(context) ;
        List<IBIZSample0004DTO> list = ibizsample0004Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0004-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0004-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"多版本流程" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0004s/searchdefault")
	public ResponseEntity<Page<IBIZSample0004DTO>> searchDefault(@RequestBody IBIZSample0004SearchContext context) {
        Page<IBIZSample0004> domains = ibizsample0004Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0004Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

