package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0007DTO]
 */
@Data
@ApiModel("嵌套流程（子）")
public class IBIZSample0007DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [IBIZSAMPLE0007ID]
     *
     */
    @JSONField(name = "ibizsample0007id")
    @JsonProperty("ibizsample0007id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("嵌套流程（子）标识")
    private String ibizsample0007id;

    /**
     * 属性 [WFVERSION]
     *
     */
    @JSONField(name = "wfversion")
    @JsonProperty("wfversion")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("工作流版本")
    private String wfversion;

    /**
     * 属性 [IBIZSAMPLE0007NAME]
     *
     */
    @JSONField(name = "ibizsample0007name")
    @JsonProperty("ibizsample0007name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("公文名称")
    private String ibizsample0007name;

    /**
     * 属性 [WFSTATE]
     *
     */
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    @ApiModelProperty("工作流步骤")
    private Integer wfstate;

    /**
     * 属性 [YWSTATE]
     *
     */
    @JSONField(name = "ywstate")
    @JsonProperty("ywstate")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("业务状态")
    private String ywstate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("更新人")
    private String updateman;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("工作流实例")
    private String wfinstanceid;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;

    /**
     * 属性 [WFSTEP]
     *
     */
    @JSONField(name = "wfstep")
    @JsonProperty("wfstep")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("会签步骤")
    private String wfstep;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("建立人")
    private String createman;

    /**
     * 属性 [DNUM]
     *
     */
    @JSONField(name = "dnum")
    @JsonProperty("dnum")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("公文编号")
    private String dnum;

    /**
     * 属性 [DDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "ddate" , format="yyyy-MM-dd")
    @JsonProperty("ddate")
    @ApiModelProperty("公文时间")
    private Timestamp ddate;

    /**
     * 属性 [DTEXT]
     *
     */
    @JSONField(name = "dtext")
    @JsonProperty("dtext")
    @Size(min = 0, max = 1048576, message = "内容长度必须小于等于[1048576]")
    @ApiModelProperty("正文")
    private String dtext;

    /**
     * 属性 [IBIZSAMPLE0006NAME]
     *
     */
    @JSONField(name = "ibizsample0006name")
    @JsonProperty("ibizsample0006name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("嵌套流程（主）名称")
    private String ibizsample0006name;

    /**
     * 属性 [IBIZSAMPLE0006ID]
     *
     */
    @JSONField(name = "ibizsample0006id")
    @JsonProperty("ibizsample0006id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("嵌套流程（主）标识")
    private String ibizsample0006id;


    /**
     * 设置 [WFVERSION]
     */
    public void setWfversion(String  wfversion){
        this.wfversion = wfversion ;
        this.modify("wfversion",wfversion);
    }

    /**
     * 设置 [IBIZSAMPLE0007NAME]
     */
    public void setIbizsample0007name(String  ibizsample0007name){
        this.ibizsample0007name = ibizsample0007name ;
        this.modify("ibizsample0007name",ibizsample0007name);
    }

    /**
     * 设置 [WFSTATE]
     */
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.modify("wfstate",wfstate);
    }

    /**
     * 设置 [YWSTATE]
     */
    public void setYwstate(String  ywstate){
        this.ywstate = ywstate ;
        this.modify("ywstate",ywstate);
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.modify("wfinstanceid",wfinstanceid);
    }

    /**
     * 设置 [WFSTEP]
     */
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.modify("wfstep",wfstep);
    }

    /**
     * 设置 [IBIZSAMPLE0006ID]
     */
    public void setIbizsample0006id(String  ibizsample0006id){
        this.ibizsample0006id = ibizsample0006id ;
        this.modify("ibizsample0006id",ibizsample0006id);
    }


}


