package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0019;
import cn.ibizlab.core.sample.service.IIBIZSample0019Service;
import cn.ibizlab.core.sample.filter.IBIZSample0019SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"部门" })
@RestController("DemoAPI-ibizsample0019")
@RequestMapping("")
public class IBIZSample0019Resource {

    @Autowired
    public IIBIZSample0019Service ibizsample0019Service;

    @Autowired
    @Lazy
    public IBIZSample0019Mapping ibizsample0019Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0019Mapping.toDomain(#ibizsample0019dto),'DemoSys-IBIZSample0019-Create')")
    @ApiOperation(value = "新建部门", tags = {"部门" },  notes = "新建部门")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0019s")
    public ResponseEntity<IBIZSample0019DTO> create(@Validated @RequestBody IBIZSample0019DTO ibizsample0019dto) {
        IBIZSample0019 domain = ibizsample0019Mapping.toDomain(ibizsample0019dto);
		ibizsample0019Service.create(domain);
        IBIZSample0019DTO dto = ibizsample0019Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0019Mapping.toDomain(#ibizsample0019dtos),'DemoSys-IBIZSample0019-Create')")
    @ApiOperation(value = "批量新建部门", tags = {"部门" },  notes = "批量新建部门")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0019s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0019DTO> ibizsample0019dtos) {
        ibizsample0019Service.createBatch(ibizsample0019Mapping.toDomain(ibizsample0019dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0019Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0019-Get')")
    @ApiOperation(value = "获取部门", tags = {"部门" },  notes = "获取部门")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0019s/{ibizsample0019_id}")
    public ResponseEntity<IBIZSample0019DTO> get(@PathVariable("ibizsample0019_id") String ibizsample0019_id) {
        IBIZSample0019 domain = ibizsample0019Service.get(ibizsample0019_id);
        IBIZSample0019DTO dto = ibizsample0019Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0019Service.get(#ibizsample0019_id),'DemoSys-IBIZSample0019-Remove')")
    @ApiOperation(value = "删除部门", tags = {"部门" },  notes = "删除部门")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0019s/{ibizsample0019_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0019_id") String ibizsample0019_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0019Service.remove(ibizsample0019_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0019Service.getIbizsample0019ByIds(#ids),'DemoSys-IBIZSample0019-Remove')")
    @ApiOperation(value = "批量删除部门", tags = {"部门" },  notes = "批量删除部门")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0019s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0019Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0019" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0019Service.get(#ibizsample0019_id),'DemoSys-IBIZSample0019-Update')")
    @ApiOperation(value = "更新部门", tags = {"部门" },  notes = "更新部门")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0019s/{ibizsample0019_id}")
    public ResponseEntity<IBIZSample0019DTO> update(@PathVariable("ibizsample0019_id") String ibizsample0019_id, @RequestBody IBIZSample0019DTO ibizsample0019dto) {
		IBIZSample0019 domain  = ibizsample0019Mapping.toDomain(ibizsample0019dto);
        domain .setIbizsample0019id(ibizsample0019_id);
		ibizsample0019Service.update(domain );
		IBIZSample0019DTO dto = ibizsample0019Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0019Service.getIbizsample0019ByEntities(this.ibizsample0019Mapping.toDomain(#ibizsample0019dtos)),'DemoSys-IBIZSample0019-Update')")
    @ApiOperation(value = "批量更新部门", tags = {"部门" },  notes = "批量更新部门")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0019s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0019DTO> ibizsample0019dtos) {
        ibizsample0019Service.updateBatch(ibizsample0019Mapping.toDomain(ibizsample0019dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查部门", tags = {"部门" },  notes = "检查部门")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0019s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0019DTO ibizsample0019dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0019Service.checkKey(ibizsample0019Mapping.toDomain(ibizsample0019dto)));
    }

    @ApiOperation(value = "获取部门草稿", tags = {"部门" },  notes = "获取部门草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0019s/getdraft")
    public ResponseEntity<IBIZSample0019DTO> getDraft(IBIZSample0019DTO dto) {
        IBIZSample0019 domain = ibizsample0019Mapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0019Mapping.toDto(ibizsample0019Service.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0019Mapping.toDomain(#ibizsample0019dto),'DemoSys-IBIZSample0019-Save')")
    @ApiOperation(value = "保存部门", tags = {"部门" },  notes = "保存部门")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0019s/save")
    public ResponseEntity<IBIZSample0019DTO> save(@RequestBody IBIZSample0019DTO ibizsample0019dto) {
        IBIZSample0019 domain = ibizsample0019Mapping.toDomain(ibizsample0019dto);
        ibizsample0019Service.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0019Mapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.ibizsample0019Mapping.toDomain(#ibizsample0019dtos),'DemoSys-IBIZSample0019-Save')")
    @ApiOperation(value = "批量保存部门", tags = {"部门" },  notes = "批量保存部门")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0019s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0019DTO> ibizsample0019dtos) {
        ibizsample0019Service.saveBatch(ibizsample0019Mapping.toDomain(ibizsample0019dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0019-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0019-Get')")
	@ApiOperation(value = "获取默认", tags = {"部门" } ,notes = "获取默认")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0019s/fetchdefault")
	public ResponseEntity<List<IBIZSample0019DTO>> fetchDefault(IBIZSample0019SearchContext context) {
        Page<IBIZSample0019> domains = ibizsample0019Service.searchDefault(context) ;
        List<IBIZSample0019DTO> list = ibizsample0019Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0019-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0019-Get')")
	@ApiOperation(value = "查询默认", tags = {"部门" } ,notes = "查询默认")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0019s/searchdefault")
	public ResponseEntity<Page<IBIZSample0019DTO>> searchDefault(@RequestBody IBIZSample0019SearchContext context) {
        Page<IBIZSample0019> domains = ibizsample0019Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0019Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

