package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.DYNADASHBOARD;
import cn.ibizlab.core.sample.service.IDYNADASHBOARDService;
import cn.ibizlab.core.sample.filter.DYNADASHBOARDSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"动态数据看板" })
@RestController("DemoAPI-dynadashboard")
@RequestMapping("")
public class DYNADASHBOARDResource {

    @Autowired
    public IDYNADASHBOARDService dynadashboardService;

    @Autowired
    @Lazy
    public DYNADASHBOARDMapping dynadashboardMapping;

    @PreAuthorize("hasPermission(this.dynadashboardMapping.toDomain(#dynadashboarddto),'DemoSys-DYNADASHBOARD-Create')")
    @ApiOperation(value = "新建动态数据看板", tags = {"动态数据看板" },  notes = "新建动态数据看板")
	@RequestMapping(method = RequestMethod.POST, value = "/dynadashboards")
    public ResponseEntity<DYNADASHBOARDDTO> create(@Validated @RequestBody DYNADASHBOARDDTO dynadashboarddto) {
        DYNADASHBOARD domain = dynadashboardMapping.toDomain(dynadashboarddto);
		dynadashboardService.create(domain);
        DYNADASHBOARDDTO dto = dynadashboardMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.dynadashboardMapping.toDomain(#dynadashboarddtos),'DemoSys-DYNADASHBOARD-Create')")
    @ApiOperation(value = "批量新建动态数据看板", tags = {"动态数据看板" },  notes = "批量新建动态数据看板")
	@RequestMapping(method = RequestMethod.POST, value = "/dynadashboards/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<DYNADASHBOARDDTO> dynadashboarddtos) {
        dynadashboardService.createBatch(dynadashboardMapping.toDomain(dynadashboarddtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.dynadashboardMapping.toDomain(returnObject.body),'DemoSys-DYNADASHBOARD-Get')")
    @ApiOperation(value = "获取动态数据看板", tags = {"动态数据看板" },  notes = "获取动态数据看板")
	@RequestMapping(method = RequestMethod.GET, value = "/dynadashboards/{dynadashboard_id}")
    public ResponseEntity<DYNADASHBOARDDTO> get(@PathVariable("dynadashboard_id") String dynadashboard_id) {
        DYNADASHBOARD domain = dynadashboardService.get(dynadashboard_id);
        DYNADASHBOARDDTO dto = dynadashboardMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.dynadashboardService.get(#dynadashboard_id),'DemoSys-DYNADASHBOARD-Remove')")
    @ApiOperation(value = "删除动态数据看板", tags = {"动态数据看板" },  notes = "删除动态数据看板")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dynadashboards/{dynadashboard_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("dynadashboard_id") String dynadashboard_id) {
         return ResponseEntity.status(HttpStatus.OK).body(dynadashboardService.remove(dynadashboard_id));
    }

    @PreAuthorize("hasPermission(this.dynadashboardService.getDynadashboardByIds(#ids),'DemoSys-DYNADASHBOARD-Remove')")
    @ApiOperation(value = "批量删除动态数据看板", tags = {"动态数据看板" },  notes = "批量删除动态数据看板")
	@RequestMapping(method = RequestMethod.DELETE, value = "/dynadashboards/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        dynadashboardService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "dynadashboard" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.dynadashboardService.get(#dynadashboard_id),'DemoSys-DYNADASHBOARD-Update')")
    @ApiOperation(value = "更新动态数据看板", tags = {"动态数据看板" },  notes = "更新动态数据看板")
	@RequestMapping(method = RequestMethod.PUT, value = "/dynadashboards/{dynadashboard_id}")
    public ResponseEntity<DYNADASHBOARDDTO> update(@PathVariable("dynadashboard_id") String dynadashboard_id, @RequestBody DYNADASHBOARDDTO dynadashboarddto) {
		DYNADASHBOARD domain  = dynadashboardMapping.toDomain(dynadashboarddto);
        domain .setDynadashboardid(dynadashboard_id);
		dynadashboardService.update(domain );
		DYNADASHBOARDDTO dto = dynadashboardMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.dynadashboardService.getDynadashboardByEntities(this.dynadashboardMapping.toDomain(#dynadashboarddtos)),'DemoSys-DYNADASHBOARD-Update')")
    @ApiOperation(value = "批量更新动态数据看板", tags = {"动态数据看板" },  notes = "批量更新动态数据看板")
	@RequestMapping(method = RequestMethod.PUT, value = "/dynadashboards/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<DYNADASHBOARDDTO> dynadashboarddtos) {
        dynadashboardService.updateBatch(dynadashboardMapping.toDomain(dynadashboarddtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查动态数据看板", tags = {"动态数据看板" },  notes = "检查动态数据看板")
	@RequestMapping(method = RequestMethod.POST, value = "/dynadashboards/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody DYNADASHBOARDDTO dynadashboarddto) {
        return  ResponseEntity.status(HttpStatus.OK).body(dynadashboardService.checkKey(dynadashboardMapping.toDomain(dynadashboarddto)));
    }

    @ApiOperation(value = "获取动态数据看板草稿", tags = {"动态数据看板" },  notes = "获取动态数据看板草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/dynadashboards/getdraft")
    public ResponseEntity<DYNADASHBOARDDTO> getDraft(DYNADASHBOARDDTO dto) {
        DYNADASHBOARD domain = dynadashboardMapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(dynadashboardMapping.toDto(dynadashboardService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.dynadashboardMapping.toDomain(#dynadashboarddto),'DemoSys-DYNADASHBOARD-Save')")
    @ApiOperation(value = "保存动态数据看板", tags = {"动态数据看板" },  notes = "保存动态数据看板")
	@RequestMapping(method = RequestMethod.POST, value = "/dynadashboards/save")
    public ResponseEntity<DYNADASHBOARDDTO> save(@RequestBody DYNADASHBOARDDTO dynadashboarddto) {
        DYNADASHBOARD domain = dynadashboardMapping.toDomain(dynadashboarddto);
        dynadashboardService.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dynadashboardMapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.dynadashboardMapping.toDomain(#dynadashboarddtos),'DemoSys-DYNADASHBOARD-Save')")
    @ApiOperation(value = "批量保存动态数据看板", tags = {"动态数据看板" },  notes = "批量保存动态数据看板")
	@RequestMapping(method = RequestMethod.POST, value = "/dynadashboards/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<DYNADASHBOARDDTO> dynadashboarddtos) {
        dynadashboardService.saveBatch(dynadashboardMapping.toDomain(dynadashboarddtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-DYNADASHBOARD-searchDefault-all') and hasPermission(#context,'DemoSys-DYNADASHBOARD-Get')")
	@ApiOperation(value = "获取数据集", tags = {"动态数据看板" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/dynadashboards/fetchdefault")
	public ResponseEntity<List<DYNADASHBOARDDTO>> fetchDefault(DYNADASHBOARDSearchContext context) {
        Page<DYNADASHBOARD> domains = dynadashboardService.searchDefault(context) ;
        List<DYNADASHBOARDDTO> list = dynadashboardMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-DYNADASHBOARD-searchDefault-all') and hasPermission(#context,'DemoSys-DYNADASHBOARD-Get')")
	@ApiOperation(value = "查询数据集", tags = {"动态数据看板" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/dynadashboards/searchdefault")
	public ResponseEntity<Page<DYNADASHBOARDDTO>> searchDefault(@RequestBody DYNADASHBOARDSearchContext context) {
        Page<DYNADASHBOARD> domains = dynadashboardService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(dynadashboardMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

