package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZVIEWMESSDTO]
 */
@Data
public class IBIZVIEWMESSDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZVIEWMESSNAME]
     *
     */
    @JSONField(name = "ibizviewmessname")
    @JsonProperty("ibizviewmessname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizviewmessname;

    /**
     * 属性 [IBIZVIEWMESSID]
     *
     */
    @JSONField(name = "ibizviewmessid")
    @JsonProperty("ibizviewmessid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizviewmessid;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [DOCUMENTADDRESS]
     *
     */
    @JSONField(name = "documentaddress")
    @JsonProperty("documentaddress")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String documentaddress;

    /**
     * 属性 [INSTANCEADDRESS]
     *
     */
    @JSONField(name = "instanceaddress")
    @JsonProperty("instanceaddress")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String instanceaddress;

    /**
     * 属性 [VIEWTYPE]
     *
     */
    @JSONField(name = "viewtype")
    @JsonProperty("viewtype")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String viewtype;

    /**
     * 属性 [VIEWDESCRIPTION]
     *
     */
    @JSONField(name = "viewdescription")
    @JsonProperty("viewdescription")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String viewdescription;


    /**
     * 设置 [IBIZVIEWMESSNAME]
     */
    public void setIbizviewmessname(String  ibizviewmessname){
        this.ibizviewmessname = ibizviewmessname ;
        this.modify("ibizviewmessname",ibizviewmessname);
    }

    /**
     * 设置 [DOCUMENTADDRESS]
     */
    public void setDocumentaddress(String  documentaddress){
        this.documentaddress = documentaddress ;
        this.modify("documentaddress",documentaddress);
    }

    /**
     * 设置 [INSTANCEADDRESS]
     */
    public void setInstanceaddress(String  instanceaddress){
        this.instanceaddress = instanceaddress ;
        this.modify("instanceaddress",instanceaddress);
    }

    /**
     * 设置 [VIEWTYPE]
     */
    public void setViewtype(String  viewtype){
        this.viewtype = viewtype ;
        this.modify("viewtype",viewtype);
    }

    /**
     * 设置 [VIEWDESCRIPTION]
     */
    public void setViewdescription(String  viewdescription){
        this.viewdescription = viewdescription ;
        this.modify("viewdescription",viewdescription);
    }


}


