package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZUNIProductDTO]
 */
@Data
@ApiModel("统一产品（索引主实体）")
public class IBIZUNIProductDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UNITPRICE]
     *
     */
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    @ApiModelProperty("单价")
    private Double unitprice;

    /**
     * 属性 [IBIZUNIPRODUCTNAME]
     *
     */
    @JSONField(name = "ibizuniproductname")
    @JsonProperty("ibizuniproductname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("产品名称")
    private String ibizuniproductname;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [UNIT]
     *
     */
    @JSONField(name = "unit")
    @JsonProperty("unit")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("单位")
    private String unit;

    /**
     * 属性 [IBIZUNIPRODUCTTYPE]
     *
     */
    @JSONField(name = "ibizuniproducttype")
    @JsonProperty("ibizuniproducttype")
    @NotBlank(message = "[分组类型]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("分组类型")
    private String ibizuniproducttype;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("更新人")
    private String updateman;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("建立人")
    private String createman;

    /**
     * 属性 [IBIZUNIPRODUCTID]
     *
     */
    @JSONField(name = "ibizuniproductid")
    @JsonProperty("ibizuniproductid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("统一产品标识")
    private String ibizuniproductid;


    /**
     * 设置 [UNITPRICE]
     */
    public void setUnitprice(Double  unitprice){
        this.unitprice = unitprice ;
        this.modify("unitprice",unitprice);
    }

    /**
     * 设置 [IBIZUNIPRODUCTNAME]
     */
    public void setIbizuniproductname(String  ibizuniproductname){
        this.ibizuniproductname = ibizuniproductname ;
        this.modify("ibizuniproductname",ibizuniproductname);
    }

    /**
     * 设置 [UNIT]
     */
    public void setUnit(String  unit){
        this.unit = unit ;
        this.modify("unit",unit);
    }

    /**
     * 设置 [IBIZUNIPRODUCTTYPE]
     */
    public void setIbizuniproducttype(String  ibizuniproducttype){
        this.ibizuniproducttype = ibizuniproducttype ;
        this.modify("ibizuniproducttype",ibizuniproducttype);
    }


}


