import ViewMessageService from '../view-message-service';
/**
 * 实体列表视图视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg95MessageServiceBase
 */
export default class ViewMsg95MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg95MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg95MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg95MessageServiceBase
     */
    public initBasicParam(){
        this.id = "8ce2c305cf91409e03ab034a36e4afc0";
        this.name = "实体列表视图";
        this.codename = "ViewMsg95";
        this.title = "";
        this.content = "本示例展示实体列表视图基本功能。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg95MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}