import ViewMessageService from '../view-message-service';
/**
 * 后台界面行为视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg93MessageServiceBase
 */
export default class ViewMsg93MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg93MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg93MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg93MessageServiceBase
     */
    public initBasicParam(){
        this.id = "d9adf23e083ab3b58800a1c4b350969c";
        this.name = "后台界面行为";
        this.codename = "ViewMsg93";
        this.title = "";
        this.content = "本示例展示后台界面行为：保存。可自定义导航参数以进行后续逻辑处理。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg93MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}