import ViewMessageService from '../view-message-service';
/**
 * 树视图---静态节点视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg53MessageServiceBase
 */
export default class ViewMsg53MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg53MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg53MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg53MessageServiceBase
     */
    public initBasicParam(){
        this.id = "81b29d65fb9268e89347947a8f75abf5";
        this.name = "树视图---静态节点";
        this.codename = "ViewMsg53";
        this.title = "";
        this.content = "本示例展示树视图静态节点类型界面呈现。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg53MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}