import ViewMessageService from '../view-message-service';
/**
 * 表格值规则视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg5MessageServiceBase
 */
export default class ViewMsg5MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg5MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg5MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg5MessageServiceBase
     */
    public initBasicParam(){
        this.id = "c6336169ddd80427df3a95f3301a8ed1";
        this.name = "表格值规则";
        this.codename = "ViewMsg5";
        this.title = "";
        this.content = "本示例展示表格的值规则功能：图书名称不能为空。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg5MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}