/**
 * 视图消息服务注册中心
 * 基于 APP/src/message/message-service-register.ts.ftl 生成
 * @export
 * @class MessageServiceRegister
 */
export class MessageServiceRegister {

    /**
     * 所有视图消息服务Map
     *
     * @protected
     * @type {*}
     * @memberof MessageServiceRegister
     */
    protected allMessageService: Map<string, () => Promise<any>> = new Map();

    /**
     * 已加载视图消息服务Map缓存
     *
     * @protected
     * @type {Map<string, any>}
     * @memberof MessageServiceRegister
     */
    protected serviceCache: Map<string, any> = new Map();

    /**
     * Creates an instance of MessageServiceRegister.
     * @memberof MessageServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof MessageServiceRegister
     */
    protected init(): void {
                this.allMessageService.set('DataViewDar', () => import('@/message/data-view-dar/data-view-dar-message'));
        this.allMessageService.set('ViewMsg', () => import('@/message/view-msg/view-msg-message'));
        this.allMessageService.set('ViewMsg10', () => import('@/message/view-msg10/view-msg10-message'));
        this.allMessageService.set('ViewMsg11', () => import('@/message/view-msg11/view-msg11-message'));
        this.allMessageService.set('ViewMsg12', () => import('@/message/view-msg12/view-msg12-message'));
        this.allMessageService.set('ViewMsg13', () => import('@/message/view-msg13/view-msg13-message'));
        this.allMessageService.set('ViewMsg14', () => import('@/message/view-msg14/view-msg14-message'));
        this.allMessageService.set('ViewMsg15', () => import('@/message/view-msg15/view-msg15-message'));
        this.allMessageService.set('ViewMsg16', () => import('@/message/view-msg16/view-msg16-message'));
        this.allMessageService.set('ViewMsg17', () => import('@/message/view-msg17/view-msg17-message'));
        this.allMessageService.set('ViewMsg18', () => import('@/message/view-msg18/view-msg18-message'));
        this.allMessageService.set('ViewMsg19', () => import('@/message/view-msg19/view-msg19-message'));
        this.allMessageService.set('ViewMsg2', () => import('@/message/view-msg2/view-msg2-message'));
        this.allMessageService.set('ViewMsg20', () => import('@/message/view-msg20/view-msg20-message'));
        this.allMessageService.set('ViewMsg21', () => import('@/message/view-msg21/view-msg21-message'));
        this.allMessageService.set('ViewMsg22', () => import('@/message/view-msg22/view-msg22-message'));
        this.allMessageService.set('ViewMsg23', () => import('@/message/view-msg23/view-msg23-message'));
        this.allMessageService.set('ViewMsg24', () => import('@/message/view-msg24/view-msg24-message'));
        this.allMessageService.set('ViewMsg25', () => import('@/message/view-msg25/view-msg25-message'));
        this.allMessageService.set('ViewMsg26', () => import('@/message/view-msg26/view-msg26-message'));
        this.allMessageService.set('ViewMsg27', () => import('@/message/view-msg27/view-msg27-message'));
        this.allMessageService.set('ViewMsg28', () => import('@/message/view-msg28/view-msg28-message'));
        this.allMessageService.set('ViewMsg29', () => import('@/message/view-msg29/view-msg29-message'));
        this.allMessageService.set('ViewMsg3', () => import('@/message/view-msg3/view-msg3-message'));
        this.allMessageService.set('ViewMsg30', () => import('@/message/view-msg30/view-msg30-message'));
        this.allMessageService.set('ViewMsg31', () => import('@/message/view-msg31/view-msg31-message'));
        this.allMessageService.set('ViewMsg32', () => import('@/message/view-msg32/view-msg32-message'));
        this.allMessageService.set('ViewMsg33', () => import('@/message/view-msg33/view-msg33-message'));
        this.allMessageService.set('ViewMsg34', () => import('@/message/view-msg34/view-msg34-message'));
        this.allMessageService.set('ViewMsg35', () => import('@/message/view-msg35/view-msg35-message'));
        this.allMessageService.set('ViewMsg36', () => import('@/message/view-msg36/view-msg36-message'));
        this.allMessageService.set('ViewMsg37', () => import('@/message/view-msg37/view-msg37-message'));
        this.allMessageService.set('ViewMsg38', () => import('@/message/view-msg38/view-msg38-message'));
        this.allMessageService.set('ViewMsg39', () => import('@/message/view-msg39/view-msg39-message'));
        this.allMessageService.set('ViewMsg4', () => import('@/message/view-msg4/view-msg4-message'));
        this.allMessageService.set('ViewMsg40', () => import('@/message/view-msg40/view-msg40-message'));
        this.allMessageService.set('ViewMsg41', () => import('@/message/view-msg41/view-msg41-message'));
        this.allMessageService.set('ViewMsg42', () => import('@/message/view-msg42/view-msg42-message'));
        this.allMessageService.set('ViewMsg43', () => import('@/message/view-msg43/view-msg43-message'));
        this.allMessageService.set('ViewMsg44', () => import('@/message/view-msg44/view-msg44-message'));
        this.allMessageService.set('ViewMsg45', () => import('@/message/view-msg45/view-msg45-message'));
        this.allMessageService.set('ViewMsg46', () => import('@/message/view-msg46/view-msg46-message'));
        this.allMessageService.set('ViewMsg47', () => import('@/message/view-msg47/view-msg47-message'));
        this.allMessageService.set('ViewMsg48', () => import('@/message/view-msg48/view-msg48-message'));
        this.allMessageService.set('ViewMsg49', () => import('@/message/view-msg49/view-msg49-message'));
        this.allMessageService.set('ViewMsg5', () => import('@/message/view-msg5/view-msg5-message'));
        this.allMessageService.set('ViewMsg50', () => import('@/message/view-msg50/view-msg50-message'));
        this.allMessageService.set('ViewMsg51', () => import('@/message/view-msg51/view-msg51-message'));
        this.allMessageService.set('ViewMsg52', () => import('@/message/view-msg52/view-msg52-message'));
        this.allMessageService.set('ViewMsg53', () => import('@/message/view-msg53/view-msg53-message'));
        this.allMessageService.set('ViewMsg54', () => import('@/message/view-msg54/view-msg54-message'));
        this.allMessageService.set('ViewMsg55', () => import('@/message/view-msg55/view-msg55-message'));
        this.allMessageService.set('ViewMsg56', () => import('@/message/view-msg56/view-msg56-message'));
        this.allMessageService.set('ViewMsg57', () => import('@/message/view-msg57/view-msg57-message'));
        this.allMessageService.set('ViewMsg58', () => import('@/message/view-msg58/view-msg58-message'));
        this.allMessageService.set('ViewMsg59', () => import('@/message/view-msg59/view-msg59-message'));
        this.allMessageService.set('ViewMsg6', () => import('@/message/view-msg6/view-msg6-message'));
        this.allMessageService.set('ViewMsg60', () => import('@/message/view-msg60/view-msg60-message'));
        this.allMessageService.set('ViewMsg61', () => import('@/message/view-msg61/view-msg61-message'));
        this.allMessageService.set('ViewMsg62', () => import('@/message/view-msg62/view-msg62-message'));
        this.allMessageService.set('ViewMsg63', () => import('@/message/view-msg63/view-msg63-message'));
        this.allMessageService.set('ViewMsg64', () => import('@/message/view-msg64/view-msg64-message'));
        this.allMessageService.set('ViewMsg65', () => import('@/message/view-msg65/view-msg65-message'));
        this.allMessageService.set('ViewMsg66', () => import('@/message/view-msg66/view-msg66-message'));
        this.allMessageService.set('ViewMsg67', () => import('@/message/view-msg67/view-msg67-message'));
        this.allMessageService.set('ViewMsg68', () => import('@/message/view-msg68/view-msg68-message'));
        this.allMessageService.set('ViewMsg69', () => import('@/message/view-msg69/view-msg69-message'));
        this.allMessageService.set('ViewMsg7', () => import('@/message/view-msg7/view-msg7-message'));
        this.allMessageService.set('ViewMsg70', () => import('@/message/view-msg70/view-msg70-message'));
        this.allMessageService.set('ViewMsg71', () => import('@/message/view-msg71/view-msg71-message'));
        this.allMessageService.set('ViewMsg72', () => import('@/message/view-msg72/view-msg72-message'));
        this.allMessageService.set('ViewMsg73', () => import('@/message/view-msg73/view-msg73-message'));
        this.allMessageService.set('ViewMsg74', () => import('@/message/view-msg74/view-msg74-message'));
        this.allMessageService.set('ViewMsg75', () => import('@/message/view-msg75/view-msg75-message'));
        this.allMessageService.set('ViewMsg76', () => import('@/message/view-msg76/view-msg76-message'));
        this.allMessageService.set('ViewMsg77', () => import('@/message/view-msg77/view-msg77-message'));
        this.allMessageService.set('ViewMsg78', () => import('@/message/view-msg78/view-msg78-message'));
        this.allMessageService.set('ViewMsg79', () => import('@/message/view-msg79/view-msg79-message'));
        this.allMessageService.set('ViewMsg8', () => import('@/message/view-msg8/view-msg8-message'));
        this.allMessageService.set('ViewMsg80', () => import('@/message/view-msg80/view-msg80-message'));
        this.allMessageService.set('ViewMsg81', () => import('@/message/view-msg81/view-msg81-message'));
        this.allMessageService.set('ViewMsg82', () => import('@/message/view-msg82/view-msg82-message'));
        this.allMessageService.set('ViewMsg83', () => import('@/message/view-msg83/view-msg83-message'));
        this.allMessageService.set('ViewMsg84', () => import('@/message/view-msg84/view-msg84-message'));
        this.allMessageService.set('ViewMsg85', () => import('@/message/view-msg85/view-msg85-message'));
        this.allMessageService.set('ViewMsg86', () => import('@/message/view-msg86/view-msg86-message'));
        this.allMessageService.set('ViewMsg87', () => import('@/message/view-msg87/view-msg87-message'));
        this.allMessageService.set('ViewMsg88', () => import('@/message/view-msg88/view-msg88-message'));
        this.allMessageService.set('ViewMsg89', () => import('@/message/view-msg89/view-msg89-message'));
        this.allMessageService.set('ViewMsg9', () => import('@/message/view-msg9/view-msg9-message'));
        this.allMessageService.set('ViewMsg90', () => import('@/message/view-msg90/view-msg90-message'));
        this.allMessageService.set('ViewMsg91', () => import('@/message/view-msg91/view-msg91-message'));
        this.allMessageService.set('ViewMsg92', () => import('@/message/view-msg92/view-msg92-message'));
        this.allMessageService.set('ViewMsg93', () => import('@/message/view-msg93/view-msg93-message'));
        this.allMessageService.set('ViewMsg94', () => import('@/message/view-msg94/view-msg94-message'));
        this.allMessageService.set('ViewMsg95', () => import('@/message/view-msg95/view-msg95-message'));
        this.allMessageService.set('ViewMsg96', () => import('@/message/view-msg96/view-msg96-message'));
        this.allMessageService.set('ViewMsg97', () => import('@/message/view-msg97/view-msg97-message'));
    }

    /**
     * 加载视图消息服务
     *
     * @protected
     * @param {string} codeName
     * @returns {Promise<any>}
     * @memberof MessageServiceRegister
     */
    protected async loadService(codeName: string): Promise<any> {
        const service = this.allMessageService.get(codeName);
        if (service) {
            return service();
        }
    }

    /**
     * 获取视图消息服务
     *
     * @param {string} name
     * @returns {Promise<any>}
     * @memberof MessageServiceRegister
     */
    public async getService(name: string): Promise<any> {
        if (this.serviceCache.has(name)) {
            return this.serviceCache.get(name);
        }
        const messageService: any = await this.loadService(name);
        if (messageService && messageService.default) {
            const instance: any = new messageService.default();
            this.serviceCache.set(name, instance);
            return instance;
        }
    }

}
export const messageServiceRegister: MessageServiceRegister = new MessageServiceRegister();