import ViewMessageService from '../view-message-service';
/**
 * 列表自定义插件视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg74MessageServiceBase
 */
export default class ViewMsg74MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg74MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg74MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg74MessageServiceBase
     */
    public initBasicParam(){
        this.id = "62dca197c83003423444ea0626935703";
        this.name = "列表自定义插件";
        this.codename = "ViewMsg74";
        this.title = "";
        this.content = "本示例展示列表自定义插件。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg74MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}