import ViewMessageService from '../view-message-service';
/**
 * 日历导航--默认视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg46MessageServiceBase
 */
export default class ViewMsg46MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg46MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg46MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg46MessageServiceBase
     */
    public initBasicParam(){
        this.id = "ac45aa98ab1b637f361599c81c409e9e";
        this.name = "日历导航--默认";
        this.codename = "ViewMsg46";
        this.title = "";
        this.content = "本示例展示日历导航的内置功能，包含搜索栏、部件工具栏、导航关系等。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg46MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}