import ViewMessageService from '../view-message-service';
/**
 * 表格导航视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg43MessageServiceBase
 */
export default class ViewMsg43MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg43MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg43MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg43MessageServiceBase
     */
    public initBasicParam(){
        this.id = "ef5924fcb2e7b0f8e6f0bff364c149cb";
        this.name = "表格导航";
        this.codename = "ViewMsg43";
        this.title = "";
        this.content = "本示例展示表格导航的内置功能：包含快速分组、搜索栏、部件工具栏、导航关系等。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg43MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}