import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import AppMenuModel from './app-menu-appmenu-model';


/**
 * AppMenu 部件服务对象
 *
 * @export
 * @class AppMenuService
 */
export default class AppMenuService extends ControlService {

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof AppMenuService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of AppMenuService.
     * 
     * @param {*} [opts={}]
     * @memberof AppMenuService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new AppMenuModel();
    }

    /**
     * 获取数据
     *
     * @returns {Promise<any>}
     * @memberof AppMenu
     */
    @Errorlog
    public get(params: any = {}): Promise<any> {
        return Http.getInstance().get('v7/app-menuappmenu', params);
    }

}