/**
 * AppMenu 部件模型
 *
 * @export
 * @class AppMenuModel
 */
export default class AppMenuModel {

    /**
     * 菜单项集合
     *
     * @public
     * @type {any[]}
     * @memberof AppMenuModel
     */
    public items: any[] = [
        {
	id: '161CE06C-7FEB-4D3A-908A-EA2756104A50',
	name: 'menuitem1',
	text: '应用菜单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '应用菜单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	authtag:'Web-appMenu-menuitem1',
	items: [
		{
	id: '00926656-BCDE-45AF-B381-3B465E80D8EB',
	name: 'menuitem2',
	text: '打开文档',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '打开文档',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-twitter',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc93',
	resourcetag: '',
	authtag:'Web-appMenu-menuitem2',
},
	],
},
    ];

	/**
	 * 应用功能集合
	 *
	 * @public
	 * @type {any[]}
	 * @memberof AppMenuModel
	 */
	public funcs: any[] = [
	];

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof AppMenuModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof AppMenuModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}