import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import QUICKMENUBARModel from './quickmenubar-appmenu-model';


/**
 * QUICKMENUBAR 部件服务对象
 *
 * @export
 * @class QUICKMENUBARService
 */
export default class QUICKMENUBARService extends ControlService {

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof QUICKMENUBARService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of QUICKMENUBARService.
     * 
     * @param {*} [opts={}]
     * @memberof QUICKMENUBARService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new QUICKMENUBARModel();
    }

    /**
     * 获取数据
     *
     * @returns {Promise<any>}
     * @memberof QUICKMENUBAR
     */
    @Errorlog
    public get(params: any = {}): Promise<any> {
        return Http.getInstance().get('v7/quickmenubarappmenu', params);
    }

}