package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZCustomer_INTF;
import cn.ibizlab.core.sample.service.IIBIZCustomer_INTFService;
import cn.ibizlab.core.sample.filter.IBIZCustomer_INTFSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"客户" })
@RestController("DemoAPI-ibizcustomer_intf")
@RequestMapping("")
public class IBIZCustomer_INTFResource {

    @Autowired
    public IIBIZCustomer_INTFService ibizcustomer_intfService;

    @Autowired
    @Lazy
    public IBIZCustomer_INTFMapping ibizcustomer_intfMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-searchCurCustomer-all') and hasPermission(#context,'DemoSys-IBIZCustomer_INTF-Get')")
	@ApiOperation(value = "获取CurCustomer", tags = {"客户" } ,notes = "获取CurCustomer")
    @RequestMapping(method= RequestMethod.POST , value="/ibizcustomer_intfs/fetchcurcustomer")
	public ResponseEntity<List<IBIZCustomer_INTFDTO>> fetchCurCustomer(IBIZCustomer_INTFSearchContext context) {
        Page<IBIZCustomer_INTF> domains = ibizcustomer_intfService.searchCurCustomer(context) ;
        List<IBIZCustomer_INTFDTO> list = ibizcustomer_intfMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-searchCurCustomer-all') and hasPermission(#context,'DemoSys-IBIZCustomer_INTF-Get')")
	@ApiOperation(value = "查询CurCustomer", tags = {"客户" } ,notes = "查询CurCustomer")
    @RequestMapping(method= RequestMethod.POST , value="/ibizcustomer_intfs/searchcurcustomer")
	public ResponseEntity<Page<IBIZCustomer_INTFDTO>> searchCurCustomer(@RequestBody IBIZCustomer_INTFSearchContext context) {
        Page<IBIZCustomer_INTF> domains = ibizcustomer_intfService.searchCurCustomer(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizcustomer_intfMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PostAuthorize("hasPermission(this.ibizcustomer_intfMapping.toDomain(returnObject.body),'DemoSys-IBIZCustomer_INTF-Get')")
    @ApiOperation(value = "获取客户", tags = {"客户" },  notes = "获取客户")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizcustomer_intfs/{ibizcustomer_intf_id}")
    public ResponseEntity<IBIZCustomer_INTFDTO> get(@PathVariable("ibizcustomer_intf_id") String ibizcustomer_intf_id) {
        IBIZCustomer_INTF domain = ibizcustomer_intfService.get(ibizcustomer_intf_id);
        IBIZCustomer_INTFDTO dto = ibizcustomer_intfMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizcustomer_intfMapping.toDomain(#ibizcustomer_intfdto),'DemoSys-IBIZCustomer_INTF-Create')")
    @ApiOperation(value = "新建客户", tags = {"客户" },  notes = "新建客户")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomer_intfs")
    public ResponseEntity<IBIZCustomer_INTFDTO> create(@Validated @RequestBody IBIZCustomer_INTFDTO ibizcustomer_intfdto) {
        IBIZCustomer_INTF domain = ibizcustomer_intfMapping.toDomain(ibizcustomer_intfdto);
		ibizcustomer_intfService.create(domain);
        IBIZCustomer_INTFDTO dto = ibizcustomer_intfMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizcustomer_intfMapping.toDomain(#ibizcustomer_intfdtos),'DemoSys-IBIZCustomer_INTF-Create')")
    @ApiOperation(value = "批量新建客户", tags = {"客户" },  notes = "批量新建客户")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomer_intfs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZCustomer_INTFDTO> ibizcustomer_intfdtos) {
        ibizcustomer_intfService.createBatch(ibizcustomer_intfMapping.toDomain(ibizcustomer_intfdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizcustomer_intf" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizcustomer_intfService.get(#ibizcustomer_intf_id),'DemoSys-IBIZCustomer_INTF-Update')")
    @ApiOperation(value = "更新客户", tags = {"客户" },  notes = "更新客户")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizcustomer_intfs/{ibizcustomer_intf_id}")
    public ResponseEntity<IBIZCustomer_INTFDTO> update(@PathVariable("ibizcustomer_intf_id") String ibizcustomer_intf_id, @RequestBody IBIZCustomer_INTFDTO ibizcustomer_intfdto) {
		IBIZCustomer_INTF domain  = ibizcustomer_intfMapping.toDomain(ibizcustomer_intfdto);
        domain .setIbizcustomerid(ibizcustomer_intf_id);
		ibizcustomer_intfService.update(domain );
		IBIZCustomer_INTFDTO dto = ibizcustomer_intfMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizcustomer_intfService.getIbizcustomerIntfByEntities(this.ibizcustomer_intfMapping.toDomain(#ibizcustomer_intfdtos)),'DemoSys-IBIZCustomer_INTF-Update')")
    @ApiOperation(value = "批量更新客户", tags = {"客户" },  notes = "批量更新客户")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizcustomer_intfs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZCustomer_INTFDTO> ibizcustomer_intfdtos) {
        ibizcustomer_intfService.updateBatch(ibizcustomer_intfMapping.toDomain(ibizcustomer_intfdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizcustomer_intfService.get(#ibizcustomer_intf_id),'DemoSys-IBIZCustomer_INTF-Remove')")
    @ApiOperation(value = "删除客户", tags = {"客户" },  notes = "删除客户")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizcustomer_intfs/{ibizcustomer_intf_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizcustomer_intf_id") String ibizcustomer_intf_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizcustomer_intfService.remove(ibizcustomer_intf_id));
    }

    @PreAuthorize("hasPermission(this.ibizcustomer_intfService.getIbizcustomerIntfByIds(#ids),'DemoSys-IBIZCustomer_INTF-Remove')")
    @ApiOperation(value = "批量删除客户", tags = {"客户" },  notes = "批量删除客户")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizcustomer_intfs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizcustomer_intfService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "获取客户草稿", tags = {"客户" },  notes = "获取客户草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizcustomer_intfs/getdraft")
    public ResponseEntity<IBIZCustomer_INTFDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizcustomer_intfMapping.toDto(ibizcustomer_intfService.getDraft(new IBIZCustomer_INTF())));
    }

    @ApiOperation(value = "检查客户", tags = {"客户" },  notes = "检查客户")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomer_intfs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZCustomer_INTFDTO ibizcustomer_intfdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizcustomer_intfService.checkKey(ibizcustomer_intfMapping.toDomain(ibizcustomer_intfdto)));
    }

    @PreAuthorize("hasPermission(this.ibizcustomer_intfMapping.toDomain(#ibizcustomer_intfdto),'DemoSys-IBIZCustomer_INTF-Save')")
    @ApiOperation(value = "保存客户", tags = {"客户" },  notes = "保存客户")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomer_intfs/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZCustomer_INTFDTO ibizcustomer_intfdto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizcustomer_intfService.save(ibizcustomer_intfMapping.toDomain(ibizcustomer_intfdto)));
    }

    @PreAuthorize("hasPermission(this.ibizcustomer_intfMapping.toDomain(#ibizcustomer_intfdtos),'DemoSys-IBIZCustomer_INTF-Save')")
    @ApiOperation(value = "批量保存客户", tags = {"客户" },  notes = "批量保存客户")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomer_intfs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZCustomer_INTFDTO> ibizcustomer_intfdtos) {
        ibizcustomer_intfService.saveBatch(ibizcustomer_intfMapping.toDomain(ibizcustomer_intfdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-XXX-all')")
    @ApiOperation(value = "", tags = {"客户" },  notes = "")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomer_intfs/{ibizcustomer_intf_id}/xxx")
    public ResponseEntity<IBIZCustomer_INTFDTO> xXX(@PathVariable("ibizcustomer_intf_id") String ibizcustomer_intf_id, @RequestBody IBIZCustomer_INTFDTO ibizcustomer_intfdto) {
        IBIZCustomer_INTF domain = ibizcustomer_intfMapping.toDomain(ibizcustomer_intfdto);
        domain.setIbizcustomerid(ibizcustomer_intf_id);
        domain = ibizcustomer_intfService.xXX(domain);
        ibizcustomer_intfdto = ibizcustomer_intfMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizcustomer_intfdto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZCustomer_INTF-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"客户" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizcustomer_intfs/fetchdefault")
	public ResponseEntity<List<IBIZCustomer_INTFDTO>> fetchDefault(IBIZCustomer_INTFSearchContext context) {
        Page<IBIZCustomer_INTF> domains = ibizcustomer_intfService.searchDefault(context) ;
        List<IBIZCustomer_INTFDTO> list = ibizcustomer_intfMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZCustomer_INTF-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"客户" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizcustomer_intfs/searchdefault")
	public ResponseEntity<Page<IBIZCustomer_INTFDTO>> searchDefault(@RequestBody IBIZCustomer_INTFSearchContext context) {
        Page<IBIZCustomer_INTF> domains = ibizcustomer_intfService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizcustomer_intfMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

