import { PanelDetailModel } from './panel-detail';

/**
 * 按钮模型
 *
 * @export
 * @class PanelButtonModel
 * @extends {PanelDetailModel}
 */
export class PanelButtonModel extends PanelDetailModel {

    constructor(opts: any = {}) {
        super(opts);
        this.uiaction = opts.uiaction;
        this.buttonStyle = opts.buttonStyle;
        this.renderMode = opts.renderMode;
    }

    /**
     * 按钮对应的界面行为
     *
     * @type {*}
     * @memberof PanelButtonModel
     */
    public uiaction:any;


    /**
     * @description 按钮类型
     * @type {string}
     * @memberof PanelButtonModel
     */
    public buttonStyle: 'DEFAULT' | 'INVERSE' | 'PRIMARY' | 'INFO' | 'SUCCESS' | 'WARNING' | 'DANGER' | 'STYLE2' | 'STYLE3' | 'STYLE4';

    /**
     * @description 绘制模式
     * @type {string}
     * @memberof PanelButtonModel
     */
    public renderMode: 'BUTTON' | 'LINK';

}