package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0016;
import cn.ibizlab.core.sample.service.IIBIZSample0016Service;
import cn.ibizlab.core.sample.filter.IBIZSample0016SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"项目成员" })
@RestController("DemoAPI-ibizsample0016")
@RequestMapping("")
public class IBIZSample0016Resource {

    @Autowired
    public IIBIZSample0016Service ibizsample0016Service;

    @Autowired
    @Lazy
    public IBIZSample0016Mapping ibizsample0016Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0016Mapping.toDomain(#ibizsample0016dto),'DemoSys-IBIZSample0016-Create')")
    @ApiOperation(value = "新建项目成员", tags = {"项目成员" },  notes = "新建项目成员")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0016s")
    public ResponseEntity<IBIZSample0016DTO> create(@Validated @RequestBody IBIZSample0016DTO ibizsample0016dto) {
        IBIZSample0016 domain = ibizsample0016Mapping.toDomain(ibizsample0016dto);
		ibizsample0016Service.create(domain);
        IBIZSample0016DTO dto = ibizsample0016Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0016Mapping.toDomain(#ibizsample0016dtos),'DemoSys-IBIZSample0016-Create')")
    @ApiOperation(value = "批量新建项目成员", tags = {"项目成员" },  notes = "批量新建项目成员")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0016s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0016DTO> ibizsample0016dtos) {
        ibizsample0016Service.createBatch(ibizsample0016Mapping.toDomain(ibizsample0016dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0016" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0016Service.get(#ibizsample0016_id),'DemoSys-IBIZSample0016-Update')")
    @ApiOperation(value = "更新项目成员", tags = {"项目成员" },  notes = "更新项目成员")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0016s/{ibizsample0016_id}")
    public ResponseEntity<IBIZSample0016DTO> update(@PathVariable("ibizsample0016_id") String ibizsample0016_id, @RequestBody IBIZSample0016DTO ibizsample0016dto) {
		IBIZSample0016 domain  = ibizsample0016Mapping.toDomain(ibizsample0016dto);
        domain .setIbizsample0016id(ibizsample0016_id);
		ibizsample0016Service.update(domain );
		IBIZSample0016DTO dto = ibizsample0016Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0016Service.getIbizsample0016ByEntities(this.ibizsample0016Mapping.toDomain(#ibizsample0016dtos)),'DemoSys-IBIZSample0016-Update')")
    @ApiOperation(value = "批量更新项目成员", tags = {"项目成员" },  notes = "批量更新项目成员")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0016s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0016DTO> ibizsample0016dtos) {
        ibizsample0016Service.updateBatch(ibizsample0016Mapping.toDomain(ibizsample0016dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0016Service.get(#ibizsample0016_id),'DemoSys-IBIZSample0016-Remove')")
    @ApiOperation(value = "删除项目成员", tags = {"项目成员" },  notes = "删除项目成员")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0016s/{ibizsample0016_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0016_id") String ibizsample0016_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0016Service.remove(ibizsample0016_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0016Service.getIbizsample0016ByIds(#ids),'DemoSys-IBIZSample0016-Remove')")
    @ApiOperation(value = "批量删除项目成员", tags = {"项目成员" },  notes = "批量删除项目成员")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0016s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0016Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0016Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0016-Get')")
    @ApiOperation(value = "获取项目成员", tags = {"项目成员" },  notes = "获取项目成员")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0016s/{ibizsample0016_id}")
    public ResponseEntity<IBIZSample0016DTO> get(@PathVariable("ibizsample0016_id") String ibizsample0016_id) {
        IBIZSample0016 domain = ibizsample0016Service.get(ibizsample0016_id);
        IBIZSample0016DTO dto = ibizsample0016Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取项目成员草稿", tags = {"项目成员" },  notes = "获取项目成员草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0016s/getdraft")
    public ResponseEntity<IBIZSample0016DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0016Mapping.toDto(ibizsample0016Service.getDraft(new IBIZSample0016())));
    }

    @ApiOperation(value = "检查项目成员", tags = {"项目成员" },  notes = "检查项目成员")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0016s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0016DTO ibizsample0016dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0016Service.checkKey(ibizsample0016Mapping.toDomain(ibizsample0016dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0016Mapping.toDomain(#ibizsample0016dto),'DemoSys-IBIZSample0016-Save')")
    @ApiOperation(value = "保存项目成员", tags = {"项目成员" },  notes = "保存项目成员")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0016s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0016DTO ibizsample0016dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0016Service.save(ibizsample0016Mapping.toDomain(ibizsample0016dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0016Mapping.toDomain(#ibizsample0016dtos),'DemoSys-IBIZSample0016-Save')")
    @ApiOperation(value = "批量保存项目成员", tags = {"项目成员" },  notes = "批量保存项目成员")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0016s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0016DTO> ibizsample0016dtos) {
        ibizsample0016Service.saveBatch(ibizsample0016Mapping.toDomain(ibizsample0016dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0016-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0016-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"项目成员" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0016s/fetchdefault")
	public ResponseEntity<List<IBIZSample0016DTO>> fetchDefault(IBIZSample0016SearchContext context) {
        Page<IBIZSample0016> domains = ibizsample0016Service.searchDefault(context) ;
        List<IBIZSample0016DTO> list = ibizsample0016Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0016-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0016-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"项目成员" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0016s/searchdefault")
	public ResponseEntity<Page<IBIZSample0016DTO>> searchDefault(@RequestBody IBIZSample0016SearchContext context) {
        Page<IBIZSample0016> domains = ibizsample0016Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0016Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

