package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0011;
import cn.ibizlab.core.sample.service.IIBIZSample0011Service;
import cn.ibizlab.core.sample.filter.IBIZSample0011SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单明细" })
@RestController("DemoAPI-ibizsample0011")
@RequestMapping("")
public class IBIZSample0011Resource {

    @Autowired
    public IIBIZSample0011Service ibizsample0011Service;

    @Autowired
    @Lazy
    public IBIZSample0011Mapping ibizsample0011Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0011Mapping.toDomain(#ibizsample0011dto),'DemoSys-IBIZSample0011-Create')")
    @ApiOperation(value = "新建订单明细", tags = {"订单明细" },  notes = "新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0011s")
    public ResponseEntity<IBIZSample0011DTO> create(@Validated @RequestBody IBIZSample0011DTO ibizsample0011dto) {
        IBIZSample0011 domain = ibizsample0011Mapping.toDomain(ibizsample0011dto);
		ibizsample0011Service.create(domain);
        IBIZSample0011DTO dto = ibizsample0011Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0011Mapping.toDomain(#ibizsample0011dtos),'DemoSys-IBIZSample0011-Create')")
    @ApiOperation(value = "批量新建订单明细", tags = {"订单明细" },  notes = "批量新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0011s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0011DTO> ibizsample0011dtos) {
        ibizsample0011Service.createBatch(ibizsample0011Mapping.toDomain(ibizsample0011dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0011" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0011Service.get(#ibizsample0011_id),'DemoSys-IBIZSample0011-Update')")
    @ApiOperation(value = "更新订单明细", tags = {"订单明细" },  notes = "更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0011s/{ibizsample0011_id}")
    public ResponseEntity<IBIZSample0011DTO> update(@PathVariable("ibizsample0011_id") String ibizsample0011_id, @RequestBody IBIZSample0011DTO ibizsample0011dto) {
		IBIZSample0011 domain  = ibizsample0011Mapping.toDomain(ibizsample0011dto);
        domain .setIbizsample0011id(ibizsample0011_id);
		ibizsample0011Service.update(domain );
		IBIZSample0011DTO dto = ibizsample0011Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0011Service.getIbizsample0011ByEntities(this.ibizsample0011Mapping.toDomain(#ibizsample0011dtos)),'DemoSys-IBIZSample0011-Update')")
    @ApiOperation(value = "批量更新订单明细", tags = {"订单明细" },  notes = "批量更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0011s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0011DTO> ibizsample0011dtos) {
        ibizsample0011Service.updateBatch(ibizsample0011Mapping.toDomain(ibizsample0011dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0011Service.get(#ibizsample0011_id),'DemoSys-IBIZSample0011-Remove')")
    @ApiOperation(value = "删除订单明细", tags = {"订单明细" },  notes = "删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0011s/{ibizsample0011_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0011_id") String ibizsample0011_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0011Service.remove(ibizsample0011_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0011Service.getIbizsample0011ByIds(#ids),'DemoSys-IBIZSample0011-Remove')")
    @ApiOperation(value = "批量删除订单明细", tags = {"订单明细" },  notes = "批量删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0011s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0011Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0011Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0011-Get')")
    @ApiOperation(value = "获取订单明细", tags = {"订单明细" },  notes = "获取订单明细")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0011s/{ibizsample0011_id}")
    public ResponseEntity<IBIZSample0011DTO> get(@PathVariable("ibizsample0011_id") String ibizsample0011_id) {
        IBIZSample0011 domain = ibizsample0011Service.get(ibizsample0011_id);
        IBIZSample0011DTO dto = ibizsample0011Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取订单明细草稿", tags = {"订单明细" },  notes = "获取订单明细草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0011s/getdraft")
    public ResponseEntity<IBIZSample0011DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0011Mapping.toDto(ibizsample0011Service.getDraft(new IBIZSample0011())));
    }

    @ApiOperation(value = "检查订单明细", tags = {"订单明细" },  notes = "检查订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0011s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0011DTO ibizsample0011dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0011Service.checkKey(ibizsample0011Mapping.toDomain(ibizsample0011dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0011Mapping.toDomain(#ibizsample0011dto),'DemoSys-IBIZSample0011-Save')")
    @ApiOperation(value = "保存订单明细", tags = {"订单明细" },  notes = "保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0011s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0011DTO ibizsample0011dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0011Service.save(ibizsample0011Mapping.toDomain(ibizsample0011dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0011Mapping.toDomain(#ibizsample0011dtos),'DemoSys-IBIZSample0011-Save')")
    @ApiOperation(value = "批量保存订单明细", tags = {"订单明细" },  notes = "批量保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0011s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0011DTO> ibizsample0011dtos) {
        ibizsample0011Service.saveBatch(ibizsample0011Mapping.toDomain(ibizsample0011dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0011-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0011-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"订单明细" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0011s/fetchdefault")
	public ResponseEntity<List<IBIZSample0011DTO>> fetchDefault(IBIZSample0011SearchContext context) {
        Page<IBIZSample0011> domains = ibizsample0011Service.searchDefault(context) ;
        List<IBIZSample0011DTO> list = ibizsample0011Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0011-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0011-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"订单明细" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0011s/searchdefault")
	public ResponseEntity<Page<IBIZSample0011DTO>> searchDefault(@RequestBody IBIZSample0011SearchContext context) {
        Page<IBIZSample0011> domains = ibizsample0011Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0011Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

