package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0009;
import cn.ibizlab.core.sample.service.IIBIZSample0009Service;
import cn.ibizlab.core.sample.filter.IBIZSample0009SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"商品价格明细" })
@RestController("DemoAPI-ibizsample0009")
@RequestMapping("")
public class IBIZSample0009Resource {

    @Autowired
    public IIBIZSample0009Service ibizsample0009Service;

    @Autowired
    @Lazy
    public IBIZSample0009Mapping ibizsample0009Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0009Mapping.toDomain(#ibizsample0009dto),'DemoSys-IBIZSample0009-Create')")
    @ApiOperation(value = "新建商品价格明细", tags = {"商品价格明细" },  notes = "新建商品价格明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0009s")
    public ResponseEntity<IBIZSample0009DTO> create(@Validated @RequestBody IBIZSample0009DTO ibizsample0009dto) {
        IBIZSample0009 domain = ibizsample0009Mapping.toDomain(ibizsample0009dto);
		ibizsample0009Service.create(domain);
        IBIZSample0009DTO dto = ibizsample0009Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0009Mapping.toDomain(#ibizsample0009dtos),'DemoSys-IBIZSample0009-Create')")
    @ApiOperation(value = "批量新建商品价格明细", tags = {"商品价格明细" },  notes = "批量新建商品价格明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0009s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0009DTO> ibizsample0009dtos) {
        ibizsample0009Service.createBatch(ibizsample0009Mapping.toDomain(ibizsample0009dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0009" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0009Service.get(#ibizsample0009_id),'DemoSys-IBIZSample0009-Update')")
    @ApiOperation(value = "更新商品价格明细", tags = {"商品价格明细" },  notes = "更新商品价格明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0009s/{ibizsample0009_id}")
    public ResponseEntity<IBIZSample0009DTO> update(@PathVariable("ibizsample0009_id") String ibizsample0009_id, @RequestBody IBIZSample0009DTO ibizsample0009dto) {
		IBIZSample0009 domain  = ibizsample0009Mapping.toDomain(ibizsample0009dto);
        domain .setIbizsample0009id(ibizsample0009_id);
		ibizsample0009Service.update(domain );
		IBIZSample0009DTO dto = ibizsample0009Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0009Service.getIbizsample0009ByEntities(this.ibizsample0009Mapping.toDomain(#ibizsample0009dtos)),'DemoSys-IBIZSample0009-Update')")
    @ApiOperation(value = "批量更新商品价格明细", tags = {"商品价格明细" },  notes = "批量更新商品价格明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0009s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0009DTO> ibizsample0009dtos) {
        ibizsample0009Service.updateBatch(ibizsample0009Mapping.toDomain(ibizsample0009dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0009Service.get(#ibizsample0009_id),'DemoSys-IBIZSample0009-Remove')")
    @ApiOperation(value = "删除商品价格明细", tags = {"商品价格明细" },  notes = "删除商品价格明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0009s/{ibizsample0009_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0009_id") String ibizsample0009_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0009Service.remove(ibizsample0009_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0009Service.getIbizsample0009ByIds(#ids),'DemoSys-IBIZSample0009-Remove')")
    @ApiOperation(value = "批量删除商品价格明细", tags = {"商品价格明细" },  notes = "批量删除商品价格明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0009s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0009Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0009Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0009-Get')")
    @ApiOperation(value = "获取商品价格明细", tags = {"商品价格明细" },  notes = "获取商品价格明细")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0009s/{ibizsample0009_id}")
    public ResponseEntity<IBIZSample0009DTO> get(@PathVariable("ibizsample0009_id") String ibizsample0009_id) {
        IBIZSample0009 domain = ibizsample0009Service.get(ibizsample0009_id);
        IBIZSample0009DTO dto = ibizsample0009Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取商品价格明细草稿", tags = {"商品价格明细" },  notes = "获取商品价格明细草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0009s/getdraft")
    public ResponseEntity<IBIZSample0009DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0009Mapping.toDto(ibizsample0009Service.getDraft(new IBIZSample0009())));
    }

    @ApiOperation(value = "检查商品价格明细", tags = {"商品价格明细" },  notes = "检查商品价格明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0009s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0009DTO ibizsample0009dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0009Service.checkKey(ibizsample0009Mapping.toDomain(ibizsample0009dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0009Mapping.toDomain(#ibizsample0009dto),'DemoSys-IBIZSample0009-Save')")
    @ApiOperation(value = "保存商品价格明细", tags = {"商品价格明细" },  notes = "保存商品价格明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0009s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0009DTO ibizsample0009dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0009Service.save(ibizsample0009Mapping.toDomain(ibizsample0009dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0009Mapping.toDomain(#ibizsample0009dtos),'DemoSys-IBIZSample0009-Save')")
    @ApiOperation(value = "批量保存商品价格明细", tags = {"商品价格明细" },  notes = "批量保存商品价格明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0009s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0009DTO> ibizsample0009dtos) {
        ibizsample0009Service.saveBatch(ibizsample0009Mapping.toDomain(ibizsample0009dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0009-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0009-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"商品价格明细" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0009s/fetchdefault")
	public ResponseEntity<List<IBIZSample0009DTO>> fetchDefault(IBIZSample0009SearchContext context) {
        Page<IBIZSample0009> domains = ibizsample0009Service.searchDefault(context) ;
        List<IBIZSample0009DTO> list = ibizsample0009Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0009-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0009-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"商品价格明细" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0009s/searchdefault")
	public ResponseEntity<Page<IBIZSample0009DTO>> searchDefault(@RequestBody IBIZSample0009SearchContext context) {
        Page<IBIZSample0009> domains = ibizsample0009Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0009Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

