package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0013;
import cn.ibizlab.core.sample.service.IIBIZSample0013Service;
import cn.ibizlab.core.sample.filter.IBIZSample0013SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单明细" })
@RestController("DemoAPI-ibizsample0013")
@RequestMapping("")
public class IBIZSample0013Resource {

    @Autowired
    public IIBIZSample0013Service ibizsample0013Service;

    @Autowired
    @Lazy
    public IBIZSample0013Mapping ibizsample0013Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0013Mapping.toDomain(#ibizsample0013dto),'DemoSys-IBIZSample0013-Create')")
    @ApiOperation(value = "新建订单明细", tags = {"订单明细" },  notes = "新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0013s")
    public ResponseEntity<IBIZSample0013DTO> create(@Validated @RequestBody IBIZSample0013DTO ibizsample0013dto) {
        IBIZSample0013 domain = ibizsample0013Mapping.toDomain(ibizsample0013dto);
		ibizsample0013Service.create(domain);
        IBIZSample0013DTO dto = ibizsample0013Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0013Mapping.toDomain(#ibizsample0013dtos),'DemoSys-IBIZSample0013-Create')")
    @ApiOperation(value = "批量新建订单明细", tags = {"订单明细" },  notes = "批量新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0013s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0013DTO> ibizsample0013dtos) {
        ibizsample0013Service.createBatch(ibizsample0013Mapping.toDomain(ibizsample0013dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0013" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0013Service.get(#ibizsample0013_id),'DemoSys-IBIZSample0013-Update')")
    @ApiOperation(value = "更新订单明细", tags = {"订单明细" },  notes = "更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0013s/{ibizsample0013_id}")
    public ResponseEntity<IBIZSample0013DTO> update(@PathVariable("ibizsample0013_id") String ibizsample0013_id, @RequestBody IBIZSample0013DTO ibizsample0013dto) {
		IBIZSample0013 domain  = ibizsample0013Mapping.toDomain(ibizsample0013dto);
        domain .setIbizsample0013id(ibizsample0013_id);
		ibizsample0013Service.update(domain );
		IBIZSample0013DTO dto = ibizsample0013Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0013Service.getIbizsample0013ByEntities(this.ibizsample0013Mapping.toDomain(#ibizsample0013dtos)),'DemoSys-IBIZSample0013-Update')")
    @ApiOperation(value = "批量更新订单明细", tags = {"订单明细" },  notes = "批量更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0013s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0013DTO> ibizsample0013dtos) {
        ibizsample0013Service.updateBatch(ibizsample0013Mapping.toDomain(ibizsample0013dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0013Service.get(#ibizsample0013_id),'DemoSys-IBIZSample0013-Remove')")
    @ApiOperation(value = "删除订单明细", tags = {"订单明细" },  notes = "删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0013s/{ibizsample0013_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0013_id") String ibizsample0013_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0013Service.remove(ibizsample0013_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0013Service.getIbizsample0013ByIds(#ids),'DemoSys-IBIZSample0013-Remove')")
    @ApiOperation(value = "批量删除订单明细", tags = {"订单明细" },  notes = "批量删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0013s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0013Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0013Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0013-Get')")
    @ApiOperation(value = "获取订单明细", tags = {"订单明细" },  notes = "获取订单明细")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0013s/{ibizsample0013_id}")
    public ResponseEntity<IBIZSample0013DTO> get(@PathVariable("ibizsample0013_id") String ibizsample0013_id) {
        IBIZSample0013 domain = ibizsample0013Service.get(ibizsample0013_id);
        IBIZSample0013DTO dto = ibizsample0013Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取订单明细草稿", tags = {"订单明细" },  notes = "获取订单明细草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0013s/getdraft")
    public ResponseEntity<IBIZSample0013DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0013Mapping.toDto(ibizsample0013Service.getDraft(new IBIZSample0013())));
    }

    @ApiOperation(value = "检查订单明细", tags = {"订单明细" },  notes = "检查订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0013s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0013DTO ibizsample0013dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0013Service.checkKey(ibizsample0013Mapping.toDomain(ibizsample0013dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0013Mapping.toDomain(#ibizsample0013dto),'DemoSys-IBIZSample0013-Save')")
    @ApiOperation(value = "保存订单明细", tags = {"订单明细" },  notes = "保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0013s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0013DTO ibizsample0013dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0013Service.save(ibizsample0013Mapping.toDomain(ibizsample0013dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0013Mapping.toDomain(#ibizsample0013dtos),'DemoSys-IBIZSample0013-Save')")
    @ApiOperation(value = "批量保存订单明细", tags = {"订单明细" },  notes = "批量保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0013s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0013DTO> ibizsample0013dtos) {
        ibizsample0013Service.saveBatch(ibizsample0013Mapping.toDomain(ibizsample0013dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0013-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0013-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"订单明细" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0013s/fetchdefault")
	public ResponseEntity<List<IBIZSample0013DTO>> fetchDefault(IBIZSample0013SearchContext context) {
        Page<IBIZSample0013> domains = ibizsample0013Service.searchDefault(context) ;
        List<IBIZSample0013DTO> list = ibizsample0013Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0013-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0013-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"订单明细" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0013s/searchdefault")
	public ResponseEntity<Page<IBIZSample0013DTO>> searchDefault(@RequestBody IBIZSample0013SearchContext context) {
        Page<IBIZSample0013> domains = ibizsample0013Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0013Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

