package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0003;
import cn.ibizlab.core.sample.service.IIBIZSample0003Service;
import cn.ibizlab.core.sample.filter.IBIZSample0003SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"示例实体03" })
@RestController("DemoAPI-ibizsample0003")
@RequestMapping("")
public class IBIZSample0003Resource {

    @Autowired
    public IIBIZSample0003Service ibizsample0003Service;

    @Autowired
    @Lazy
    public IBIZSample0003Mapping ibizsample0003Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0003Mapping.toDomain(#ibizsample0003dto),'DemoSys-IBIZSample0003-Create')")
    @ApiOperation(value = "新建示例实体03", tags = {"示例实体03" },  notes = "新建示例实体03")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0003s")
    public ResponseEntity<IBIZSample0003DTO> create(@Validated @RequestBody IBIZSample0003DTO ibizsample0003dto) {
        IBIZSample0003 domain = ibizsample0003Mapping.toDomain(ibizsample0003dto);
		ibizsample0003Service.create(domain);
        IBIZSample0003DTO dto = ibizsample0003Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0003Mapping.toDomain(#ibizsample0003dtos),'DemoSys-IBIZSample0003-Create')")
    @ApiOperation(value = "批量新建示例实体03", tags = {"示例实体03" },  notes = "批量新建示例实体03")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0003s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0003DTO> ibizsample0003dtos) {
        ibizsample0003Service.createBatch(ibizsample0003Mapping.toDomain(ibizsample0003dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0003" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0003Service.get(#ibizsample0003_id),'DemoSys-IBIZSample0003-Update')")
    @ApiOperation(value = "更新示例实体03", tags = {"示例实体03" },  notes = "更新示例实体03")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0003s/{ibizsample0003_id}")
    public ResponseEntity<IBIZSample0003DTO> update(@PathVariable("ibizsample0003_id") String ibizsample0003_id, @RequestBody IBIZSample0003DTO ibizsample0003dto) {
		IBIZSample0003 domain  = ibizsample0003Mapping.toDomain(ibizsample0003dto);
        domain .setIbizsample0003id(ibizsample0003_id);
		ibizsample0003Service.update(domain );
		IBIZSample0003DTO dto = ibizsample0003Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0003Service.getIbizsample0003ByEntities(this.ibizsample0003Mapping.toDomain(#ibizsample0003dtos)),'DemoSys-IBIZSample0003-Update')")
    @ApiOperation(value = "批量更新示例实体03", tags = {"示例实体03" },  notes = "批量更新示例实体03")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0003s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0003DTO> ibizsample0003dtos) {
        ibizsample0003Service.updateBatch(ibizsample0003Mapping.toDomain(ibizsample0003dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0003Service.get(#ibizsample0003_id),'DemoSys-IBIZSample0003-Remove')")
    @ApiOperation(value = "删除示例实体03", tags = {"示例实体03" },  notes = "删除示例实体03")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0003s/{ibizsample0003_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0003_id") String ibizsample0003_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0003Service.remove(ibizsample0003_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0003Service.getIbizsample0003ByIds(#ids),'DemoSys-IBIZSample0003-Remove')")
    @ApiOperation(value = "批量删除示例实体03", tags = {"示例实体03" },  notes = "批量删除示例实体03")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0003s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0003Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0003Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0003-Get')")
    @ApiOperation(value = "获取示例实体03", tags = {"示例实体03" },  notes = "获取示例实体03")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0003s/{ibizsample0003_id}")
    public ResponseEntity<IBIZSample0003DTO> get(@PathVariable("ibizsample0003_id") String ibizsample0003_id) {
        IBIZSample0003 domain = ibizsample0003Service.get(ibizsample0003_id);
        IBIZSample0003DTO dto = ibizsample0003Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取示例实体03草稿", tags = {"示例实体03" },  notes = "获取示例实体03草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0003s/getdraft")
    public ResponseEntity<IBIZSample0003DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0003Mapping.toDto(ibizsample0003Service.getDraft(new IBIZSample0003())));
    }

    @ApiOperation(value = "检查示例实体03", tags = {"示例实体03" },  notes = "检查示例实体03")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0003s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0003DTO ibizsample0003dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0003Service.checkKey(ibizsample0003Mapping.toDomain(ibizsample0003dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0003Mapping.toDomain(#ibizsample0003dto),'DemoSys-IBIZSample0003-Save')")
    @ApiOperation(value = "保存示例实体03", tags = {"示例实体03" },  notes = "保存示例实体03")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0003s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0003DTO ibizsample0003dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0003Service.save(ibizsample0003Mapping.toDomain(ibizsample0003dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0003Mapping.toDomain(#ibizsample0003dtos),'DemoSys-IBIZSample0003-Save')")
    @ApiOperation(value = "批量保存示例实体03", tags = {"示例实体03" },  notes = "批量保存示例实体03")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0003s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0003DTO> ibizsample0003dtos) {
        ibizsample0003Service.saveBatch(ibizsample0003Mapping.toDomain(ibizsample0003dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-searchCurData-all') and hasPermission(#context,'DemoSys-IBIZSample0003-Get')")
	@ApiOperation(value = "获取当前数据", tags = {"示例实体03" } ,notes = "获取当前数据")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0003s/fetchcurdata")
	public ResponseEntity<List<IBIZSample0003DTO>> fetchCurData(IBIZSample0003SearchContext context) {
        Page<IBIZSample0003> domains = ibizsample0003Service.searchCurData(context) ;
        List<IBIZSample0003DTO> list = ibizsample0003Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-searchCurData-all') and hasPermission(#context,'DemoSys-IBIZSample0003-Get')")
	@ApiOperation(value = "查询当前数据", tags = {"示例实体03" } ,notes = "查询当前数据")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0003s/searchcurdata")
	public ResponseEntity<Page<IBIZSample0003DTO>> searchCurData(@RequestBody IBIZSample0003SearchContext context) {
        Page<IBIZSample0003> domains = ibizsample0003Service.searchCurData(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0003Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0003-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"示例实体03" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0003s/fetchdefault")
	public ResponseEntity<List<IBIZSample0003DTO>> fetchDefault(IBIZSample0003SearchContext context) {
        Page<IBIZSample0003> domains = ibizsample0003Service.searchDefault(context) ;
        List<IBIZSample0003DTO> list = ibizsample0003Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0003-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"示例实体03" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0003s/searchdefault")
	public ResponseEntity<Page<IBIZSample0003DTO>> searchDefault(@RequestBody IBIZSample0003SearchContext context) {
        Page<IBIZSample0003> domains = ibizsample0003Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0003Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-searchTopData-all') and hasPermission(#context,'DemoSys-IBIZSample0003-Get')")
	@ApiOperation(value = "获取顶级数据", tags = {"示例实体03" } ,notes = "获取顶级数据")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0003s/fetchtopdata")
	public ResponseEntity<List<IBIZSample0003DTO>> fetchTopData(IBIZSample0003SearchContext context) {
        Page<IBIZSample0003> domains = ibizsample0003Service.searchTopData(context) ;
        List<IBIZSample0003DTO> list = ibizsample0003Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0003-searchTopData-all') and hasPermission(#context,'DemoSys-IBIZSample0003-Get')")
	@ApiOperation(value = "查询顶级数据", tags = {"示例实体03" } ,notes = "查询顶级数据")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0003s/searchtopdata")
	public ResponseEntity<Page<IBIZSample0003DTO>> searchTopData(@RequestBody IBIZSample0003SearchContext context) {
        Page<IBIZSample0003> domains = ibizsample0003Service.searchTopData(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0003Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

