package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample;
import cn.ibizlab.core.sample.service.IIBIZSampleService;
import cn.ibizlab.core.sample.filter.IBIZSampleSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"示例数据库" })
@RestController("DemoAPI-ibizsample")
@RequestMapping("")
public class IBIZSampleResource {

    @Autowired
    public IIBIZSampleService ibizsampleService;

    @Autowired
    @Lazy
    public IBIZSampleMapping ibizsampleMapping;

    @PreAuthorize("hasPermission(this.ibizsampleMapping.toDomain(#ibizsampledto),'DemoSys-IBIZSample-Create')")
    @ApiOperation(value = "新建示例数据库", tags = {"示例数据库" },  notes = "新建示例数据库")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsamples")
    public ResponseEntity<IBIZSampleDTO> create(@Validated @RequestBody IBIZSampleDTO ibizsampledto) {
        IBIZSample domain = ibizsampleMapping.toDomain(ibizsampledto);
		ibizsampleService.create(domain);
        IBIZSampleDTO dto = ibizsampleMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsampleMapping.toDomain(#ibizsampledtos),'DemoSys-IBIZSample-Create')")
    @ApiOperation(value = "批量新建示例数据库", tags = {"示例数据库" },  notes = "批量新建示例数据库")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsamples/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSampleDTO> ibizsampledtos) {
        ibizsampleService.createBatch(ibizsampleMapping.toDomain(ibizsampledtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsampleService.get(#ibizsample_id),'DemoSys-IBIZSample-Update')")
    @ApiOperation(value = "更新示例数据库", tags = {"示例数据库" },  notes = "更新示例数据库")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsamples/{ibizsample_id}")
    public ResponseEntity<IBIZSampleDTO> update(@PathVariable("ibizsample_id") String ibizsample_id, @RequestBody IBIZSampleDTO ibizsampledto) {
		IBIZSample domain  = ibizsampleMapping.toDomain(ibizsampledto);
        domain .setIbizsampleid(ibizsample_id);
		ibizsampleService.update(domain );
		IBIZSampleDTO dto = ibizsampleMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsampleService.getIbizsampleByEntities(this.ibizsampleMapping.toDomain(#ibizsampledtos)),'DemoSys-IBIZSample-Update')")
    @ApiOperation(value = "批量更新示例数据库", tags = {"示例数据库" },  notes = "批量更新示例数据库")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsamples/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSampleDTO> ibizsampledtos) {
        ibizsampleService.updateBatch(ibizsampleMapping.toDomain(ibizsampledtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsampleService.get(#ibizsample_id),'DemoSys-IBIZSample-Remove')")
    @ApiOperation(value = "删除示例数据库", tags = {"示例数据库" },  notes = "删除示例数据库")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsamples/{ibizsample_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample_id") String ibizsample_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsampleService.remove(ibizsample_id));
    }

    @PreAuthorize("hasPermission(this.ibizsampleService.getIbizsampleByIds(#ids),'DemoSys-IBIZSample-Remove')")
    @ApiOperation(value = "批量删除示例数据库", tags = {"示例数据库" },  notes = "批量删除示例数据库")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsamples/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsampleService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsampleMapping.toDomain(returnObject.body),'DemoSys-IBIZSample-Get')")
    @ApiOperation(value = "获取示例数据库", tags = {"示例数据库" },  notes = "获取示例数据库")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsamples/{ibizsample_id}")
    public ResponseEntity<IBIZSampleDTO> get(@PathVariable("ibizsample_id") String ibizsample_id) {
        IBIZSample domain = ibizsampleService.get(ibizsample_id);
        IBIZSampleDTO dto = ibizsampleMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取示例数据库草稿", tags = {"示例数据库" },  notes = "获取示例数据库草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsamples/getdraft")
    public ResponseEntity<IBIZSampleDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsampleMapping.toDto(ibizsampleService.getDraft(new IBIZSample())));
    }

    @ApiOperation(value = "检查示例数据库", tags = {"示例数据库" },  notes = "检查示例数据库")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsamples/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSampleDTO ibizsampledto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsampleService.checkKey(ibizsampleMapping.toDomain(ibizsampledto)));
    }

    @PreAuthorize("hasPermission(this.ibizsampleMapping.toDomain(#ibizsampledto),'DemoSys-IBIZSample-Save')")
    @ApiOperation(value = "保存示例数据库", tags = {"示例数据库" },  notes = "保存示例数据库")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsamples/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSampleDTO ibizsampledto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsampleService.save(ibizsampleMapping.toDomain(ibizsampledto)));
    }

    @PreAuthorize("hasPermission(this.ibizsampleMapping.toDomain(#ibizsampledtos),'DemoSys-IBIZSample-Save')")
    @ApiOperation(value = "批量保存示例数据库", tags = {"示例数据库" },  notes = "批量保存示例数据库")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsamples/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSampleDTO> ibizsampledtos) {
        ibizsampleService.saveBatch(ibizsampleMapping.toDomain(ibizsampledtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"示例数据库" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsamples/fetchdefault")
	public ResponseEntity<List<IBIZSampleDTO>> fetchDefault(IBIZSampleSearchContext context) {
        Page<IBIZSample> domains = ibizsampleService.searchDefault(context) ;
        List<IBIZSampleDTO> list = ibizsampleMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"示例数据库" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsamples/searchdefault")
	public ResponseEntity<Page<IBIZSampleDTO>> searchDefault(@RequestBody IBIZSampleSearchContext context) {
        Page<IBIZSample> domains = ibizsampleService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsampleMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample-searchFormType-all') and hasPermission(#context,'DemoSys-IBIZSample-Get')")
	@ApiOperation(value = "获取FormType", tags = {"示例数据库" } ,notes = "获取FormType")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsamples/fetchformtype")
	public ResponseEntity<List<IBIZSampleDTO>> fetchFormType(IBIZSampleSearchContext context) {
        Page<IBIZSample> domains = ibizsampleService.searchFormType(context) ;
        List<IBIZSampleDTO> list = ibizsampleMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample-searchFormType-all') and hasPermission(#context,'DemoSys-IBIZSample-Get')")
	@ApiOperation(value = "查询FormType", tags = {"示例数据库" } ,notes = "查询FormType")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsamples/searchformtype")
	public ResponseEntity<Page<IBIZSampleDTO>> searchFormType(@RequestBody IBIZSampleSearchContext context) {
        Page<IBIZSample> domains = ibizsampleService.searchFormType(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsampleMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

