import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router'

Vue.use(Router);

const router = new Router({
    routes: [
        {
            path: '/index/:index?',
            beforeEnter: (to: any, from: any, next: any) => {
                const routerParamsName = 'index';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    Object.assign(params, qs.parse(to.params[routerParamsName], { delimiter: ';' }));
                }
                const url: string = '/appdata';
                const auth: Promise<any> = AuthGuard.getInstance().authGuard(url, params, router);
                auth.then(() => {
                    next();
                }).catch(() => {
                    next();
                });
            },
            meta: {  
                caption: 'app.views.index.caption',
                info:'',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'index', parameterName: 'index' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/sample/index/index.vue'),
            children: [
                {
                    path: 'ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf6editview/:sf6editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.sf6editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'sf6editview', parameterName: 'sf6editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-sf6-edit-view/ibizsample0001-sf6-edit-view.vue'),
                },
                {
                    path: 'ibizsample0001s/:ibizsample0001?/sf6editview/:sf6editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.sf6editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'sf6editview', parameterName: 'sf6editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-sf6-edit-view/ibizsample0001-sf6-edit-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/smpickupview2/:smpickupview2?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.smpickupview2.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'smpickupview2', parameterName: 'smpickupview2' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-smpickup-view2/ibizsample0003-smpickup-view2.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-edit-view/ibizsample0001-edit-view.vue'),
                },
                {
                    path: 'ibizsample0001s/:ibizsample0001?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-edit-view/ibizsample0001-edit-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/seditview9/:seditview9?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.seditview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'seditview9', parameterName: 'seditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-sedit-view9/ibizorder-detail-sedit-view9.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/smeditview9/:smeditview9?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.smeditview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'smeditview9', parameterName: 'smeditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-smedit-view9/ibizorder-detail-smedit-view9.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-edit-view/ibizsample0003-edit-view.vue'),
                },
                {
                    path: 'ibizuniproducts/:ibizuniproduct?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.ibizuniproduct.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizuniproduct-pickup-view/ibizuniproduct-pickup-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sgridview/:sgridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sgridview', parameterName: 'sgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sgrid-view/ibizorder-sgrid-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf4editview/:sf4editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.sf4editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'sf4editview', parameterName: 'sf4editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-sf4-edit-view/ibizsample0001-sf4-edit-view.vue'),
                },
                {
                    path: 'ibizsample0001s/:ibizsample0001?/sf4editview/:sf4editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.sf4editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'sf4editview', parameterName: 'sf4editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-sf4-edit-view/ibizsample0001-sf4-edit-view.vue'),
                },
                {
                    path: 'ibizsoftwaresuits/:ibizsoftwaresuit?/sgridview/:sgridview?',
                    meta: {
                        caption: 'entities.ibizsoftwaresuit.views.sgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                            { pathName: 'sgridview', parameterName: 'sgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsoftware-suit-sgrid-view/ibizsoftware-suit-sgrid-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizsample0002.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0002-edit-view/ibizsample0002-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/barchartview/:barchartview?',
                    meta: {
                        caption: 'entities.ibizorder.views.barchartview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'barchartview', parameterName: 'barchartview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-bar-chart-view/ibizorder-bar-chart-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/streeexpview2/:streeexpview2?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.streeexpview2.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'streeexpview2', parameterName: 'streeexpview2' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-stree-exp-view2/ibizsample0003-stree-exp-view2.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/wizardview/:wizardview?',
                    meta: {
                        caption: 'entities.ibizbook.views.wizardview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'wizardview', parameterName: 'wizardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookwizard-view/ibizbookwizard-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr5gridview/:usr5gridview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr5gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr5gridview', parameterName: 'usr5gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr5-grid-view/ibizbookusr5-grid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr2gridview/:usr2gridview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr2gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr2gridview', parameterName: 'usr2gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr2-grid-view/ibizbookusr2-grid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/optionview/:optionview?',
                    meta: {
                        caption: 'entities.ibizbook.views.optionview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'optionview', parameterName: 'optionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookoption-view/ibizbookoption-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf2editview/:sf2editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.sf2editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'sf2editview', parameterName: 'sf2editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-sf2-edit-view/ibizsample0001-sf2-edit-view.vue'),
                },
                {
                    path: 'ibizsample0001s/:ibizsample0001?/sf2editview/:sf2editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.sf2editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'sf2editview', parameterName: 'sf2editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-sf2-edit-view/ibizsample0001-sf2-edit-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/sf2editview/:sf2editview?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.sf2editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'sf2editview', parameterName: 'sf2editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-sf2-edit-view/ibizorder-detail-sf2-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/newdefaultvaluegridview/:newdefaultvaluegridview?',
                    meta: {
                        caption: 'entities.ibizbook.views.newdefaultvaluegridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'newdefaultvaluegridview', parameterName: 'newdefaultvaluegridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbooknew-default-value-grid-view/ibizbooknew-default-value-grid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/calendarview/:calendarview?',
                    meta: {
                        caption: 'entities.ibizbook.views.calendarview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'calendarview', parameterName: 'calendarview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookcalendar-view/ibizbookcalendar-view.vue'),
                },
                {
                    path: 'ibizhardwares/:ibizhardware?/indexpickupdataview/:indexpickupdataview?',
                    meta: {
                        caption: 'entities.ibizhardware.views.indexpickupdataview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                            { pathName: 'indexpickupdataview', parameterName: 'indexpickupdataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizhardware-index-pickup-data-view/ibizhardware-index-pickup-data-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sgridview2/:sgridview2?',
                    meta: {
                        caption: 'entities.ibizorder.views.sgridview2.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sgridview2', parameterName: 'sgridview2' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sgrid-view2/ibizorder-sgrid-view2.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/treegridexview/:treegridexview?',
                    meta: {
                        caption: 'entities.ibizbook.views.treegridexview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'treegridexview', parameterName: 'treegridexview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbooktree-grid-ex-view/ibizbooktree-grid-ex-view.vue'),
                },
                {
                    path: 'ibizuniproducts/:ibizuniproduct?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.ibizuniproduct.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizuniproduct-pickup-grid-view/ibizuniproduct-pickup-grid-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/odsp_wfexpview/:odsp_wfexpview?',
                    meta: {
                        caption: 'entities.ibizorder.views.odsp_wfexpview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'odsp_wfexpview', parameterName: 'odsp_wfexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-odsp-wfexp-view/ibizorder-odsp-wfexp-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/sgridview/:sgridview?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.sgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'sgridview', parameterName: 'sgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-sgrid-view/ibizorder-detail-sgrid-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.ibizsample0002.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0002-pickup-grid-view/ibizsample0002-pickup-grid-view.vue'),
                },
                {
                    path: 'ibizsoftwaresuits/:ibizsoftwaresuit?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizsoftwaresuit.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsoftware-suit-edit-view/ibizsoftware-suit-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.ibizorder.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-pickup-view/ibizorder-pickup-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf4gridview/:sf4gridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf4gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf4gridview', parameterName: 'sf4gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf4-grid-view/ibizorder-sf4-grid-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-grid-view/ibizsample0003-grid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/customview/:customview?',
                    meta: {
                        caption: 'entities.ibizbook.views.customview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'customview', parameterName: 'customview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookcustom-view/ibizbookcustom-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/sf4editview/:sf4editview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.sf4editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'sf4editview', parameterName: 'sf4editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-sf4-edit-view/ibizsample0003-sf4-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf1gridview/:sf1gridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf1gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf1gridview', parameterName: 'sf1gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf1-grid-view/ibizorder-sf1-grid-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-pickup-grid-view/ibizsample0003-pickup-grid-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-pickup-view/ibizsample0003-pickup-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/usr2editview/:usr2editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.usr2editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'usr2editview', parameterName: 'usr2editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-usr2-edit-view/ibizsample0001-usr2-edit-view.vue'),
                },
                {
                    path: 'ibizsample0001s/:ibizsample0001?/usr2editview/:usr2editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.usr2editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'usr2editview', parameterName: 'usr2editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-usr2-edit-view/ibizsample0001-usr2-edit-view.vue'),
                },
                {
                    path: 'ibizhardwares/:ibizhardware?/sgridview/:sgridview?',
                    meta: {
                        caption: 'entities.ibizhardware.views.sgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                            { pathName: 'sgridview', parameterName: 'sgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizhardware-sgrid-view/ibizhardware-sgrid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/statewizardview/:statewizardview?',
                    meta: {
                        caption: 'entities.ibizbook.views.statewizardview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'statewizardview', parameterName: 'statewizardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookstate-wizard-view/ibizbookstate-wizard-view.vue'),
                },
                {
                    path: 'ibizsample0017s/:ibizsample0017?/formpickupdataview/:formpickupdataview?',
                    meta: {
                        caption: 'entities.ibizsample0017.views.formpickupdataview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                            { pathName: 'formpickupdataview', parameterName: 'formpickupdataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0017-form-pickup-data-view/ibizsample0017-form-pickup-data-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf5gridview/:sf5gridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf5gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf5gridview', parameterName: 'sf5gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf5-grid-view/ibizorder-sf5-grid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/meditview9/:meditview9?',
                    meta: {
                        caption: 'entities.ibizbook.views.meditview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'meditview9', parameterName: 'meditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookmedit-view9/ibizbookmedit-view9.vue'),
                },
                {
                    path: 'ibizcustomers/:ibizcustomer?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizcustomer.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizcustomer-edit-view/ibizcustomer-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/groupbycodelistkanbanview/:groupbycodelistkanbanview?',
                    meta: {
                        caption: 'entities.ibizbook.views.groupbycodelistkanbanview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'groupbycodelistkanbanview', parameterName: 'groupbycodelistkanbanview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookgroup-by-codelist-kan-ban-view/ibizbookgroup-by-codelist-kan-ban-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr3dataview/:usr3dataview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr3dataview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr3dataview', parameterName: 'usr3dataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr3-data-view/ibizbookusr3-data-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.gridview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-grid-view9/ibizorder-detail-grid-view9.vue'),
                },
                {
                    path: 'ibizhardwares/:ibizhardware?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizhardware.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizhardware-edit-view/ibizhardware-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/seditview2/:seditview2?',
                    meta: {
                        caption: 'entities.ibizorder.views.seditview2.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'seditview2', parameterName: 'seditview2' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sedit-view2/ibizorder-sedit-view2.vue'),
                },
                {
                    path: 'ibizsample0017s/:ibizsample0017?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizsample0017.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0017-edit-view/ibizsample0017-edit-view.vue'),
                },
                {
                    path: 'ibizcpus/:ibizcpu?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizcpu.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizcpus', parameterName: 'ibizcpu' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizcpuedit-view/ibizcpuedit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/odsp_d40_wfgridview/:odsp_d40_wfgridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.odsp_d40_wfgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'odsp_d40_wfgridview', parameterName: 'odsp_d40_wfgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-odsp-d40-wfgrid-view/ibizorder-odsp-d40-wfgrid-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/seditview/:seditview?',
                    meta: {
                        caption: 'entities.ibizorder.views.seditview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'seditview', parameterName: 'seditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sedit-view/ibizorder-sedit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-pickup-grid-view/ibizorder-pickup-grid-view.vue'),
                },
                {
                    path: 'ibizsample0017s/:ibizsample0017?/f30editview/:f30editview?',
                    meta: {
                        caption: 'entities.ibizsample0017.views.f30editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                            { pathName: 'f30editview', parameterName: 'f30editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0017-f30-edit-view/ibizsample0017-f30-edit-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/f2treeexpview/:f2treeexpview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.f2treeexpview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'f2treeexpview', parameterName: 'f2treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-f2-tree-exp-view/ibizsample0003-f2-tree-exp-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/gridexpview/:gridexpview?',
                    meta: {
                        caption: 'entities.ibizorder.views.gridexpview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'gridexpview', parameterName: 'gridexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-grid-exp-view/ibizorder-grid-exp-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/sf3editview/:sf3editview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.sf3editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'sf3editview', parameterName: 'sf3editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-sf3-edit-view/ibizsample0003-sf3-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf15gridview/:sf15gridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf15gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf15gridview', parameterName: 'sf15gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf15-grid-view/ibizorder-sf15-grid-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-edit-view/ibizorder-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/linechartview/:linechartview?',
                    meta: {
                        caption: 'entities.ibizorder.views.linechartview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'linechartview', parameterName: 'linechartview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-line-chart-view/ibizorder-line-chart-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/odsp_d_wfgridview/:odsp_d_wfgridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.odsp_d_wfgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'odsp_d_wfgridview', parameterName: 'odsp_d_wfgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-odsp-d-wfgrid-view/ibizorder-odsp-d-wfgrid-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-grid-view/ibizorder-detail-grid-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf2editview/:sf2editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf2editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf2editview', parameterName: 'sf2editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf2-edit-view/ibizorder-sf2-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/s2editview/:s2editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.s2editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 's2editview', parameterName: 's2editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-s2-edit-view/ibizorder-s2-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/zdytpgridview/:zdytpgridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.zdytpgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'zdytpgridview', parameterName: 'zdytpgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-zdytpgrid-view/ibizorder-zdytpgrid-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/usr2editview/:usr2editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.usr2editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'usr2editview', parameterName: 'usr2editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-usr2-edit-view/ibizorder-usr2-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf1editview/:sf1editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf1editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf1editview', parameterName: 'sf1editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf1-edit-view/ibizorder-sf1-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf4editview/:sf4editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf4editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf4editview', parameterName: 'sf4editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf4-edit-view/ibizorder-sf4-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr3calendarview/:usr3calendarview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr3calendarview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr3calendarview', parameterName: 'usr3calendarview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr3-calendar-view/ibizbookusr3-calendar-view.vue'),
                },
                {
                    path: 'ibizsample0017s/:ibizsample0017?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.ibizsample0017.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0017-grid-view/ibizsample0017-grid-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/f8editview/:f8editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.f8editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'f8editview', parameterName: 'f8editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-f8-edit-view/ibizorder-f8-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/f19editview/:f19editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.f19editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'f19editview', parameterName: 'f19editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-f19-edit-view/ibizorder-f19-edit-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/f1treeexpview/:f1treeexpview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.f1treeexpview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'f1treeexpview', parameterName: 'f1treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-f1-tree-exp-view/ibizsample0003-f1-tree-exp-view.vue'),
                },
                {
                    path: 'ibizsample0017s/:ibizsample0017?/f10editview/:f10editview?',
                    meta: {
                        caption: 'entities.ibizsample0017.views.f10editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                            { pathName: 'f10editview', parameterName: 'f10editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0017-f10-edit-view/ibizsample0017-f10-edit-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.ibizsample0002.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0002-pickup-view/ibizsample0002-pickup-view.vue'),
                },
                {
                    path: 'ibizuniproducts/:ibizuniproduct?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizuniproduct.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizuniproduct-edit-view/ibizuniproduct-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr2calendarview/:usr2calendarview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr2calendarview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr2calendarview', parameterName: 'usr2calendarview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr2-calendar-view/ibizbookusr2-calendar-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/dataview/:dataview?',
                    meta: {
                        caption: 'entities.ibizbook.views.dataview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'dataview', parameterName: 'dataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookdata-view/ibizbookdata-view.vue'),
                },
                {
                    path: 'ibizcustomers/:ibizcustomer?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.ibizcustomer.views.pickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizcustomer-pickup-view/ibizcustomer-pickup-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/usr2gridview/:usr2gridview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.usr2gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'usr2gridview', parameterName: 'usr2gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-usr2-grid-view/ibizsample0001-usr2-grid-view.vue'),
                },
                {
                    path: 'ibizsample0001s/:ibizsample0001?/usr2gridview/:usr2gridview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.usr2gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'usr2gridview', parameterName: 'usr2gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-usr2-grid-view/ibizsample0001-usr2-grid-view.vue'),
                },
                {
                    path: 'ibizuniproducts/:ibizuniproduct?/indexpickupview/:indexpickupview?',
                    meta: {
                        caption: 'entities.ibizuniproduct.views.indexpickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                            { pathName: 'indexpickupview', parameterName: 'indexpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizuniproduct-index-pickup-view/ibizuniproduct-index-pickup-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/sf1editview/:sf1editview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.sf1editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'sf1editview', parameterName: 'sf1editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-sf1-edit-view/ibizsample0003-sf1-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/interfunceditview/:interfunceditview?',
                    meta: {
                        caption: 'entities.ibizbook.views.interfunceditview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'interfunceditview', parameterName: 'interfunceditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookinter-func-edit-view/ibizbookinter-func-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/piechartview/:piechartview?',
                    meta: {
                        caption: 'entities.ibizorder.views.piechartview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'piechartview', parameterName: 'piechartview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-pie-chart-view/ibizorder-pie-chart-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/sgridview9/:sgridview9?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.sgridview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'sgridview9', parameterName: 'sgridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-sgrid-view9/ibizorder-detail-sgrid-view9.vue'),
                },
                {
                    path: 'ibizuniproducts/:ibizuniproduct?/sgridview/:sgridview?',
                    meta: {
                        caption: 'entities.ibizuniproduct.views.sgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                            { pathName: 'sgridview', parameterName: 'sgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizuniproduct-sgrid-view/ibizuniproduct-sgrid-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/f3treeexpview/:f3treeexpview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.f3treeexpview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'f3treeexpview', parameterName: 'f3treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-f3-tree-exp-view/ibizsample0003-f3-tree-exp-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/sf1editview/:sf1editview?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.sf1editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'sf1editview', parameterName: 'sf1editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-sf1-edit-view/ibizorder-detail-sf1-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/odsp_d30_wfgridview/:odsp_d30_wfgridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.odsp_d30_wfgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'odsp_d30_wfgridview', parameterName: 'odsp_d30_wfgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-odsp-d30-wfgrid-view/ibizorder-odsp-d30-wfgrid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr4dataview/:usr4dataview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr4dataview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr4dataview', parameterName: 'usr4dataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr4-data-view/ibizbookusr4-data-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/areachartview/:areachartview?',
                    meta: {
                        caption: 'entities.ibizorder.views.areachartview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'areachartview', parameterName: 'areachartview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-area-chart-view/ibizorder-area-chart-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf20gridview/:sf20gridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf20gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf20gridview', parameterName: 'sf20gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf20-grid-view/ibizorder-sf20-grid-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.ibizorder.views.gridview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-grid-view9/ibizorder-grid-view9.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/spickupview2/:spickupview2?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.spickupview2.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'spickupview2', parameterName: 'spickupview2' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-spickup-view2/ibizsample0003-spickup-view2.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/odsp_w10_wfgridview/:odsp_w10_wfgridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.odsp_w10_wfgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'odsp_w10_wfgridview', parameterName: 'odsp_w10_wfgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-odsp-w10-wfgrid-view/ibizorder-odsp-w10-wfgrid-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/spickuptreeview/:spickuptreeview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.spickuptreeview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'spickuptreeview', parameterName: 'spickuptreeview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-spickup-tree-view/ibizsample0003-spickup-tree-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/f9editview/:f9editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.f9editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'f9editview', parameterName: 'f9editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-f9-edit-view/ibizorder-f9-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/ruleseditview/:ruleseditview?',
                    meta: {
                        caption: 'entities.ibizbook.views.ruleseditview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'ruleseditview', parameterName: 'ruleseditview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookrules-edit-view/ibizbookrules-edit-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/f6gridview/:f6gridview?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.f6gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'f6gridview', parameterName: 'f6gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-f6-grid-view/ibizorder-detail-f6-grid-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/usr3gridview/:usr3gridview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.usr3gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'usr3gridview', parameterName: 'usr3gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-usr3-grid-view/ibizsample0001-usr3-grid-view.vue'),
                },
                {
                    path: 'ibizsample0001s/:ibizsample0001?/usr3gridview/:usr3gridview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.usr3gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'usr3gridview', parameterName: 'usr3gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-usr3-grid-view/ibizsample0001-usr3-grid-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/wfstartview/:wfstartview?',
                    meta: {
                        caption: 'entities.ibizorder.views.wfstartview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'wfstartview', parameterName: 'wfstartview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-wfstart-view/ibizorder-wfstart-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/f4treeexpview/:f4treeexpview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.f4treeexpview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'f4treeexpview', parameterName: 'f4treeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-f4-tree-exp-view/ibizsample0003-f4-tree-exp-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/f10editview/:f10editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.f10editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'f10editview', parameterName: 'f10editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-f10-edit-view/ibizorder-f10-edit-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/streeexpview/:streeexpview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.streeexpview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'streeexpview', parameterName: 'streeexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-stree-exp-view/ibizsample0003-stree-exp-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/dashboardview/:dashboardview?',
                    meta: {
                        caption: 'entities.ibizorder.views.dashboardview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'dashboardview', parameterName: 'dashboardview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-dashboard-view/ibizorder-dashboard-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/chartview/:chartview?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.chartview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'chartview', parameterName: 'chartview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-chart-view/ibizorder-detail-chart-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/seditview4/:seditview4?',
                    meta: {
                        caption: 'entities.ibizorder.views.seditview4.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'seditview4', parameterName: 'seditview4' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sedit-view4/ibizorder-sedit-view4.vue'),
                },
                {
                    path: 'ibizsoftwaresuits/:ibizsoftwaresuit?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.ibizsoftwaresuit.views.gridview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsoftware-suit-grid-view9/ibizsoftware-suit-grid-view9.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/haspanellistview/:haspanellistview?',
                    meta: {
                        caption: 'entities.ibizbook.views.haspanellistview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'haspanellistview', parameterName: 'haspanellistview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookhas-panel-list-view/ibizbookhas-panel-list-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf6gridview/:sf6gridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf6gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf6gridview', parameterName: 'sf6gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf6-grid-view/ibizorder-sf6-grid-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-edit-view/ibizorder-detail-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr2dataview/:usr2dataview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr2dataview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr2dataview', parameterName: 'usr2dataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr2-data-view/ibizbookusr2-data-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/listview/:listview?',
                    meta: {
                        caption: 'entities.ibizbook.views.listview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'listview', parameterName: 'listview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbooklist-view/ibizbooklist-view.vue'),
                },
                {
                    path: 'ibizsample0017s/:ibizsample0017?/formpickupview/:formpickupview?',
                    meta: {
                        caption: 'entities.ibizsample0017.views.formpickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                            { pathName: 'formpickupview', parameterName: 'formpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0017-form-pickup-view/ibizsample0017-form-pickup-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.ibizsample0002.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0002-grid-view/ibizsample0002-grid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/interfunckanbanview/:interfunckanbanview?',
                    meta: {
                        caption: 'entities.ibizbook.views.interfunckanbanview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'interfunckanbanview', parameterName: 'interfunckanbanview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookinter-func-kan-ban-view/ibizbookinter-func-kan-ban-view.vue'),
                },
                {
                    path: 'ibizordertypes/:ibizordertype?/usr2editview/:usr2editview?',
                    meta: {
                        caption: 'entities.ibizordertype.views.usr2editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizordertypes', parameterName: 'ibizordertype' },
                            { pathName: 'usr2editview', parameterName: 'usr2editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-type-usr2-edit-view/ibizorder-type-usr2-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/roweditgridview/:roweditgridview?',
                    meta: {
                        caption: 'entities.ibizbook.views.roweditgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'roweditgridview', parameterName: 'roweditgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookrow-edit-grid-view/ibizbookrow-edit-grid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/ganttview/:ganttview?',
                    meta: {
                        caption: 'entities.ibizbook.views.ganttview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'ganttview', parameterName: 'ganttview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookgantt-view/ibizbookgantt-view.vue'),
                },
                {
                    path: 'ibizhardwares/:ibizhardware?/indexpickupview/:indexpickupview?',
                    meta: {
                        caption: 'entities.ibizhardware.views.indexpickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                            { pathName: 'indexpickupview', parameterName: 'indexpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizhardware-index-pickup-view/ibizhardware-index-pickup-view.vue'),
                },
                {
                    path: 'ibizhardwares/:ibizhardware?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.ibizhardware.views.gridview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizhardware-grid-view9/ibizhardware-grid-view9.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf3editview/:sf3editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf3editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf3editview', parameterName: 'sf3editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf3-edit-view/ibizorder-sf3-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/f13editview/:f13editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.f13editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'f13editview', parameterName: 'f13editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-f13-edit-view/ibizorder-f13-edit-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/f6editview/:f6editview?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.f6editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'f6editview', parameterName: 'f6editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-f6-edit-view/ibizorder-detail-f6-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr4gridview/:usr4gridview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr4gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr4gridview', parameterName: 'usr4gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr4-grid-view/ibizbookusr4-grid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr2meditview9/:usr2meditview9?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr2meditview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr2meditview9', parameterName: 'usr2meditview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr2-medit-view9/ibizbookusr2-medit-view9.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/seditview3/:seditview3?',
                    meta: {
                        caption: 'entities.ibizorder.views.seditview3.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'seditview3', parameterName: 'seditview3' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sedit-view3/ibizorder-sedit-view3.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/odsp_d10_wfgridview/:odsp_d10_wfgridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.odsp_d10_wfgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'odsp_d10_wfgridview', parameterName: 'odsp_d10_wfgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-odsp-d10-wfgrid-view/ibizorder-odsp-d10-wfgrid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/internalfuncgridview/:internalfuncgridview?',
                    meta: {
                        caption: 'entities.ibizbook.views.internalfuncgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'internalfuncgridview', parameterName: 'internalfuncgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookinternal-func-grid-view/ibizbookinternal-func-grid-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/sf2editview/:sf2editview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.sf2editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'sf2editview', parameterName: 'sf2editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-sf2-edit-view/ibizsample0003-sf2-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf3gridview/:sf3gridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf3gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf3gridview', parameterName: 'sf3gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf3-grid-view/ibizorder-sf3-grid-view.vue'),
                },
                {
                    path: 'ibizstorages/:ibizstorage?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizstorage.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizstorages', parameterName: 'ibizstorage' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizstorage-edit-view/ibizstorage-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-grid-view/ibizorder-grid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr3gridview/:usr3gridview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr3gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr3gridview', parameterName: 'usr3gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr3-grid-view/ibizbookusr3-grid-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.mpickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-mpickup-view/ibizsample0003-mpickup-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/odsp_d20_wfgridview/:odsp_d20_wfgridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.odsp_d20_wfgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'odsp_d20_wfgridview', parameterName: 'odsp_d20_wfgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-odsp-d20-wfgrid-view/ibizorder-odsp-d20-wfgrid-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/wfactionview/:wfactionview?',
                    meta: {
                        caption: 'entities.ibizorder.views.wfactionview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'wfactionview', parameterName: 'wfactionview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-wfaction-view/ibizorder-wfaction-view.vue'),
                },
                {
                    path: 'ibizsample0017s/:ibizsample0017?/f20editview/:f20editview?',
                    meta: {
                        caption: 'entities.ibizsample0017.views.f20editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                            { pathName: 'f20editview', parameterName: 'f20editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0017-f20-edit-view/ibizsample0017-f20-edit-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/odsp_w_wfgridview/:odsp_w_wfgridview?',
                    meta: {
                        caption: 'entities.ibizorder.views.odsp_w_wfgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'odsp_w_wfgridview', parameterName: 'odsp_w_wfgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-odsp-w-wfgrid-view/ibizorder-odsp-w-wfgrid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/valuerulesgridview/:valuerulesgridview?',
                    meta: {
                        caption: 'entities.ibizbook.views.valuerulesgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'valuerulesgridview', parameterName: 'valuerulesgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookvalue-rules-grid-view/ibizbookvalue-rules-grid-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/usr6gridview/:usr6gridview?',
                    meta: {
                        caption: 'entities.ibizbook.views.usr6gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'usr6gridview', parameterName: 'usr6gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookusr6-grid-view/ibizbookusr6-grid-view.vue'),
                },
                {
                    path: 'ibizcustomers/:ibizcustomer?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.ibizcustomer.views.pickupgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizcustomer-pickup-grid-view/ibizcustomer-pickup-grid-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.ibizsample0002.views.mpickupview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0002-mpickup-view/ibizsample0002-mpickup-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/sf7editview/:sf7editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.sf7editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'sf7editview', parameterName: 'sf7editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-sf7-edit-view/ibizorder-sf7-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/editview/:editview?',
                    meta: {
                        caption: 'entities.ibizbook.views.editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookedit-view/ibizbookedit-view.vue'),
                },
                {
                    path: 'ibizorderdetails/:ibizorderdetail?/listview/:listview?',
                    meta: {
                        caption: 'entities.ibizorderdetail.views.listview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                            { pathName: 'listview', parameterName: 'listview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-detail-list-view/ibizorder-detail-list-view.vue'),
                },
                {
                    path: 'ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf5editview/:sf5editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.sf5editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'sf5editview', parameterName: 'sf5editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-sf5-edit-view/ibizsample0001-sf5-edit-view.vue'),
                },
                {
                    path: 'ibizsample0001s/:ibizsample0001?/sf5editview/:sf5editview?',
                    meta: {
                        caption: 'entities.ibizsample0001.views.sf5editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                            { pathName: 'sf5editview', parameterName: 'sf5editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0001-sf5-edit-view/ibizsample0001-sf5-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/groupbycodelistlistview/:groupbycodelistlistview?',
                    meta: {
                        caption: 'entities.ibizbook.views.groupbycodelistlistview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'groupbycodelistlistview', parameterName: 'groupbycodelistlistview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookgroup-by-codelist-list-view/ibizbookgroup-by-codelist-list-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/haspanelkanbanview/:haspanelkanbanview?',
                    meta: {
                        caption: 'entities.ibizbook.views.haspanelkanbanview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'haspanelkanbanview', parameterName: 'haspanelkanbanview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookhas-panel-kan-ban-view/ibizbookhas-panel-kan-ban-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/radarchartview/:radarchartview?',
                    meta: {
                        caption: 'entities.ibizorder.views.radarchartview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'radarchartview', parameterName: 'radarchartview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-radar-chart-view/ibizorder-radar-chart-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/usr3editview/:usr3editview?',
                    meta: {
                        caption: 'entities.ibizorder.views.usr3editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'usr3editview', parameterName: 'usr3editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-usr3-edit-view/ibizorder-usr3-edit-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/updatedefaultgridview/:updatedefaultgridview?',
                    meta: {
                        caption: 'entities.ibizbook.views.updatedefaultgridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'updatedefaultgridview', parameterName: 'updatedefaultgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookupdate-default-grid-view/ibizbookupdate-default-grid-view.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/stabexpview/:stabexpview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.stabexpview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'stabexpview', parameterName: 'stabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-stab-exp-view/ibizsample0003-stab-exp-view.vue'),
                },
                {
                    path: 'ibizbooks/:ibizbook?/autogrouplistview/:autogrouplistview?',
                    meta: {
                        caption: 'entities.ibizbook.views.autogrouplistview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                            { pathName: 'autogrouplistview', parameterName: 'autogrouplistview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizbookauto-group-list-view/ibizbookauto-group-list-view.vue'),
                },
                {
                    path: 'ibizuniproducts/:ibizuniproduct?/gridview9/:gridview9?',
                    meta: {
                        caption: 'entities.ibizuniproduct.views.gridview9.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                            { pathName: 'gridview9', parameterName: 'gridview9' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizuniproduct-grid-view9/ibizuniproduct-grid-view9.vue'),
                },
                {
                    path: 'ibizsample0003s/:ibizsample0003?/sf5editview/:sf5editview?',
                    meta: {
                        caption: 'entities.ibizsample0003.views.sf5editview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                            { pathName: 'sf5editview', parameterName: 'sf5editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizsample0003-sf5-edit-view/ibizsample0003-sf5-edit-view.vue'),
                },
                {
                    path: 'ibizuniproducts/:ibizuniproduct?/indexpickupdataview/:indexpickupdataview?',
                    meta: {
                        caption: 'entities.ibizuniproduct.views.indexpickupdataview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                            { pathName: 'indexpickupdataview', parameterName: 'indexpickupdataview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizuniproduct-index-pickup-data-view/ibizuniproduct-index-pickup-data-view.vue'),
                },
                {
                    path: 'ibizorders/:ibizorder?/tabexpview/:tabexpview?',
                    meta: {
                        caption: 'entities.ibizorder.views.tabexpview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizorders', parameterName: 'ibizorder' },
                            { pathName: 'tabexpview', parameterName: 'tabexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-tab-exp-view/ibizorder-tab-exp-view.vue'),
                },
                {
                    path: 'ibizordertypes/:ibizordertype?/usr2gridview/:usr2gridview?',
                    meta: {
                        caption: 'entities.ibizordertype.views.usr2gridview.caption',
                        info:'',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'ibizordertypes', parameterName: 'ibizordertype' },
                            { pathName: 'usr2gridview', parameterName: 'usr2gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/sample/ibizorder-type-usr2-grid-view/ibizorder-type-usr2-grid-view.vue'),
                },
            ...indexRoutes,
            ],
        },
    {
        path: '/ibizsample0003s/:ibizsample0003?/stabexpview/:stabexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.stabexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'stabexpview', parameterName: 'stabexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-stab-exp-view/ibizsample0003-stab-exp-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/smeditview9/:smeditview9?',
        meta: {
            caption: 'entities.ibizorderdetail.views.smeditview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'smeditview9', parameterName: 'smeditview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-smedit-view9/ibizorder-detail-smedit-view9.vue'),
    },
    {
        path: '/ibizsample0018s/:ibizsample0018?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizsample0018.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0018s', parameterName: 'ibizsample0018' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0018-grid-view/ibizsample0018-grid-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf5editview/:sf5editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf5editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf5editview', parameterName: 'sf5editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf5-edit-view/ibizsample0001-sf5-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/sf5editview/:sf5editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf5editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf5editview', parameterName: 'sf5editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf5-edit-view/ibizsample0001-sf5-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/statewizardview/:statewizardview?',
        meta: {
            caption: 'entities.ibizbook.views.statewizardview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'statewizardview', parameterName: 'statewizardview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookstate-wizard-view/ibizbookstate-wizard-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf4editview/:sf4editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf4editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf4editview', parameterName: 'sf4editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf4-edit-view/ibizsample0001-sf4-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/sf4editview/:sf4editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf4editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf4editview', parameterName: 'sf4editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf4-edit-view/ibizsample0001-sf4-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/wfactionview/:wfactionview?',
        meta: {
            caption: 'entities.ibizorder.views.wfactionview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'wfactionview', parameterName: 'wfactionview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-wfaction-view/ibizorder-wfaction-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/odsp_d_wfgridview/:odsp_d_wfgridview?',
        meta: {
            caption: 'entities.ibizorder.views.odsp_d_wfgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'odsp_d_wfgridview', parameterName: 'odsp_d_wfgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-odsp-d-wfgrid-view/ibizorder-odsp-d-wfgrid-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/sf1editview/:sf1editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sf1editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sf1editview', parameterName: 'sf1editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sf1-edit-view/ibizorder-detail-sf1-edit-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-edit-view/ibizsample0001-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-edit-view/ibizsample0001-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizorder.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-grid-view/ibizorder-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/tabexpview/:tabexpview?',
        meta: {
            caption: 'entities.ibizorder.views.tabexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'tabexpview', parameterName: 'tabexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-tab-exp-view/ibizorder-tab-exp-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf6gridview/:sf6gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf6gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf6gridview', parameterName: 'sf6gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf6-grid-view/ibizorder-sf6-grid-view.vue'),
    },
    {
        path: '/ibizordertypes/:ibizordertype?/usr2gridview/:usr2gridview?',
        meta: {
            caption: 'entities.ibizordertype.views.usr2gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizordertypes', parameterName: 'ibizordertype' },
                { pathName: 'usr2gridview', parameterName: 'usr2gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-type-usr2-grid-view/ibizorder-type-usr2-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/f9editview/:f9editview?',
        meta: {
            caption: 'entities.ibizorder.views.f9editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'f9editview', parameterName: 'f9editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-f9-edit-view/ibizorder-f9-edit-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/editview/:editview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-edit-view/ibizuniproduct-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.ibizorder.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-pickup-view/ibizorder-pickup-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/sf4editview/:sf4editview?',
        meta: {
            caption: 'entities.ibizsample0003.views.sf4editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'sf4editview', parameterName: 'sf4editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-sf4-edit-view/ibizsample0003-sf4-edit-view.vue'),
    },
    {
        path: '/ibizsample0014s/:ibizsample0014?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0014.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0014s', parameterName: 'ibizsample0014' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0014-edit-view/ibizsample0014-edit-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/usr2editview/:usr2editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.usr2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'usr2editview', parameterName: 'usr2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-usr2-edit-view/ibizsample0001-usr2-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/usr2editview/:usr2editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.usr2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'usr2editview', parameterName: 'usr2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-usr2-edit-view/ibizsample0001-usr2-edit-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizorderdetail.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-grid-view9/ibizorder-detail-grid-view9.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/wfstartview/:wfstartview?',
        meta: {
            caption: 'entities.ibizorder.views.wfstartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'wfstartview', parameterName: 'wfstartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-wfstart-view/ibizorder-wfstart-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/indexpickupdataview/:indexpickupdataview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.indexpickupdataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'indexpickupdataview', parameterName: 'indexpickupdataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-index-pickup-data-view/ibizuniproduct-index-pickup-data-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/listview/:listview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'listview', parameterName: 'listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-list-view/ibizorder-detail-list-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/f19editview/:f19editview?',
        meta: {
            caption: 'entities.ibizorder.views.f19editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'f19editview', parameterName: 'f19editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-f19-edit-view/ibizorder-f19-edit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.ibizsample0003.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-pickup-view/ibizsample0003-pickup-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/autogrouplistview/:autogrouplistview?',
        meta: {
            caption: 'entities.ibizbook.views.autogrouplistview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'autogrouplistview', parameterName: 'autogrouplistview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookauto-group-list-view/ibizbookauto-group-list-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/ruleseditview/:ruleseditview?',
        meta: {
            caption: 'entities.ibizbook.views.ruleseditview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'ruleseditview', parameterName: 'ruleseditview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookrules-edit-view/ibizbookrules-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/treegridexview/:treegridexview?',
        meta: {
            caption: 'entities.ibizbook.views.treegridexview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'treegridexview', parameterName: 'treegridexview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooktree-grid-ex-view/ibizbooktree-grid-ex-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/f13editview/:f13editview?',
        meta: {
            caption: 'entities.ibizorder.views.f13editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'f13editview', parameterName: 'f13editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-f13-edit-view/ibizorder-f13-edit-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0002.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0002-edit-view/ibizsample0002-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/groupbycodelistkanbanview/:groupbycodelistkanbanview?',
        meta: {
            caption: 'entities.ibizbook.views.groupbycodelistkanbanview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'groupbycodelistkanbanview', parameterName: 'groupbycodelistkanbanview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookgroup-by-codelist-kan-ban-view/ibizbookgroup-by-codelist-kan-ban-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/odsp_d20_wfgridview/:odsp_d20_wfgridview?',
        meta: {
            caption: 'entities.ibizorder.views.odsp_d20_wfgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'odsp_d20_wfgridview', parameterName: 'odsp_d20_wfgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-odsp-d20-wfgrid-view/ibizorder-odsp-d20-wfgrid-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/f6editview/:f6editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.f6editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'f6editview', parameterName: 'f6editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-f6-edit-view/ibizorder-detail-f6-edit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/f3treeexpview/:f3treeexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.f3treeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'f3treeexpview', parameterName: 'f3treeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-f3-tree-exp-view/ibizsample0003-f3-tree-exp-view.vue'),
    },
    {
        path: '/ibizsample0017s/:ibizsample0017?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizsample0017.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0017-grid-view/ibizsample0017-grid-view.vue'),
    },
    {
        path: '/ibizsample0018s/:ibizsample0018?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0018.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0018s', parameterName: 'ibizsample0018' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0018-edit-view/ibizsample0018-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2gridview/:usr2gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr2gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2gridview', parameterName: 'usr2gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-grid-view/ibizbookusr2-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/seditview3/:seditview3?',
        meta: {
            caption: 'entities.ibizorder.views.seditview3.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'seditview3', parameterName: 'seditview3' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sedit-view3/ibizorder-sedit-view3.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf1gridview/:sf1gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf1gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf1gridview', parameterName: 'sf1gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf1-grid-view/ibizorder-sf1-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/linechartview/:linechartview?',
        meta: {
            caption: 'entities.ibizorder.views.linechartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'linechartview', parameterName: 'linechartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-line-chart-view/ibizorder-line-chart-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizcustomer.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-pickup-grid-view/ibizcustomer-pickup-grid-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/streeexpview/:streeexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.streeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'streeexpview', parameterName: 'streeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-stree-exp-view/ibizsample0003-stree-exp-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/haspanellistview/:haspanellistview?',
        meta: {
            caption: 'entities.ibizbook.views.haspanellistview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'haspanellistview', parameterName: 'haspanellistview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookhas-panel-list-view/ibizbookhas-panel-list-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/radarchartview/:radarchartview?',
        meta: {
            caption: 'entities.ibizorder.views.radarchartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'radarchartview', parameterName: 'radarchartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-radar-chart-view/ibizorder-radar-chart-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2calendarview/:usr2calendarview?',
        meta: {
            caption: 'entities.ibizbook.views.usr2calendarview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2calendarview', parameterName: 'usr2calendarview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-calendar-view/ibizbookusr2-calendar-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-grid-view/ibizorder-detail-grid-view.vue'),
    },
    {
        path: '/ibizsample0017s/:ibizsample0017?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0017.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0017-edit-view/ibizsample0017-edit-view.vue'),
    },
    {
        path: '/ibizsoftwaresuits/:ibizsoftwaresuit?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizsoftwaresuit.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsoftware-suit-grid-view9/ibizsoftware-suit-grid-view9.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/valuerulesgridview/:valuerulesgridview?',
        meta: {
            caption: 'entities.ibizbook.views.valuerulesgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'valuerulesgridview', parameterName: 'valuerulesgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookvalue-rules-grid-view/ibizbookvalue-rules-grid-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/streeexpview2/:streeexpview2?',
        meta: {
            caption: 'entities.ibizsample0003.views.streeexpview2.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'streeexpview2', parameterName: 'streeexpview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-stree-exp-view2/ibizsample0003-stree-exp-view2.vue'),
    },
    {
        path: '/ibizsoftwaresuits/:ibizsoftwaresuit?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsoftwaresuit.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsoftware-suit-edit-view/ibizsoftware-suit-edit-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/seditview9/:seditview9?',
        meta: {
            caption: 'entities.ibizorderdetail.views.seditview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'seditview9', parameterName: 'seditview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sedit-view9/ibizorder-detail-sedit-view9.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2meditview9/:usr2meditview9?',
        meta: {
            caption: 'entities.ibizbook.views.usr2meditview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2meditview9', parameterName: 'usr2meditview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-medit-view9/ibizbookusr2-medit-view9.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.ibizsample0002.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0002-pickup-view/ibizsample0002-pickup-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/meditview9/:meditview9?',
        meta: {
            caption: 'entities.ibizbook.views.meditview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'meditview9', parameterName: 'meditview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookmedit-view9/ibizbookmedit-view9.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/f4treeexpview/:f4treeexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.f4treeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'f4treeexpview', parameterName: 'f4treeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-f4-tree-exp-view/ibizsample0003-f4-tree-exp-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizsample0003.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-pickup-grid-view/ibizsample0003-pickup-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/seditview/:seditview?',
        meta: {
            caption: 'entities.ibizorder.views.seditview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'seditview', parameterName: 'seditview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sedit-view/ibizorder-sedit-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/usr2gridview/:usr2gridview?',
        meta: {
            caption: 'entities.ibizsample0001.views.usr2gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'usr2gridview', parameterName: 'usr2gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-usr2-grid-view/ibizsample0001-usr2-grid-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/usr2gridview/:usr2gridview?',
        meta: {
            caption: 'entities.ibizsample0001.views.usr2gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'usr2gridview', parameterName: 'usr2gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-usr2-grid-view/ibizsample0001-usr2-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/gridexpview/:gridexpview?',
        meta: {
            caption: 'entities.ibizorder.views.gridexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'gridexpview', parameterName: 'gridexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-grid-exp-view/ibizorder-grid-exp-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf2editview/:sf2editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf2editview', parameterName: 'sf2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf2-edit-view/ibizsample0001-sf2-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/sf2editview/:sf2editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf2editview', parameterName: 'sf2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf2-edit-view/ibizsample0001-sf2-edit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/smpickupview2/:smpickupview2?',
        meta: {
            caption: 'entities.ibizsample0003.views.smpickupview2.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'smpickupview2', parameterName: 'smpickupview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-smpickup-view2/ibizsample0003-smpickup-view2.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/odsp_d10_wfgridview/:odsp_d10_wfgridview?',
        meta: {
            caption: 'entities.ibizorder.views.odsp_d10_wfgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'odsp_d10_wfgridview', parameterName: 'odsp_d10_wfgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-odsp-d10-wfgrid-view/ibizorder-odsp-d10-wfgrid-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizsample0003.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-grid-view/ibizsample0003-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf7editview/:sf7editview?',
        meta: {
            caption: 'entities.ibizorder.views.sf7editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf7editview', parameterName: 'sf7editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf7-edit-view/ibizorder-sf7-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr5gridview/:usr5gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr5gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr5gridview', parameterName: 'usr5gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr5-grid-view/ibizbookusr5-grid-view.vue'),
    },
    {
        path: '/ibizsample0017s/:ibizsample0017?/f10editview/:f10editview?',
        meta: {
            caption: 'entities.ibizsample0017.views.f10editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                { pathName: 'f10editview', parameterName: 'f10editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0017-f10-edit-view/ibizsample0017-f10-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/seditview4/:seditview4?',
        meta: {
            caption: 'entities.ibizorder.views.seditview4.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'seditview4', parameterName: 'seditview4' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sedit-view4/ibizorder-sedit-view4.vue'),
    },
    {
        path: '/ibizstorages/:ibizstorage?/editview/:editview?',
        meta: {
            caption: 'entities.ibizstorage.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizstorages', parameterName: 'ibizstorage' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizstorage-edit-view/ibizstorage-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr3calendarview/:usr3calendarview?',
        meta: {
            caption: 'entities.ibizbook.views.usr3calendarview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr3calendarview', parameterName: 'usr3calendarview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr3-calendar-view/ibizbookusr3-calendar-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizsample0002.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0002-pickup-grid-view/ibizsample0002-pickup-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizorder.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sgrid-view/ibizorder-sgrid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/barchartview/:barchartview?',
        meta: {
            caption: 'entities.ibizorder.views.barchartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'barchartview', parameterName: 'barchartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-bar-chart-view/ibizorder-bar-chart-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/dashboardview/:dashboardview?',
        meta: {
            caption: 'entities.ibizorder.views.dashboardview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'dashboardview', parameterName: 'dashboardview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-dashboard-view/ibizorder-dashboard-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-pickup-grid-view/ibizuniproduct-pickup-grid-view.vue'),
    },
    {
        path: '/ibizordertypes/:ibizordertype?/usr2editview/:usr2editview?',
        meta: {
            caption: 'entities.ibizordertype.views.usr2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizordertypes', parameterName: 'ibizordertype' },
                { pathName: 'usr2editview', parameterName: 'usr2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-type-usr2-edit-view/ibizorder-type-usr2-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf1editview/:sf1editview?',
        meta: {
            caption: 'entities.ibizorder.views.sf1editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf1editview', parameterName: 'sf1editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf1-edit-view/ibizorder-sf1-edit-view.vue'),
    },
    {
        path: '/ibizhardwares/:ibizhardware?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizhardware.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizhardware-grid-view9/ibizhardware-grid-view9.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/sf3editview/:sf3editview?',
        meta: {
            caption: 'entities.ibizsample0003.views.sf3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'sf3editview', parameterName: 'sf3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-sf3-edit-view/ibizsample0003-sf3-edit-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/indexpickupview/:indexpickupview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.indexpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'indexpickupview', parameterName: 'indexpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-index-pickup-view/ibizuniproduct-index-pickup-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/sf1editview/:sf1editview?',
        meta: {
            caption: 'entities.ibizsample0003.views.sf1editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'sf1editview', parameterName: 'sf1editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-sf1-edit-view/ibizsample0003-sf1-edit-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/sf2editview/:sf2editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sf2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sf2editview', parameterName: 'sf2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sf2-edit-view/ibizorder-detail-sf2-edit-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/editview/:editview?',
        meta: {
            caption: 'entities.ibizcustomer.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-edit-view/ibizcustomer-edit-view.vue'),
    },
    {
        path: '/ibizhardwares/:ibizhardware?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizhardware.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizhardware-sgrid-view/ibizhardware-sgrid-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/usr3gridview/:usr3gridview?',
        meta: {
            caption: 'entities.ibizsample0001.views.usr3gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'usr3gridview', parameterName: 'usr3gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-usr3-grid-view/ibizsample0001-usr3-grid-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/usr3gridview/:usr3gridview?',
        meta: {
            caption: 'entities.ibizsample0001.views.usr3gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'usr3gridview', parameterName: 'usr3gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-usr3-grid-view/ibizsample0001-usr3-grid-view.vue'),
    },
    {
        path: '/ibizsample0017s/:ibizsample0017?/f20editview/:f20editview?',
        meta: {
            caption: 'entities.ibizsample0017.views.f20editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                { pathName: 'f20editview', parameterName: 'f20editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0017-f20-edit-view/ibizsample0017-f20-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr4gridview/:usr4gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr4gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr4gridview', parameterName: 'usr4gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr4-grid-view/ibizbookusr4-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/interfunckanbanview/:interfunckanbanview?',
        meta: {
            caption: 'entities.ibizbook.views.interfunckanbanview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'interfunckanbanview', parameterName: 'interfunckanbanview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookinter-func-kan-ban-view/ibizbookinter-func-kan-ban-view.vue'),
    },
    {
        path: '/ibizsample0014s/:ibizsample0014?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizsample0014.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0014s', parameterName: 'ibizsample0014' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0014-grid-view/ibizsample0014-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/piechartview/:piechartview?',
        meta: {
            caption: 'entities.ibizorder.views.piechartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'piechartview', parameterName: 'piechartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-pie-chart-view/ibizorder-pie-chart-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/odsp_w10_wfgridview/:odsp_w10_wfgridview?',
        meta: {
            caption: 'entities.ibizorder.views.odsp_w10_wfgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'odsp_w10_wfgridview', parameterName: 'odsp_w10_wfgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-odsp-w10-wfgrid-view/ibizorder-odsp-w10-wfgrid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf3editview/:sf3editview?',
        meta: {
            caption: 'entities.ibizorder.views.sf3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf3editview', parameterName: 'sf3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf3-edit-view/ibizorder-sf3-edit-view.vue'),
    },
    {
        path: '/ibizsample0017s/:ibizsample0017?/formpickupdataview/:formpickupdataview?',
        meta: {
            caption: 'entities.ibizsample0017.views.formpickupdataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                { pathName: 'formpickupdataview', parameterName: 'formpickupdataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0017-form-pickup-data-view/ibizsample0017-form-pickup-data-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/wizardview/:wizardview?',
        meta: {
            caption: 'entities.ibizbook.views.wizardview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'wizardview', parameterName: 'wizardview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookwizard-view/ibizbookwizard-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/spickuptreeview/:spickuptreeview?',
        meta: {
            caption: 'entities.ibizsample0003.views.spickuptreeview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'spickuptreeview', parameterName: 'spickuptreeview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-spickup-tree-view/ibizsample0003-spickup-tree-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/haspanelkanbanview/:haspanelkanbanview?',
        meta: {
            caption: 'entities.ibizbook.views.haspanelkanbanview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'haspanelkanbanview', parameterName: 'haspanelkanbanview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookhas-panel-kan-ban-view/ibizbookhas-panel-kan-ban-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/editview/:editview?',
        meta: {
            caption: 'entities.ibizsample0003.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-edit-view/ibizsample0003-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/f8editview/:f8editview?',
        meta: {
            caption: 'entities.ibizorder.views.f8editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'f8editview', parameterName: 'f8editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-f8-edit-view/ibizorder-f8-edit-view.vue'),
    },
    {
        path: '/ibizsample0017s/:ibizsample0017?/formpickupview/:formpickupview?',
        meta: {
            caption: 'entities.ibizsample0017.views.formpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                { pathName: 'formpickupview', parameterName: 'formpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0017-form-pickup-view/ibizsample0017-form-pickup-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizuniproduct.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-grid-view9/ibizuniproduct-grid-view9.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/odsp_wfexpview/:odsp_wfexpview?',
        meta: {
            caption: 'entities.ibizorder.views.odsp_wfexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'odsp_wfexpview', parameterName: 'odsp_wfexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-odsp-wfexp-view/ibizorder-odsp-wfexp-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/odsp_d30_wfgridview/:odsp_d30_wfgridview?',
        meta: {
            caption: 'entities.ibizorder.views.odsp_d30_wfgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'odsp_d30_wfgridview', parameterName: 'odsp_d30_wfgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-odsp-d30-wfgrid-view/ibizorder-odsp-d30-wfgrid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.ibizorder.views.pickupgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-pickup-grid-view/ibizorder-pickup-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/gridview9/:gridview9?',
        meta: {
            caption: 'entities.ibizorder.views.gridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'gridview9', parameterName: 'gridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-grid-view9/ibizorder-grid-view9.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/f10editview/:f10editview?',
        meta: {
            caption: 'entities.ibizorder.views.f10editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'f10editview', parameterName: 'f10editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-f10-edit-view/ibizorder-f10-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/listview/:listview?',
        meta: {
            caption: 'entities.ibizbook.views.listview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'listview', parameterName: 'listview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooklist-view/ibizbooklist-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/ibizsample0001s/:ibizsample0001?/sf6editview/:sf6editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf6editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf6editview', parameterName: 'sf6editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf6-edit-view/ibizsample0001-sf6-edit-view.vue'),
    },
    {
        path: '/ibizsample0001s/:ibizsample0001?/sf6editview/:sf6editview?',
        meta: {
            caption: 'entities.ibizsample0001.views.sf6editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0001s', parameterName: 'ibizsample0001' },
                { pathName: 'sf6editview', parameterName: 'sf6editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0001-sf6-edit-view/ibizsample0001-sf6-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/s2editview/:s2editview?',
        meta: {
            caption: 'entities.ibizorder.views.s2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 's2editview', parameterName: 's2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-s2-edit-view/ibizorder-s2-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/customview/:customview?',
        meta: {
            caption: 'entities.ibizbook.views.customview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'customview', parameterName: 'customview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookcustom-view/ibizbookcustom-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-sgrid-view/ibizuniproduct-sgrid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/editview/:editview?',
        meta: {
            caption: 'entities.ibizbook.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookedit-view/ibizbookedit-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/sgridview9/:sgridview9?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sgridview9.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sgridview9', parameterName: 'sgridview9' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sgrid-view9/ibizorder-detail-sgrid-view9.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf5gridview/:sf5gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf5gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf5gridview', parameterName: 'sf5gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf5-grid-view/ibizorder-sf5-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf2editview/:sf2editview?',
        meta: {
            caption: 'entities.ibizorder.views.sf2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf2editview', parameterName: 'sf2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf2-edit-view/ibizorder-sf2-edit-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/mpickupview/:mpickupview?',
        meta: {
            caption: 'entities.ibizsample0002.views.mpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'mpickupview', parameterName: 'mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0002-mpickup-view/ibizsample0002-mpickup-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/usr3editview/:usr3editview?',
        meta: {
            caption: 'entities.ibizorder.views.usr3editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'usr3editview', parameterName: 'usr3editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-usr3-edit-view/ibizorder-usr3-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/roweditgridview/:roweditgridview?',
        meta: {
            caption: 'entities.ibizbook.views.roweditgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'roweditgridview', parameterName: 'roweditgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookrow-edit-grid-view/ibizbookrow-edit-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/odsp_w_wfgridview/:odsp_w_wfgridview?',
        meta: {
            caption: 'entities.ibizorder.views.odsp_w_wfgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'odsp_w_wfgridview', parameterName: 'odsp_w_wfgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-odsp-w-wfgrid-view/ibizorder-odsp-w-wfgrid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr6gridview/:usr6gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr6gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr6gridview', parameterName: 'usr6gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr6-grid-view/ibizbookusr6-grid-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/editview/:editview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-edit-view/ibizorder-detail-edit-view.vue'),
    },
    {
        path: '/ibizsoftwaresuits/:ibizsoftwaresuit?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizsoftwaresuit.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsoftwaresuits', parameterName: 'ibizsoftwaresuit' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsoftware-suit-sgrid-view/ibizsoftware-suit-sgrid-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/chartview/:chartview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.chartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'chartview', parameterName: 'chartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-chart-view/ibizorder-detail-chart-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/f6gridview/:f6gridview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.f6gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'f6gridview', parameterName: 'f6gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-f6-grid-view/ibizorder-detail-f6-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/areachartview/:areachartview?',
        meta: {
            caption: 'entities.ibizorder.views.areachartview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'areachartview', parameterName: 'areachartview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-area-chart-view/ibizorder-area-chart-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/mpickupview/:mpickupview?',
        meta: {
            caption: 'entities.ibizsample0003.views.mpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'mpickupview', parameterName: 'mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-mpickup-view/ibizsample0003-mpickup-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/seditview2/:seditview2?',
        meta: {
            caption: 'entities.ibizorder.views.seditview2.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'seditview2', parameterName: 'seditview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sedit-view2/ibizorder-sedit-view2.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/usr2editview/:usr2editview?',
        meta: {
            caption: 'entities.ibizorder.views.usr2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'usr2editview', parameterName: 'usr2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-usr2-edit-view/ibizorder-usr2-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf4gridview/:sf4gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf4gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf4gridview', parameterName: 'sf4gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf4-grid-view/ibizorder-sf4-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/odsp_d40_wfgridview/:odsp_d40_wfgridview?',
        meta: {
            caption: 'entities.ibizorder.views.odsp_d40_wfgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'odsp_d40_wfgridview', parameterName: 'odsp_d40_wfgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-odsp-d40-wfgrid-view/ibizorder-odsp-d40-wfgrid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr4dataview/:usr4dataview?',
        meta: {
            caption: 'entities.ibizbook.views.usr4dataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr4dataview', parameterName: 'usr4dataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr4-data-view/ibizbookusr4-data-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf3gridview/:sf3gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf3gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf3gridview', parameterName: 'sf3gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf3-grid-view/ibizorder-sf3-grid-view.vue'),
    },
    {
        path: '/ibizsample0002s/:ibizsample0002?/gridview/:gridview?',
        meta: {
            caption: 'entities.ibizsample0002.views.gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0002s', parameterName: 'ibizsample0002' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0002-grid-view/ibizsample0002-grid-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/f2treeexpview/:f2treeexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.f2treeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'f2treeexpview', parameterName: 'f2treeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-f2-tree-exp-view/ibizsample0003-f2-tree-exp-view.vue'),
    },
    {
        path: '/ibizcpus/:ibizcpu?/editview/:editview?',
        meta: {
            caption: 'entities.ibizcpu.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcpus', parameterName: 'ibizcpu' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcpuedit-view/ibizcpuedit-view.vue'),
    },
    {
        path: '/ibizsample0017s/:ibizsample0017?/f30editview/:f30editview?',
        meta: {
            caption: 'entities.ibizsample0017.views.f30editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0017s', parameterName: 'ibizsample0017' },
                { pathName: 'f30editview', parameterName: 'f30editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0017-f30-edit-view/ibizsample0017-f30-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr3gridview/:usr3gridview?',
        meta: {
            caption: 'entities.ibizbook.views.usr3gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr3gridview', parameterName: 'usr3gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr3-grid-view/ibizbookusr3-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/dataview/:dataview?',
        meta: {
            caption: 'entities.ibizbook.views.dataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'dataview', parameterName: 'dataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookdata-view/ibizbookdata-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/interfunceditview/:interfunceditview?',
        meta: {
            caption: 'entities.ibizbook.views.interfunceditview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'interfunceditview', parameterName: 'interfunceditview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookinter-func-edit-view/ibizbookinter-func-edit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/spickupview2/:spickupview2?',
        meta: {
            caption: 'entities.ibizsample0003.views.spickupview2.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'spickupview2', parameterName: 'spickupview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-spickup-view2/ibizsample0003-spickup-view2.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr3dataview/:usr3dataview?',
        meta: {
            caption: 'entities.ibizbook.views.usr3dataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr3dataview', parameterName: 'usr3dataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr3-data-view/ibizbookusr3-data-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/zdytpgridview/:zdytpgridview?',
        meta: {
            caption: 'entities.ibizorder.views.zdytpgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'zdytpgridview', parameterName: 'zdytpgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-zdytpgrid-view/ibizorder-zdytpgrid-view.vue'),
    },
    {
        path: '/ibizhardwares/:ibizhardware?/editview/:editview?',
        meta: {
            caption: 'entities.ibizhardware.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizhardware-edit-view/ibizhardware-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/updatedefaultgridview/:updatedefaultgridview?',
        meta: {
            caption: 'entities.ibizbook.views.updatedefaultgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'updatedefaultgridview', parameterName: 'updatedefaultgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookupdate-default-grid-view/ibizbookupdate-default-grid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf4editview/:sf4editview?',
        meta: {
            caption: 'entities.ibizorder.views.sf4editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf4editview', parameterName: 'sf4editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf4-edit-view/ibizorder-sf4-edit-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/sf5editview/:sf5editview?',
        meta: {
            caption: 'entities.ibizsample0003.views.sf5editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'sf5editview', parameterName: 'sf5editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-sf5-edit-view/ibizsample0003-sf5-edit-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sgridview2/:sgridview2?',
        meta: {
            caption: 'entities.ibizorder.views.sgridview2.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sgridview2', parameterName: 'sgridview2' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sgrid-view2/ibizorder-sgrid-view2.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/ganttview/:ganttview?',
        meta: {
            caption: 'entities.ibizbook.views.ganttview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'ganttview', parameterName: 'ganttview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookgantt-view/ibizbookgantt-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/usr2dataview/:usr2dataview?',
        meta: {
            caption: 'entities.ibizbook.views.usr2dataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'usr2dataview', parameterName: 'usr2dataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookusr2-data-view/ibizbookusr2-data-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/f1treeexpview/:f1treeexpview?',
        meta: {
            caption: 'entities.ibizsample0003.views.f1treeexpview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'f1treeexpview', parameterName: 'f1treeexpview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-f1-tree-exp-view/ibizsample0003-f1-tree-exp-view.vue'),
    },
    {
        path: '/ibizuniproducts/:ibizuniproduct?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.ibizuniproduct.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizuniproducts', parameterName: 'ibizuniproduct' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizuniproduct-pickup-view/ibizuniproduct-pickup-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/groupbycodelistlistview/:groupbycodelistlistview?',
        meta: {
            caption: 'entities.ibizbook.views.groupbycodelistlistview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'groupbycodelistlistview', parameterName: 'groupbycodelistlistview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookgroup-by-codelist-list-view/ibizbookgroup-by-codelist-list-view.vue'),
    },
    {
        path: '/ibizhardwares/:ibizhardware?/indexpickupdataview/:indexpickupdataview?',
        meta: {
            caption: 'entities.ibizhardware.views.indexpickupdataview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                { pathName: 'indexpickupdataview', parameterName: 'indexpickupdataview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizhardware-index-pickup-data-view/ibizhardware-index-pickup-data-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/optionview/:optionview?',
        meta: {
            caption: 'entities.ibizbook.views.optionview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'optionview', parameterName: 'optionview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookoption-view/ibizbookoption-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/calendarview/:calendarview?',
        meta: {
            caption: 'entities.ibizbook.views.calendarview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'calendarview', parameterName: 'calendarview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookcalendar-view/ibizbookcalendar-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/editview/:editview?',
        meta: {
            caption: 'entities.ibizorder.views.editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-edit-view/ibizorder-edit-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/internalfuncgridview/:internalfuncgridview?',
        meta: {
            caption: 'entities.ibizbook.views.internalfuncgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'internalfuncgridview', parameterName: 'internalfuncgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbookinternal-func-grid-view/ibizbookinternal-func-grid-view.vue'),
    },
    {
        path: '/ibizcustomers/:ibizcustomer?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.ibizcustomer.views.pickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizcustomers', parameterName: 'ibizcustomer' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizcustomer-pickup-view/ibizcustomer-pickup-view.vue'),
    },
    {
        path: '/ibizorderdetails/:ibizorderdetail?/sgridview/:sgridview?',
        meta: {
            caption: 'entities.ibizorderdetail.views.sgridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorderdetails', parameterName: 'ibizorderdetail' },
                { pathName: 'sgridview', parameterName: 'sgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-detail-sgrid-view/ibizorder-detail-sgrid-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf20gridview/:sf20gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf20gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf20gridview', parameterName: 'sf20gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf20-grid-view/ibizorder-sf20-grid-view.vue'),
    },
    {
        path: '/ibizbooks/:ibizbook?/newdefaultvaluegridview/:newdefaultvaluegridview?',
        meta: {
            caption: 'entities.ibizbook.views.newdefaultvaluegridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizbooks', parameterName: 'ibizbook' },
                { pathName: 'newdefaultvaluegridview', parameterName: 'newdefaultvaluegridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizbooknew-default-value-grid-view/ibizbooknew-default-value-grid-view.vue'),
    },
    {
        path: '/ibizsample0003s/:ibizsample0003?/sf2editview/:sf2editview?',
        meta: {
            caption: 'entities.ibizsample0003.views.sf2editview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizsample0003s', parameterName: 'ibizsample0003' },
                { pathName: 'sf2editview', parameterName: 'sf2editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizsample0003-sf2-edit-view/ibizsample0003-sf2-edit-view.vue'),
    },
    {
        path: '/ibizhardwares/:ibizhardware?/indexpickupview/:indexpickupview?',
        meta: {
            caption: 'entities.ibizhardware.views.indexpickupview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizhardwares', parameterName: 'ibizhardware' },
                { pathName: 'indexpickupview', parameterName: 'indexpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizhardware-index-pickup-view/ibizhardware-index-pickup-view.vue'),
    },
    {
        path: '/ibizorders/:ibizorder?/sf15gridview/:sf15gridview?',
        meta: {
            caption: 'entities.ibizorder.views.sf15gridview.caption',
            info:'',
            parameters: [
                { pathName: 'ibizorders', parameterName: 'ibizorder' },
                { pathName: 'sf15gridview', parameterName: 'sf15gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/sample/ibizorder-sf15-grid-view/ibizorder-sf15-grid-view.vue'),
    },
    {
        path: '/apppanelview/:apppanelview?',
        meta: {
            caption: 'app.views.apppanelview.caption',
            info:'',
            parameters: [
                { pathName: 'apppanelview', parameterName: 'apppanelview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/ungroup/app-panel-view/app-panel-view.vue'),
    },
        ...globalRoutes,
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                router.app.$store.commit('resetRootStateData');
                next();
            },
            component: () => import('@components/login/login.vue'),
        },
        {
            path: '/lock',
            name: 'lock',
            meta: {  
                caption: '锁屏',
                viewType: 'lock',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                next();
            },
            component: () => import('@components/app-lock/app-lock.vue'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'index'
        },
    ],
});
// 解决路由跳转路由重复时报错
const originalPush = Router.prototype.push
Router.prototype.push = function push(location: any) {
    let result: any = originalPush.call(this, location);
    return result.catch((err: any) => err);
}
export default router;
