import { Http,Util } from '@/utils';
import FormLoadUILogicBase from './form-load-ui-logic-base';

/**
 * 表单加载
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic.ts.ftl 生成
 * @export
 * @class FormLoadUILogic
 */
export default class FormLoadUILogic extends FormLoadUILogicBase {

    /**
     * 表单加载 逻辑实例对象
     *
     * @private
     * @static
     * @type {FormLoadUILogic}
     * @memberof FormLoadUILogic
     */
    private static instance: FormLoadUILogic;

    /**
     * 获取 表单加载 逻辑实例对象
     *
     * @static
     * @return {*}  {FormLoadUILogic}
     * @memberof FormLoadUILogic
     */
    static getInstance(): FormLoadUILogic {
        if (!this.instance) {
            this.instance = new FormLoadUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  FormLoadUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  FormLoadUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}