import { Http,Util } from '@/utils';
import EventTestUILogicBase from './event-test-ui-logic-base';

/**
 * 事件调用与事件触发
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic.ts.ftl 生成
 * @export
 * @class EventTestUILogic
 */
export default class EventTestUILogic extends EventTestUILogicBase {

    /**
     * 事件调用与事件触发 逻辑实例对象
     *
     * @private
     * @static
     * @type {EventTestUILogic}
     * @memberof EventTestUILogic
     */
    private static instance: EventTestUILogic;

    /**
     * 获取 事件调用与事件触发 逻辑实例对象
     *
     * @static
     * @return {*}  {EventTestUILogic}
     * @memberof EventTestUILogic
     */
    static getInstance(): EventTestUILogic {
        if (!this.instance) {
            this.instance = new EventTestUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  EventTestUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  EventTestUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}