import IBIZUNIProductService from '@/service/ibizuniproduct/ibizuniproduct-service';
import IBIZOrderService from '@/service/ibizorder/ibizorder-service';
import IBIZOrderDetailService from '@/service/ibizorder-detail/ibizorder-detail-service';
import { Verify } from '@/utils/verify/verify';


/**
 * 通过商品ID获取单价及单位
 * 基于 APP/src/service/%DE_PKGPATH%/%APP_DELOGIC%-logic-base.ts.ftl 生成
 * @export
 * @class GetUnitAndPriceLogicBase
 */
export default class GetUnitAndPriceLogicBase {

    /**
     * 名称
     * 
     * @memberof  GetUnitAndPriceLogicBase
     */
    private name:string ="GetUnitAndPrice";

    /**
     * 唯一标识
     * 
     * @memberof  GetUnitAndPriceLogicBase
     */
    private id:string = "ded186a4036f371f623ecdb8b799f94c";

    /**
     * 默认参数名称
     * 
     * @memberof  GetUnitAndPriceLogicBase
     */
    private defaultParamName:string = "Default";

    /**
     * 参数集合
     * 
     * @memberof  GetUnitAndPriceLogicBase
     */
    private paramsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  GetUnitAndPriceLogicBase.
     * 
     * @param {*} [opts={}]
     * @memberof  GetUnitAndPriceLogicBase
     */
    constructor(opts: any = {}) {
        this.initParams(opts);
    }

    /**
     * 初始化参数集合
     * 
     * @param {*} [opts={}]
     * @memberof  GetUnitAndPriceLogicBase
     */
    public initParams(opts:any){
        this.paramsMap.set('Product',{});
        this.paramsMap.set('Default',opts);
        this.paramsMap.set('list',{});
        this.paramsMap.set('Order',{});
        this.paramsMap.set('page',{});
        this.paramsMap.set('filter',{});
    }


    /**
     * 计算0节点结果
     * 
     * @param params 传入参数
     */
    public compute0Cond(params:any):boolean{
        return true;
    }

    /**
     * 计算1节点结果
     * 
     * @param params 传入参数
     */
    public compute1Cond(params:any):boolean{
        return true;
    }

    /**
     * 计算2节点结果
     * 
     * @param params 传入参数
     */
    public compute2Cond(params:any):boolean{
        return true;
    }

    /**
     * 计算3节点结果
     * 
     * @param params 传入参数
     */
    public compute3Cond(params:any):boolean{
        return true;
    }

    /**
     * 计算4节点结果
     * 
     * @param params 传入参数
     */
    public compute4Cond(params:any):boolean{
        return true;
    }

    /**
     * 计算5节点结果
     * 
     * @param params 传入参数
     */
    public compute5Cond(params:any):boolean{
        if(Verify.testCond(params.amount, 'GT', '100')){
           return true;
        }else{
            return false;
        }
    }

    /**
     * 计算6节点结果
     * 
     * @param params 传入参数
     */
    public compute6Cond(params:any):boolean{
        if(Verify.testCond(params.amount, 'GT', 'PRICE')){
           return true;
        }else{
            return false;
        }
    }

    /**
     * 计算7节点结果
     * 
     * @param params 传入参数
     */
    public compute7Cond(params:any):boolean{
        if(Verify.testCond(params.createdate, 'GTANDEQ', 'CREATEDATE')){
           return true;
        }else{
            return false;
        }
    }

    /**
     * 计算8节点结果
     * 
     * @param params 传入参数
     */
    public compute8Cond(params:any):boolean{
        if(Verify.testCond(params.ordertime, 'LTANDEQ', '')){
           return true;
        }else{
            return false;
        }
    }

    /**
     * 计算9节点结果
     * 
     * @param params 传入参数
     */
    public compute9Cond(params:any):boolean{
        return true;
    }

    /**
     * 计算10节点结果
     * 
     * @param params 传入参数
     */
    public compute10Cond(params:any):boolean{
        if(Verify.testCond(params.unitprice, 'GT', 'Amount')){
           return true;
        }else{
            return false;
        }
    }

    /**
     * 计算11节点结果
     * 
     * @param params 传入参数
     */
    public compute11Cond(params:any):boolean{
        return true;
    }

    /**
     * 计算12节点结果
     * 
     * @param params 传入参数
     */
    public compute12Cond(params:any):boolean{
        return true;
    }

    /**
     * 计算13节点结果
     * 
     * @param params 传入参数
     */
    public compute13Cond(params:any):boolean{
        return true;
    }

    /**
     * 执行逻辑
     * 
     * @param context 应用上下文
     * @param params 传入参数
     */
    public onExecute(context:any,params:any,isloading:boolean){
        return this.executeBegin(context,params,isloading);
    }


    /**
    * 开始
    * 
    * @param params 传入参数
    */
    private async executeBegin(context:any,params:any,isloading:boolean){
        //开始节点
        if(this.compute0Cond(params)){
            return this.executePrepareparam1(context,params,isloading);   
        }
    }

    /**
    * 统计金额
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDELOGIC1(context:any,params:any,isloading:boolean){
        // DELOGIC暂未支持
        console.log("DELOGIC暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 大于200处理
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDEBUGPARAM2(context:any,params:any,isloading:boolean){
        // DEBUGPARAM暂未支持
        console.log("DEBUGPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 获取商品ID
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executePrepareparam1(context:any,params:any,isloading:boolean){
        // 准备参数节点
    let tempDstParam0Context:any = this.paramsMap.get('Product').context?this.paramsMap.get('Product').context:{};
    let tempDstParam0Data:any = this.paramsMap.get('Product').data?this.paramsMap.get('Product').data:{};
    let tempSrcParam0Data:any = this.paramsMap.get('Default').data?this.paramsMap.get('Default').data:{};
    Object.assign(tempDstParam0Context,{ibizuniproduct:tempSrcParam0Data['ibizuniproductid']});
    Object.assign(tempDstParam0Data,{ibizuniproductid:tempSrcParam0Data['ibizuniproductid']});
    this.paramsMap.set('Product',{data:tempDstParam0Data,context:tempDstParam0Context});
        if(this.compute1Cond(params)){
            return this.executeDeaction1(context,params,isloading);   
        }
    }

    /**
    * 获取商品信息
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDeaction1(context:any,params:any,isloading:boolean){
        // 行为处理节点
        let result: any;
        let actionParam:any = this.paramsMap.get('Product');
        const targetService:IBIZUNIProductService = new IBIZUNIProductService();
        if (targetService['Get'] && targetService['Get'] instanceof Function) {
            result = await targetService['Get'](actionParam.context,actionParam.data, false);
        }
        if(result && result.status == 200){
            Object.assign(actionParam.data,result.data);
        if(this.compute2Cond(params)){
            return this.executePrepareparam2(context,params,isloading);   
        }
        if(this.compute3Cond(params)){
            return this.executeThrowexception(context,params,isloading);   
        }
        }
    }

    /**
    * 获取订单信息
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDEACTION2(context:any,params:any,isloading:boolean){
        // 行为处理节点
        let result: any;
        let actionParam:any = this.paramsMap.get('Order');
        const targetService:IBIZOrderService = new IBIZOrderService();
        if (targetService['Get'] && targetService['Get'] instanceof Function) {
            result = await targetService['Get'](actionParam.context,actionParam.data, false);
        }
        if(result && result.status == 200){
            Object.assign(actionParam.data,result.data);
        if(this.compute4Cond(params)){
            return this.executeTHROWEXCEPTION2(context,params,isloading);   
        }
        if(this.compute5Cond(params)){
            return this.executeDEBUGPARAM1(context,params,isloading);   
        }
        if(this.compute6Cond(params)){
            return this.executeDEBUGPARAM2(context,params,isloading);   
        }
        if(this.compute7Cond(params)){
            return this.executeDEBUGPARAM4(context,params,isloading);   
        }
        if(this.compute8Cond(params)){
            return this.executeDEBUGPARAM5(context,params,isloading);   
        }
        if(this.compute9Cond(params)){
            return this.executeDEBUGPARAM3(context,params,isloading);   
        }
        }
    }

    /**
    * 拷贝参数
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeCOPYPARAM1(context:any,params:any,isloading:boolean){
        // COPYPARAM暂未支持
        console.log("COPYPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 实体数据集
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDEDATASET1(context:any,params:any,isloading:boolean){
        // DEDATASET暂未支持
        console.log("DEDATASET暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 填充单位和单价
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executePrepareparam2(context:any,params:any,isloading:boolean){
        // 准备参数节点
    let tempDstParam0Context:any = this.paramsMap.get('Default').context?this.paramsMap.get('Default').context:{};
    let tempDstParam0Data:any = this.paramsMap.get('Default').data?this.paramsMap.get('Default').data:{};
    let tempSrcParam0Data:any = this.paramsMap.get('Product').data?this.paramsMap.get('Product').data:{};
    Object.assign(tempDstParam0Data,{unit:tempSrcParam0Data['unit']});
    this.paramsMap.set('Default',{data:tempDstParam0Data,context:tempDstParam0Context});
    let tempDstParam1Context:any = this.paramsMap.get('Default').context?this.paramsMap.get('Default').context:{};
    let tempDstParam1Data:any = this.paramsMap.get('Default').data?this.paramsMap.get('Default').data:{};
    let tempSrcParam1Data:any = this.paramsMap.get('Product').data?this.paramsMap.get('Product').data:{};
    Object.assign(tempDstParam1Data,{unitprice:tempSrcParam1Data['unitprice']});
    this.paramsMap.set('Default',{data:tempDstParam1Data,context:tempDstParam1Context});
        if(this.compute10Cond(params)){
            return this.executePREPAREPARAM3(context,params,isloading);   
        }
        if(this.compute11Cond(params)){
            return this.executeDELOGIC1(context,params,isloading);   
        }
        if(this.compute12Cond(params)){
            return this.executeDEACTION3(context,params,isloading);   
        }
    }

    /**
    * 大于100处理
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDEBUGPARAM1(context:any,params:any,isloading:boolean){
        // DEBUGPARAM暂未支持
        console.log("DEBUGPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 重置参数
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeRESETPARAM1(context:any,params:any,isloading:boolean){
        // RESETPARAM暂未支持
        console.log("RESETPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 调试逻辑参数
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDEBUGPARAM4(context:any,params:any,isloading:boolean){
        // DEBUGPARAM暂未支持
        console.log("DEBUGPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 排序数组参数
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeSORTPARAM1(context:any,params:any,isloading:boolean){
        // SORTPARAM暂未支持
        console.log("SORTPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 调试逻辑参数
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDEBUGPARAM5(context:any,params:any,isloading:boolean){
        // DEBUGPARAM暂未支持
        console.log("DEBUGPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 获取订单信息异常
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeTHROWEXCEPTION2(context:any,params:any,isloading:boolean){
        // 异常捕获节点
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 实体行为
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDEACTION3(context:any,params:any,isloading:boolean){
        // 行为处理节点
        let result: any;
        let actionParam:any = this.paramsMap.get('Default');
        const targetService:IBIZOrderDetailService = new IBIZOrderDetailService();
        if (targetService['CountMoney'] && targetService['CountMoney'] instanceof Function) {
            result = await targetService['CountMoney'](actionParam.context,actionParam.data, false);
        }
        if(result && result.status == 200){
            Object.assign(actionParam.data,result.data);
        return this.paramsMap.get(this.defaultParamName).data;
        }
    }

    /**
    * 绑定参数
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeBINDPARAM1(context:any,params:any,isloading:boolean){
        // BINDPARAM暂未支持
        console.log("BINDPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 调试逻辑参数
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDEBUGPARAM3(context:any,params:any,isloading:boolean){
        // DEBUGPARAM暂未支持
        console.log("DEBUGPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 设置orderid
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executePREPAREPARAM3(context:any,params:any,isloading:boolean){
        // 准备参数节点
    let tempDstParam0Context:any = this.paramsMap.get('Order').context?this.paramsMap.get('Order').context:{};
    let tempDstParam0Data:any = this.paramsMap.get('Order').data?this.paramsMap.get('Order').data:{};
    let tempSrcParam0Data:any = this.paramsMap.get('Default').data?this.paramsMap.get('Default').data:{};
    Object.assign(tempDstParam0Context,{ibizorder:tempSrcParam0Data['ibizorderid']});
    Object.assign(tempDstParam0Data,{ibizorderid:tempSrcParam0Data['ibizorderid']});
    this.paramsMap.set('Order',{data:tempDstParam0Data,context:tempDstParam0Context});
    let tempDstParam1Context:any = this.paramsMap.get('Order').context?this.paramsMap.get('Order').context:{};
    let tempDstParam1Data:any = this.paramsMap.get('Order').data?this.paramsMap.get('Order').data:{};
    Object.assign(tempDstParam1Data,{createman:"111"});
    this.paramsMap.set('Order',{data:tempDstParam1Data,context:tempDstParam1Context});
    let tempDstParam2Context:any = this.paramsMap.get('Order').context?this.paramsMap.get('Order').context:{};
    let tempDstParam2Data:any = this.paramsMap.get('Order').data?this.paramsMap.get('Order').data:{};
    this.paramsMap.set('Order',{data:tempDstParam2Data,context:tempDstParam2Context});
        if(this.compute13Cond(params)){
            return this.executeDEACTION2(context,params,isloading);   
        }
    }

    /**
    * 实体数据查询
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDEDATAQUERY1(context:any,params:any,isloading:boolean){
        // DEDATAQUERY暂未支持
        console.log("DEDATAQUERY暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 重新建立参数
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeRENEWPARAM1(context:any,params:any,isloading:boolean){
        // RENEWPARAM暂未支持
        console.log("RENEWPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 附加到数组参数
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeAPPENDPARAM1(context:any,params:any,isloading:boolean){
        // APPENDPARAM暂未支持
        console.log("APPENDPARAM暂未支持");
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 获取产品价格异常
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeThrowexception(context:any,params:any,isloading:boolean){
        // 异常捕获节点
        return this.paramsMap.get(this.defaultParamName).data;
    }


}