import { Verify } from '@/utils/verify/verify';


/**
 * 执行上一步
 * 基于 APP/src/service/%DE_PKGPATH%/%APP_DELOGIC%-logic-base.ts.ftl 生成
 * @export
 * @class PreActionLogicBase
 */
export default class PreActionLogicBase {

    /**
     * 名称
     * 
     * @memberof  PreActionLogicBase
     */
    private name:string ="PreAction";

    /**
     * 唯一标识
     * 
     * @memberof  PreActionLogicBase
     */
    private id:string = "e2c9236d5edf802f0ba1d8b0fa028270";

    /**
     * 默认参数名称
     * 
     * @memberof  PreActionLogicBase
     */
    private defaultParamName:string = "Default";

    /**
     * 参数集合
     * 
     * @memberof  PreActionLogicBase
     */
    private paramsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  PreActionLogicBase.
     * 
     * @param {*} [opts={}]
     * @memberof  PreActionLogicBase
     */
    constructor(opts: any = {}) {
        this.initParams(opts);
    }

    /**
     * 初始化参数集合
     * 
     * @param {*} [opts={}]
     * @memberof  PreActionLogicBase
     */
    public initParams(opts:any){
        this.paramsMap.set('Default',opts);
    }


    /**
     * 计算0节点结果
     * 
     * @param params 传入参数
     */
    public compute0Cond(params:any):boolean{
        return true;
    }

    /**
     * 执行逻辑
     * 
     * @param context 应用上下文
     * @param params 传入参数
     */
    public onExecute(context:any,params:any,isloading:boolean){
        return this.executeBegin(context,params,isloading);
    }


    /**
    * 开始
    * 
    * @param params 传入参数
    */
    private async executeBegin(context:any,params:any,isloading:boolean){
        //开始节点
        if(this.compute0Cond(params)){
            return this.executePrepareparam1(context,params,isloading);   
        }
    }

    /**
    * 准备参数
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executePrepareparam1(context:any,params:any,isloading:boolean){
        // 准备参数节点
    let tempDstParam0Context:any = this.paramsMap.get('Default').context?this.paramsMap.get('Default').context:{};
    let tempDstParam0Data:any = this.paramsMap.get('Default').data?this.paramsMap.get('Default').data:{};
    Object.assign(tempDstParam0Data,{stepstatus:"step1"});
    this.paramsMap.set('Default',{data:tempDstParam0Data,context:tempDstParam0Context});
        return this.paramsMap.get(this.defaultParamName).data;
    }


}