import { MockAdapter } from '../mock-adapter';
const mock = MockAdapter.getInstance();

import Mock from 'mockjs'
// 基于 APP/src/viewconfig/viewconfig.ts.ftl 生成
// 获取studio链接数据
mock.onGet('./assets/json/view-config.json').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status,{
                "ibizuniproductsgridview": {
            "title": "索引选择视图",
            "caption": "索引选择视图",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductSGridView",
            "viewtag": "002aedc17a2bf3187df6bf8d8648283b"
        },
        "ibizcustomerusr1119342189listview": {
            "title": "部件插件",
            "caption": "部件插件",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerUsr1119342189ListView",
            "viewtag": "00D43B4C-170E-4C5D-84A9-C43CB76B3A9F"
        },
        "ibizbooktreeview": {
            "title": "图书树视图（主状态）",
            "caption": "图书",
            "viewtype": "DETREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTreeView",
            "viewtag": "0161dff61fdbb4955ff92c022acc5fb4"
        },
        "ibizsample0001usr2editview": {
            "title": "示例实体01编辑视图",
            "caption": "示例实体01",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001Usr2EditView",
            "viewtag": "016ec9c4418a5753635ec729552a7f2c"
        },
        "ibizhardwareindexpickupdataview": {
            "title": "硬件索引关系选择数据视图",
            "caption": "硬件",
            "viewtype": "DEINDEXPICKUPDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZHardwareIndexPickupDataView",
            "viewtag": "0173689599376f748203557242d223ed"
        },
        "ibizbookinternalfuncgridview": {
            "title": "表格内置功能",
            "caption": "表格内置功能",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKInternalFuncGridView",
            "viewtag": "0284801f3401351c5ec95ae8daf3ca0a"
        },
        "ibizsample0002pickupview": {
            "title": "首页图表数据源数据选择视图",
            "caption": "示例实体02",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0002PickupView",
            "viewtag": "02bfa483b64e3ece7a3c35ecf2cdce68"
        },
        "ibizbookgridexpview": {
            "title": "图书表格导航视图",
            "caption": "图书",
            "viewtype": "DEGRIDEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKGridExpView",
            "viewtag": "04dcaa66b007842529e5ef5e2e341b55"
        },
        "ibizbookgridloadcustomview": {
            "title": "界面逻辑加载与跳转",
            "caption": "界面逻辑加载与跳转",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKGridLoadCustomView",
            "viewtag": "05879876-B0D0-4102-991F-61A0C4608489"
        },
        "ibizbookhaspanelkanbanview": {
            "title": "图书看板视图（嵌入视图面板）",
            "caption": "图书",
            "viewtype": "DEKANBANVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKHasPanelKanBanView",
            "viewtag": "073574696f84425537f344ed6f043e52"
        },
        "ibizcustomerusr2gridview": {
            "title": "客户表格视图",
            "caption": "客户",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerUsr2GridView",
            "viewtag": "07d058a55709a57ff27167c66428acf6"
        },
        "ibizbooktestcldataview": {
            "title": "测试视图布局面板（卡片）",
            "caption": "图书",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTestCLDataView",
            "viewtag": "085AFCE3-1192-4CF2-993A-7A4EB1D55A06"
        },
        "ibizcustomerpickupgridview": {
            "title": "客户选择表格视图",
            "caption": "客户",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerPickupGridView",
            "viewtag": "0870b1a6221a37e2994f515dbe77509c"
        },
        "ibizcustomerpickuptreeview_layout": {
            "title": "客户选择树视图",
            "caption": "客户",
            "viewtype": "DEPICKUPTREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerPickupTreeView_layout",
            "viewtag": "091e4dfadeea5cf542e5e01a758a3b93"
        },
        "ibizappvieweditview": {
            "title": "应用视图编辑视图",
            "caption": "应用视图",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPVIEWEditView",
            "viewtag": "0a96057cbca72b445776fb056be79ea8"
        },
        "ibizorderpickuptreeview": {
            "title": "订单选择树视图",
            "caption": "订单",
            "viewtype": "DEPICKUPTREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderPickupTreeView",
            "viewtag": "0b40a357bf8278ad9907e9338b5752b7"
        },
        "ibizbookusr6gridview_layout": {
            "title": "图书表格视图",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr6GridView_layout",
            "viewtag": "0b688f3a0ebe91bb9415994dbb285f03"
        },
        "ibizorderf10editview": {
            "title": "表单动态显示",
            "caption": "表单动态显示",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF10EditView",
            "viewtag": "0c12587a9c2813dc9cb5768741caaab6"
        },
        "ibizbookusr7gridview": {
            "title": "表格列更新",
            "caption": "表格列更新",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr7GridView",
            "viewtag": "0c1719540d6f515fa021b477e3990dbf"
        },
        "ibizbookinterfunctreeview": {
            "title": "图书树视图（树表格）",
            "caption": "图书",
            "viewtype": "DETREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKInterFuncTreeView",
            "viewtag": "0c4d6d95b65112bc675b7f2b2c7f45d8"
        },
        "ibizorderusr5editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr5EditView",
            "viewtag": "0db1fda1dde267b7b183b823c941cef7"
        },
        "ibizbookdashboardview": {
            "title": "实体数据看板视图",
            "caption": "实体数据看板视图",
            "viewtype": "DEPORTALVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKDashboardView",
            "viewtag": "0df3680d38ec121a94fde0389354a892"
        },
        "ibizbookusr4dataview": {
            "title": "图书数据视图（项布局面板）",
            "caption": "图书",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr4DataView",
            "viewtag": "0e07bf7a2c175c0505a76c75681e7080"
        },
        "ibizuniproducteditview": {
            "title": "统一产品编辑视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductEditView",
            "viewtag": "0f3e6e5a5ba4b40182153ee4f93f3f7e"
        },
        "ibizsample0021wfdynaactionview": {
            "title": "订单工作流动态操作视图",
            "caption": "订单工作流动态操作视图",
            "viewtype": "DEWFDYNAACTIONVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021WFDynaActionView",
            "viewtag": "0f4df2881b94c291b6e268dd172bdb67"
        },
        "ibizbookusr3customview": {
            "title": "图书自定义视图",
            "caption": "图书",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr3CustomView",
            "viewtag": "10945024c5f77c0f1421847bed691ad8"
        },
        "ibizbookeditview4": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW4",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKEditView4",
            "viewtag": "115bb38d6a2e8485eaf69751f3d24fdd"
        },
        "ibizbooktestcltreeview": {
            "title": "测试自定义面板（树视图）",
            "caption": "图书",
            "viewtype": "DETREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTestCLTreeView",
            "viewtag": "121A691B-48F2-40B0-AF2A-4399BD5092F7"
        },
        "ibizsoftwaresuitsgridview": {
            "title": "软件表格视图",
            "caption": "软件",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSoftwareSuitSGridView",
            "viewtag": "12472dbcf055da127ca97964214fb14e"
        },
        "ibizcustomcustomeditview": {
            "title": "自定义实现编辑视图",
            "caption": "自定义实现编辑视图",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomCustomEditView",
            "viewtag": "13350456-D47B-4620-A610-5121595F637A"
        },
        "ibizsample0003f2treeexpview": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003F2TreeExpView",
            "viewtag": "133823e606a9f0e07fb347bce9e3cf34"
        },
        "ibizsample0002gridview": {
            "title": "首页图表数据源表格视图",
            "caption": "示例实体02",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0002GridView",
            "viewtag": "13e9b1f70b319153b54eb3da95b04f2c"
        },
        "microcomponenteditview": {
            "title": "微组件编辑视图",
            "caption": "微组件",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "microComponentEditView",
            "viewtag": "13ef3d4d33b09ee1ec5db7ffe4aba7bd"
        },
        "ibizsample0003f4treeexpview": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003F4TreeExpView",
            "viewtag": "1510a1fb1a34b2c8e29ca40fa83a3992"
        },
        "ibizorderdetailsf1editview": {
            "title": "表单项重置项",
            "caption": "表单项重置项",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSF1EditView",
            "viewtag": "1537c652f07bf274abca85c3ec73476d"
        },
        "ibizorderwizardview": {
            "title": "订单向导视图",
            "caption": "订单",
            "viewtype": "DEWIZARDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderWizardView",
            "viewtag": "161384e39932ab66b348d27376064b32"
        },
        "ibizsample0003pickupgridview": {
            "title": "IBIZSAMPLE0003选择表格视图",
            "caption": "示例实体03",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003PickupGridView",
            "viewtag": "1731c6bed3fe2ba87dfac52048a6a883"
        },
        "ibizsample0002editview": {
            "title": "首页图表数据源编辑视图",
            "caption": "示例实体02",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0002EditView",
            "viewtag": "17902133c0098cf78da9c568de2a27fb"
        },
        "ibizsample0002pickupgridview": {
            "title": "首页图表数据源选择表格视图",
            "caption": "示例实体02",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0002PickupGridView",
            "viewtag": "17f8162ef93b39e3adc3416fe0d651ea"
        },
        "ibizuniproductindexpickupdataview": {
            "title": "统一产品索引关系选择数据视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEINDEXPICKUPDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductIndexPickupDataView",
            "viewtag": "187cd0060ae45193183239145996d682"
        },
        "appindexview2": {
            "title": "菜单右对齐",
            "caption": "菜单右对齐",
            "viewtype": "APPINDEXVIEW",
            "viewmodule": "Sample",
            "viewname": "AppIndexView2",
            "viewtag": "1983061F-8B13-4ADA-8774-C10B7D962A7A"
        },
        "ibizorderseditview2_layout": {
            "title": "实体编辑视图（左右关系）",
            "caption": "实体编辑视图（左右关系）",
            "viewtype": "DEEDITVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView2_layout",
            "viewtag": "1a158d1e7cdd8c8e17b54bfa91846b4c"
        },
        "ibizbookusr2calendarview": {
            "title": "图书日历视图（时间轴）",
            "caption": "图书",
            "viewtype": "DECALENDARVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2CalendarView",
            "viewtag": "1a196625566103f16d230abf2cd9e014"
        },
        "ibizbookusr1110030546customview": {
            "title": "自定义部件界面逻辑测试视图",
            "caption": "自定义部件界面逻辑测试视图",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr1110030546CustomView",
            "viewtag": "1A58B21B-2033-4CC4-B3B8-6AB6BFD2F26A"
        },
        "ibizordersgridview": {
            "title": "实体表格视图",
            "caption": "实体表格视图",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSGridView",
            "viewtag": "1a7578c0b5f8a1107d0fe9c2dc51f314"
        },
        "ibizordersf2editview": {
            "title": "表单项输入提示",
            "caption": "表单项输入提示",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF2EditView",
            "viewtag": "1b7854b9c53e32582b1460c78b9e6a5a"
        },
        "ibizbookformloadcustomview": {
            "title": "界面逻辑加载（表单）",
            "caption": "界面逻辑加载（表单）",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKFormLoadCustomView",
            "viewtag": "1C3D71C7-D5B8-4937-89F7-F822EA1629F4"
        },
        "ibizcustomerusr2editview": {
            "title": "客户编辑视图",
            "caption": "客户",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerUsr2EditView",
            "viewtag": "1d79fd13f3bf2928a00eb37005d138dd"
        },
        "ibizuniproductsgridview_layout": {
            "title": "索引选择视图",
            "caption": "索引选择视图",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductSGridView_layout",
            "viewtag": "1e5f6384a69035a45e28c2552fd485bc"
        },
        "ibizordertypepickupview": {
            "title": "订单类型数据选择视图",
            "caption": "订单类型",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTypePickupView",
            "viewtag": "1e9b0440a2bd0d75165d9d5c19716653"
        },
        "ibizuniproductgridview9": {
            "title": "统一产品表格视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductGridView9",
            "viewtag": "1ec7069b18d0c9b18fb55c839b2e0822"
        },
        "ibizsample0017pickupgridview": {
            "title": "订单选择表格视图",
            "caption": "订单",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017PickupGridView",
            "viewtag": "1f719a245bfffa439fe924c16e205fba"
        },
        "ibizbookusr2listview": {
            "title": "图书列表视图",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2ListView",
            "viewtag": "1f795e078a81b2f7471a82a86b608d99"
        },
        "ibizappeditorlistview": {
            "title": "编辑器列表视图",
            "caption": "编辑器",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPEDITORListView",
            "viewtag": "1fa9c4cc5c8b0171ad37a322a8dcce07"
        },
        "ibizbookusr4treeview": {
            "title": "图书树视图",
            "caption": "图书",
            "viewtype": "DETREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr4TreeView",
            "viewtag": "22299f593480c67108c96ce5202eeb8c"
        },
        "ibizsample0003sf3editview": {
            "title": "示例实体03编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SF3EditView",
            "viewtag": "2270741ef4557c53f3c72ac4f394549d"
        },
        "ibizorderf9editview": {
            "title": "表单动态空输入",
            "caption": "表单动态空输入",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF9EditView",
            "viewtag": "231651109e4b11477dcf988577d43c3e"
        },
        "ibizuniproductindexpickupview": {
            "title": "统一产品数据选择视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductIndexPickupView",
            "viewtag": "2358ff370509a1b833cb5023f0ec54fb"
        },
        "ibizbookusr10editview": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr10EditView",
            "viewtag": "237aa26a288713e29a1e733394564d3a"
        },
        "ibizsample0001usr2gridview": {
            "title": "示例实体01表格视图",
            "caption": "示例实体01",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001Usr2GridView",
            "viewtag": "2459226170dff1d80437e288da435308"
        },
        "ibizorderselecteditview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSelectEditView",
            "viewtag": "2485d4d1d49a68f8303756d6659365dc"
        },
        "ibizorderdetailsmeditview9": {
            "title": "订单明细多表单编辑视图",
            "caption": "订单明细",
            "viewtype": "DEMEDITVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSMEditView9",
            "viewtag": "24cc092258fda501d4c2051df68a2dce"
        },
        "ibizorderdataviewexpview": {
            "title": "实体卡片视图导航视图",
            "caption": "实体卡片视图导航视图",
            "viewtype": "DEDATAVIEWEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDataViewExpView",
            "viewtag": "24eda604d53b477c9c8446aad6d3eb61"
        },
        "ibizbookusr2editview_layout": {
            "title": "实体数据选择视图",
            "caption": "实体数据选择视图",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2EditView_layout",
            "viewtag": "250e5b8897b031e2ab4124c51a7efadd"
        },
        "ibizsample0021wfdynaexpgridview": {
            "title": " 实体工作流动态导航表格视图",
            "caption": " 实体工作流动态导航表格视图",
            "viewtype": "DEWFDYNAEXPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021WFDynaExpGridView",
            "viewtag": "270a2cdf7072febc156805c6c967c010"
        },
        "ibizorderdetailgridview": {
            "title": "订单明细表格视图",
            "caption": "订单明细",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailGridView",
            "viewtag": "285cdedb2cfbebbb1ba8e5659e49bc7f"
        },
        "ibizsample0013pickupgridview": {
            "title": "订单明细选择表格视图",
            "caption": "订单明细",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0013PickupGridView",
            "viewtag": "2aa0a3dead1ff67aae5fd384640c3241"
        },
        "ibizcustomerusr2pickupview": {
            "title": "客户实体数据选择视图(树视图)",
            "caption": "客户",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerUsr2PickupView",
            "viewtag": "2dd50b1b88cf8062b625ee8b0b4fa9d7"
        },
        "ibizorderpluginexgridview": {
            "title": "表格插件示例视图",
            "caption": "表格插件示例视图",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderPluginExGridView",
            "viewtag": "2E76797A-3404-4235-AAC0-1ADBB1930CC7"
        },
        "ibizhardwaregridview9": {
            "title": "硬件表格视图",
            "caption": "硬件",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZHardwareGridView9",
            "viewtag": "2e7cbc7793bdd49ea744b56e6e14571c"
        },
        "ibizappctrleditview": {
            "title": "应用部件编辑视图",
            "caption": "应用部件",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPCTRLEditView",
            "viewtag": "3168bd2ca4622a43b5035fe50f012108"
        },
        "ibizcustomerusr2mpickupview": {
            "title": "客户实体数据多项选择视图(树视图)",
            "caption": "客户",
            "viewtype": "DEMPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerUsr2MPickupView",
            "viewtag": "3177e05ee25b4c215c2ce87547fcdc8c"
        },
        "ibizbookusr2pickupview": {
            "title": "图书数据选择视图",
            "caption": "图书",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2PickupView",
            "viewtag": "3192b641fa31cbe04d8a901f0992d77d"
        },
        "ibizbooktabexpview": {
            "title": "图书分页导航视图",
            "caption": "图书",
            "viewtype": "DETABEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTabExpView",
            "viewtag": "32b0dd446250056ce414ba340dda6990"
        },
        "ibizordersf15gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF15GridView",
            "viewtag": "332088f58c9c17a7f6d3eb281de6bd79"
        },
        "ibizbookusr2optionview": {
            "title": "图书选项操作视图",
            "caption": "图书",
            "viewtype": "DEOPTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2OptionView",
            "viewtag": "33e9f40b8b9255757f792baf79a8e309"
        },
        "ibizbookvaluerulesgridview": {
            "title": "表格值规则",
            "caption": "表格值规则",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKValueRulesGridView",
            "viewtag": "3631bff49cffd36899f9fc96dcd6486e"
        },
        "ibizbookusr2meditview9": {
            "title": "实体多表单编辑视图",
            "caption": "实体多表单编辑视图",
            "viewtype": "DEMEDITVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2MEditView9",
            "viewtag": "36bc83bf45e2fbb5a963ad751cb9a13f"
        },
        "ibizbookinterfunceditview": {
            "title": "图书编辑视图（内置功能）",
            "caption": "编辑表单内置功能",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKInterFuncEditView",
            "viewtag": "37e96c2a2e91cfbb1c2b076eb854a18e"
        },
        "ibizorderdetailusr2gridview9": {
            "title": "临时模式",
            "caption": "临时模式",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailUsr2GridView9",
            "viewtag": "37f61ee1bcce3ee0bff093eed18e1e37"
        },
        "ibizordertestcustomlayoutpanelgridexpview": {
            "title": "订单表格导航视图（测试布局面板）",
            "caption": "（测试布局面板）",
            "viewtype": "DEGRIDEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTestCustomLayoutPanelGridExpView",
            "viewtag": "38b0b453d423e0772822db6be4f02505"
        },
        "ibizorderusr1215996830editview": {
            "title": "左侧抽屉弹出",
            "caption": "左侧抽屉弹出",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr1215996830EditView",
            "viewtag": "3A08D861-4F5A-4CBC-984C-2E7C3CB9A692"
        },
        "ibizorderlistview": {
            "title": "订单列表视图",
            "caption": "订单",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderListView",
            "viewtag": "3ae764f796e8339bcf1a7cab873b7e89"
        },
        "ibizorderdetailf7editview": {
            "title": "订单明细编辑视图",
            "caption": "订单明细",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailF7EditView",
            "viewtag": "3c5fdd230472c54138bf90530dd1ab4a"
        },
        "appportalview2": {
            "title": "门户部件",
            "caption": "门户部件",
            "viewtype": "APPPORTALVIEW",
            "viewmodule": "Sample",
            "viewname": "AppPortalView2",
            "viewtag": "3d5803767cb3743ed92096aff4ca2b72"
        },
        "ibizbookusr3treeview": {
            "title": "图书树视图",
            "caption": "图书",
            "viewtype": "DETREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr3TreeView",
            "viewtag": "406f27bfbbbe3bb0f15d8d77ca63e24c"
        },
        "ibizbookusreditview_plugin": {
            "title": "编辑视图插件测试-底部工具栏",
            "caption": "编辑视图插件测试-底部工具栏",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrEditView_plugin",
            "viewtag": "427E25F6-DBD4-451B-B20E-87929E061C95"
        },
        "ibizsample0003gridview": {
            "title": "IBIZSAMPLE0003表格视图",
            "caption": "示例实体03",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003GridView",
            "viewtag": "42beaffcf3633c8717a81f3cf559b8ae"
        },
        "ibizbookusr7editview": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr7EditView",
            "viewtag": "43583fdf9c4b70f8460d35d5904ca2f4"
        },
        "ibizhardwareindexpickupview": {
            "title": "硬件数据选择视图",
            "caption": "硬件",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZHardwareIndexPickupView",
            "viewtag": "44aee99c5ccda7a302e6d2de6d7403e0"
        },
        "ibizsample0003sf1editview": {
            "title": "示例实体03编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SF1EditView",
            "viewtag": "44cd85884a5a6ca4cb039ff3e7427f75"
        },
        "ibizsample0017formpickupview": {
            "title": "订单数据选择视图",
            "caption": "订单",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017FormPickupView",
            "viewtag": "45443caac5696a6ba3fea5567428f705"
        },
        "ibizsample0017f10editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017F10EditView",
            "viewtag": "45af410b67ef11f9a96a758d7d33de5b"
        },
        "ibizbookusr4calendarview": {
            "title": "图书日历视图（自定义插件）",
            "caption": "图书",
            "viewtype": "DECALENDARVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr4CalendarView",
            "viewtag": "45dde25611c271bbc1a9004f5512d2a3"
        },
        "portal": {
            "title": "控制台",
            "caption": "",
            "viewtype": "APPPORTALVIEW",
            "viewmodule": "Sample",
            "viewname": "portal",
            "viewtag": "46515af8a80cf224ccfbb17497154ea9"
        },
        "ibizorderdataviewexpview_layout": {
            "title": "实体卡片视图导航视图",
            "caption": "实体卡片视图导航视图",
            "viewtype": "DEDATAVIEWEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDataViewExpView_layout",
            "viewtag": "466f7d742867f2fda5380dbd3eb4cd08"
        },
        "ibizordertypeusr2gridview": {
            "title": "订单类型表格视图",
            "caption": "订单类型",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTypeUsr2GridView",
            "viewtag": "46fb2697c30e8f88aa51e32dd4c8afb5"
        },
        "ibizappeditorgridview": {
            "title": "编辑器表格视图",
            "caption": "编辑器",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPEDITORGridView",
            "viewtag": "472768f0007b681be5dd3fd3fd030f82"
        },
        "ibizorderwfactionview": {
            "title": "订单工作流操作视图",
            "caption": "订单",
            "viewtype": "DEWFACTIONVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderWFActionView",
            "viewtag": "484749cb43a4564c74763781b756e00e"
        },
        "ibizsample0021usr1114433946wfdynaeditview": {
            "title": "实体工作流动态编辑视图",
            "caption": "订单",
            "viewtype": "DEWFDYNAEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021Usr1114433946WFDynaEditView",
            "viewtag": "49E66C2F-237A-415A-B7B9-6B90DF532A83"
        },
        "ibizsample0003stabexpview_layout": {
            "title": "实体分页导航视图",
            "caption": "示例实体03",
            "viewtype": "DETABEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003STabExpView_layout",
            "viewtag": "4a0d51e3bca39ffa8dc989e13a1a613f"
        },
        "ibizsample0003f3treeexpview": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003F3TreeExpView",
            "viewtag": "4a775e162843247ba343984bd5e7d634"
        },
        "ibizordersf4gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF4GridView",
            "viewtag": "4b4b6bbaee54107c3312bf71ec82cdee"
        },
        "ibizorderuiactionplugingridview": {
            "title": "界面行为插件示例",
            "caption": "界面行为插件示例",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUIActionPluginGridView",
            "viewtag": "4B6D0001-7538-4FF8-9F0A-39821288D625"
        },
        "ibizordersgridview2": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSGridView2",
            "viewtag": "4cfe10a5520e3df88ed98efdb06264a3"
        },
        "ibizbookeditview2": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKEditView2",
            "viewtag": "4d8ded182fb6ac87e6f27f3e0e7b3a4a"
        },
        "ibiztaskusr2editview": {
            "title": "任务编辑视图(临时模式)",
            "caption": "临时模式",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZTASKUsr2EditView",
            "viewtag": "4de43dfcdded2a8e28f2e32a44fa1ebf"
        },
        "ibizordersf5gridview": {
            "title": "订单表格视图",
            "caption": "前端界面行为",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF5GridView",
            "viewtag": "4e142abbc82a33d405dd609368612421"
        },
        "ibizsample0021wfdynaeditview": {
            "title": "订单工作流编辑视图",
            "caption": "订单",
            "viewtype": "DEWFDYNAEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021WFDynaEditView",
            "viewtag": "4ebdd8b29f5d25e3fe13019f30c921f2"
        },
        "ibiztaskteamgridview9": {
            "title": "任务团队表格视图（临时模式）",
            "caption": "临时模式",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZTASKTEAMGridView9",
            "viewtag": "4f575e36bc2dac21e066154360f729d3"
        },
        "ibizsample0021sendbackwfdynaactionview": {
            "title": "实体工作流动态操作视图（回退）",
            "caption": "实体工作流动态操作视图（回退）",
            "viewtype": "DEWFDYNAACTIONVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021SENDBACKWFDynaActionView",
            "viewtag": "4FB815F9-B6D8-4F8F-8A0A-85E8BEDA0927"
        },
        "ibizorderusr2gridview": {
            "title": "订单表格视图(测试视图布局面板)",
            "caption": "(测试视图布局面板)",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr2GridView",
            "viewtag": "504c018faa34b2d0fce7c4c56569e02e"
        },
        "ibizbookusr6calendarview": {
            "title": "图书日历视图",
            "caption": "图书",
            "viewtype": "DECALENDARVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr6CalendarView",
            "viewtag": "508e2461c49ad9175533bf925ea0267e"
        },
        "ibizsample0003sf5editview": {
            "title": "示例实体03编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SF5EditView",
            "viewtag": "512b0c2469a4b7254103820349923919"
        },
        "ibizbookwizardiwithstateview": {
            "title": "状态属性",
            "caption": "状态属性",
            "viewtype": "DEWIZARDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKWizardIWithStateView",
            "viewtag": "517580eb2dc02c481b306635c52fb1a3"
        },
        "ibizbookusr4gridview": {
            "title": "表格当前页本地聚合",
            "caption": "表格当前页本地聚合",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr4GridView",
            "viewtag": "51c9c90b36b67d3ae19f5e456d320667"
        },
        "ibizorderseditview2": {
            "title": "实体编辑视图（左右关系）",
            "caption": "实体编辑视图（左右关系）",
            "viewtype": "DEEDITVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView2",
            "viewtag": "52aa6409ffc18f950f8a44c5aa025d5e"
        },
        "ibizorderdetailf6editview": {
            "title": "订单明细编辑视图",
            "caption": "订单明细",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailF6EditView",
            "viewtag": "53263c27fef88634bd8d4149dc35fb46"
        },
        "ibizorderseditview4": {
            "title": "实体编辑视图（上下关系）",
            "caption": "实体编辑视图（上下关系）",
            "viewtype": "DEEDITVIEW4",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView4",
            "viewtag": "535287f8b07f35be0e294617f6682962"
        },
        "ibizsample0021usr1114865995wfdynaeditview3": {
            "title": "实体工作流动态视图（分页关系）",
            "caption": "实体工作流动态视图（分页关系）",
            "viewtype": "DEWFDYNAEDITVIEW3",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021Usr1114865995WFDynaEditView3",
            "viewtag": "53757392-B5A2-4E4C-84F6-99DCC4C490AB"
        },
        "ibizsample0003spickuptreeview": {
            "title": "IBIZSAMPLE0003选择树视图",
            "caption": "示例实体03",
            "viewtype": "DEPICKUPTREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SPickupTreeView",
            "viewtag": "543f5f6115605ade1395be25b53be76c"
        },
        "ibizordertestcltreeexpview": {
            "title": "测试布局面板（树导航）",
            "caption": "测试布局面板（树导航）",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTestCLTreeExpView",
            "viewtag": "5515A024-BD26-40B2-A13E-932A0DF3E40A"
        },
        "ibizcustomermpickupview_layout": {
            "title": "客户数据多项选择视图",
            "caption": "客户",
            "viewtype": "DEMPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerMPickupView_layout",
            "viewtag": "55c95540dba6d9b43562beb6ce69d10d"
        },
        "ibizordersf3gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF3GridView",
            "viewtag": "55f7fd4d93f5f52c0d0ad59cc61ca1e6"
        },
        "ibizorderstate30editview2": {
            "title": "订单编辑视图(已通过)",
            "caption": "订单",
            "viewtype": "DEEDITVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderState30EditView2",
            "viewtag": "56738595155756fd86c36e20af24f056"
        },
        "ibizbookusr6gridview": {
            "title": "图书表格视图",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr6GridView",
            "viewtag": "56b214615acdba5ae643d4d951cc8c74"
        },
        "ibizbookusr5calendarview": {
            "title": "图书日历视图（主状态）",
            "caption": "图书",
            "viewtype": "DECALENDARVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr5CalendarView",
            "viewtag": "56b686ce7f9c14a18c14ce015f6a9475"
        },
        "index": {
            "title": "",
            "caption": "R7 Vue示例",
            "viewtype": "APPINDEXVIEW",
            "viewmodule": "Sample",
            "viewname": "index",
            "viewtag": "56f1a8b473554af1f58a4cb286fcbced"
        },
        "ibizcustomereditview": {
            "title": "客户编辑视图",
            "caption": "客户",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerEditView",
            "viewtag": "5833c694426f36bca2533ea775f77a72"
        },
        "ibizbookeditview": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKEditView",
            "viewtag": "58e37ccddda10feedac7c809d5cee02a"
        },
        "ibizappextendeditorgridview": {
            "title": "扩展编辑器表格视图",
            "caption": "扩展编辑器",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPEXTENDEDITORGridView",
            "viewtag": "598930e96d33a7042ae34b1e10145fd0"
        },
        "ibizorderf8editview": {
            "title": "表单动态启用",
            "caption": "表单动态启用",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF8EditView",
            "viewtag": "5a7f64501efa880864c3fa2dd470afd4"
        },
        "ibizorderdetailtempmodegridview": {
            "title": "订单明细实体表格视图(临时模式)",
            "caption": "订单明细实体表格视图(临时模式)",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailTempModeGridView",
            "viewtag": "5adf5dde3ad3e8acf640f10502181661"
        },
        "ibizorderseditview3_layout": {
            "title": "实体编辑视图（分页关系）",
            "caption": "实体编辑视图（分页关系）",
            "viewtype": "DEEDITVIEW3",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView3_layout",
            "viewtag": "5b7402fd99632895f9f6d32d6477cb20"
        },
        "ibizbookinterfunckanbanview_layout": {
            "title": "实体看板视图（内置功能）",
            "caption": "实体看板视图（内置功能）",
            "viewtype": "DEKANBANVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKInterFuncKanBanView_layout",
            "viewtag": "5d5c3fd4426aec2662f6470fba1e564c"
        },
        "ibizordersf20gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF20GridView",
            "viewtag": "5e8bc82666968fa3ccaa22e2285ef375"
        },
        "ibizorderusr2chartview": {
            "title": "实体图表视图（k线图）",
            "caption": "实体图表视图（k线图）",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr2ChartView",
            "viewtag": "61178fd42446ff34ea3263088ac2a3f8"
        },
        "ibizbookusrgridview_colplugin": {
            "title": "红色表格列",
            "caption": "红色表格列",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrGridView_colPlugin",
            "viewtag": "611B670D-30A4-44D8-A0F7-DD1266265CD6"
        },
        "ibizbookusr3calendarview": {
            "title": "图书日历视图（项布局面板）",
            "caption": "图书",
            "viewtype": "DECALENDARVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr3CalendarView",
            "viewtag": "619a134b7e83077c3030001ee8545ddb"
        },
        "ibizsample0001usr3editview": {
            "title": "编辑器插件示例",
            "caption": "编辑器插件示例",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001Usr3EditView",
            "viewtag": "6230296bda88a91a67631daac946281b"
        },
        "ibizorderdetailseditview9": {
            "title": "订单明细编辑视图",
            "caption": "订单明细",
            "viewtype": "DEEDITVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSEditView9",
            "viewtag": "62a222b28b730c0645374e11b823d86a"
        },
        "ibizordergridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderGridView",
            "viewtag": "62c3c7af94d8965876dd51481e83411c"
        },
        "ibizorderwfdynaactionview": {
            "title": "订单工作流操作视图",
            "caption": "订单工作流操作视图",
            "viewtype": "DEWFDYNAACTIONVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderWFDynaActionView",
            "viewtag": "63d49921f3254583de10d22349b7105d"
        },
        "ibizorderdetailusr2editview": {
            "title": "订单明细编辑视图",
            "caption": "订单明细",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailUsr2EditView",
            "viewtag": "640d266e27559db23f3a8e298a827be7"
        },
        "ibizbookoptionview": {
            "title": "实体选项操作视图",
            "caption": "实体选项操作视图",
            "viewtype": "DEOPTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKOptionView",
            "viewtag": "6491f37928e0613f1fbaf1e60f12b892"
        },
        "ibizbooktreegridexview": {
            "title": "图书树表格视图",
            "caption": "图书",
            "viewtype": "DETREEGRIDEXVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTreeGridExView",
            "viewtag": "66b0b9f889ad1fad28a0a81a3339e179"
        },
        "ibizsample0003spickupview2": {
            "title": "IBIZSAMPLE0003数据选择视图",
            "caption": "示例实体03",
            "viewtype": "DEPICKUPVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SPickupView2",
            "viewtag": "66d5677ff4c223b5d69c9603303251ac"
        },
        "ibizbookroweditgridview": {
            "title": "表格行编辑",
            "caption": "表格行编辑",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKRowEditGridView",
            "viewtag": "66ec326d0b2e789e37fdabdb41353db2"
        },
        "ibizbookavueeditview": {
            "title": "avue组件测试",
            "caption": "avue组件测试",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKavueEditView",
            "viewtag": "67388CFC-3242-4FDE-9D54-59DA10828453"
        },
        "ibizhardwaresgridview": {
            "title": "硬件表格视图",
            "caption": "硬件",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZHardwareSGridView",
            "viewtag": "67bec3af5acc933690bcfc09b00717c4"
        },
        "ibizorderzdytpgridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderZDYTPGridView",
            "viewtag": "67d867dcc24f4572addb24311efd8516"
        },
        "ibizcustomer_intfmpickupview": {
            "title": "客户数据多项选择视图",
            "caption": "客户",
            "viewtype": "DEMPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomer_INTFMPickupView",
            "viewtag": "681631239002f25ab59d3f72230e6ce5"
        },
        "ibizbookoptionview_layout": {
            "title": "实体选项操作视图",
            "caption": "实体选项操作视图",
            "viewtype": "DEOPTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKOptionView_layout",
            "viewtag": "685e4c22b23e1ab3b994e66c0fb26e0d"
        },
        "ibizsample0001pickupgridview": {
            "title": "IBIZSAMPLE0001选择表格视图",
            "caption": "示例实体01",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001PickupGridView",
            "viewtag": "68c6b70c0c39384ef886c5533121be1f"
        },
        "ibizcustomerpickuptreeview": {
            "title": "客户选择树视图",
            "caption": "客户",
            "viewtype": "DEPICKUPTREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerPickupTreeView",
            "viewtag": "6a079bac1a6eeb580654cd04e6b1a8b8"
        },
        "ibizorderctrlpluginexgridview": {
            "title": "部件插件示例",
            "caption": "部件插件示例",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderCtrlPluginExGridView",
            "viewtag": "6A0A394B-1B07-4CCE-8DBE-4A571FF09D8F"
        },
        "ibizordereditview_info": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderEditView_info",
            "viewtag": "6a7585c77c89b5555a1ca62496145c4a"
        },
        "ibizorderwfstartview": {
            "title": "订单工作流启动视图",
            "caption": "订单",
            "viewtype": "DEWFSTARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderWFStartView",
            "viewtag": "6bc6e690dc5abfc6d89703e4459c785c"
        },
        "ibizorderpiechartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderPieChartView",
            "viewtag": "6c6c31f0f607d0dec1ddaec0326cf430"
        },
        "ibizbookinterfunceditview_layout": {
            "title": "图书编辑视图（内置功能）",
            "caption": "编辑表单内置功能",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKInterFuncEditView_layout",
            "viewtag": "6c9e2f980d5916949d3b16944f887a4b"
        },
        "ibizappeditoreditview": {
            "title": "编辑器编辑视图",
            "caption": "编辑器",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPEDITOREditView",
            "viewtag": "6d3a1e5d74674f7d9ba445e4708216e0"
        },
        "ibizsample0003f1treeexpview": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003F1TreeExpView",
            "viewtag": "6dcde5bda8f3535412226799201cdc48"
        },
        "ibizordercalendarexpview": {
            "title": "实体日历导航视图",
            "caption": "实体日历导航视图",
            "viewtype": "DECALENDAREXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderCalendarExpView",
            "viewtag": "6e838643ecb37eab99428cd3fc5ce15a"
        },
        "ibizcpueditview": {
            "title": "处理器编辑视图",
            "caption": "处理器",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCPUEditView",
            "viewtag": "6ee8090740eb13aec318a38049339d24"
        },
        "ibizordertreegridexview_layout": {
            "title": "实体树表格视图（增强）",
            "caption": "实体树表格视图（增强）",
            "viewtype": "DETREEGRIDEXVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTreeGridExView_layout",
            "viewtag": "6f84ab18fce970554e2ea9ea54aa6d4b"
        },
        "ibizordersf4editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF4EditView",
            "viewtag": "6fc6218fc86e96de517098930877b4e1"
        },
        "ibizorderbarchartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderBarChartView",
            "viewtag": "7076a8f4eba59f17d7da3104b932a262"
        },
        "ibizsample0001gridview": {
            "title": "IBIZSAMPLE0001表格视图",
            "caption": "示例实体01",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001GridView",
            "viewtag": "719ab46aafcdcdde5e1100c95ab30c44"
        },
        "ibizsample0001sf2editview": {
            "title": "基础表单项",
            "caption": "基础表单项",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001SF2EditView",
            "viewtag": "719cc3351f6eb6a08535ae8e2fecd70d"
        },
        "ibizsample0003streeexpview": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003STreeExpView",
            "viewtag": "71db02479f40b863aec2ef84dcf2fd6b"
        },
        "ibizorderviewpluginexgridview": {
            "title": "表格视图插件示例(视图样式)",
            "caption": "表格视图插件示例(视图样式)",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderViewPluginExGridView",
            "viewtag": "730EF6B2-038F-4AF2-86DF-E8455B0CBE75"
        },
        "ibizbooktestclcalendarview": {
            "title": "测试日历视图布局面板",
            "caption": "图书",
            "viewtype": "DECALENDARVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTestCLCalendarView",
            "viewtag": "763A9DA0-DC92-49C9-85B7-647A36C019C9"
        },
        "ibizorderdetaileditview": {
            "title": "订单明细编辑视图",
            "caption": "订单明细",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailEditView",
            "viewtag": "77142fc6e2a600bdc4d8ad6c4bfa18cd"
        },
        "ibizbookusreditview_ctrlplugin": {
            "title": "表单改iframe",
            "caption": "表单改iframe",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrEditView_ctrlPlugin",
            "viewtag": "793FE7EC-5E69-4D5E-85A0-23ED5F868084"
        },
        "ibizuniproductredirectview": {
            "title": "统一产品数据重定向视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEREDIRECTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductRedirectView",
            "viewtag": "79abf62d7cac6f35c896f412b124956f"
        },
        "ibizbooktestcllistview": {
            "title": "测试视图布局面板",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTestCLListView",
            "viewtag": "79C13556-8423-4886-ADB3-6FF73C1E97F1"
        },
        "ibizorderdetailchartview": {
            "title": "订单明细图表视图",
            "caption": "订单明细",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailChartView",
            "viewtag": "79ea95c2d49aa15fc83fdbb78227e1f1"
        },
        "ibizorderdetailsf2editview": {
            "title": "表单项更新",
            "caption": "表单项更新",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSF2EditView",
            "viewtag": "7ccb985d6fc6a6795502a2ba742f95b5"
        },
        "ibizcustomermediatesteditview": {
            "title": "客户编辑视图",
            "caption": "自定义布局表单多媒体测试",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerMediaTestEditView",
            "viewtag": "7ce3aaf69c0b882631428087b7db6464"
        },
        "ibizsample0003stabexpview": {
            "title": "实体分页导航视图",
            "caption": "示例实体03",
            "viewtype": "DETABEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003STabExpView",
            "viewtag": "7d8f3c4529fab9a97c562a1d9d9b9a85"
        },
        "ibizsample0021addstepafterwfdynaactionview": {
            "title": " 实体工作流动态操作视图(后加签)",
            "caption": " 实体工作流动态操作视图(后加签)",
            "viewtype": "DEWFDYNAACTIONVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021ADDSTEPAFTERWFDynaActionView",
            "viewtag": "7E6C0347-211B-4C4E-9397-E098253465A0"
        },
        "ibizordereditview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderEditView",
            "viewtag": "7f46cd67bcfbeac794fcc5c91d8bcceb"
        },
        "ibizorderusr3editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr3EditView",
            "viewtag": "8006b416668edc8c6ec086b5defef05c"
        },
        "ibizsample0017f20editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017F20EditView",
            "viewtag": "830bc43f8ed42c4fafb668b3d76605ad"
        },
        "ibizorderganttview_layout": {
            "title": "实体甘特视图",
            "caption": "实体甘特视图",
            "viewtype": "DEGANTTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderGanttView_layout",
            "viewtag": "831cfd00f6b5438f20d2136a68eede3c"
        },
        "ibizorderlinechartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderLineChartView",
            "viewtag": "8441555b835b409a948145aca501cb85"
        },
        "ibizorderdetailf6gridview": {
            "title": "订单明细表格视图",
            "caption": "订单明细",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailF6GridView",
            "viewtag": "85b4e6bf439cc3ee35f311d48b9cc8cf"
        },
        "ibizsample0017formpickupdataview": {
            "title": "订单表单选择数据视图",
            "caption": "订单",
            "viewtype": "DEFORMPICKUPDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017FormPickupDataView",
            "viewtag": "85b529630528468799b3e6551c92a56d"
        },
        "ibizcustomerusr2mpickupview_layout": {
            "title": "客户实体数据多项选择视图(树视图)",
            "caption": "客户",
            "viewtype": "DEMPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerUsr2MPickupView_layout",
            "viewtag": "85c21f769411264bf14f990433fc76ed"
        },
        "ibizbookusr2meditview9_layout": {
            "title": "实体多表单编辑视图",
            "caption": "实体多表单编辑视图",
            "viewtype": "DEMEDITVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2MEditView9_layout",
            "viewtag": "876c361caba385fee259f7a7359de8e3"
        },
        "ibizbookusrtreeview_plugin": {
            "title": "右对齐树视图",
            "caption": "右对齐树视图",
            "viewtype": "DETREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrTreeView_plugin",
            "viewtag": "8779C32C-B962-4AB7-9B90-E3181B16E4E7"
        },
        "ibizbookusr7listview_listplugin": {
            "title": "图书列表视图",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr7ListView_listPlugin",
            "viewtag": "87ee895b3ae9461006598f7943e34712"
        },
        "ibizorderseditview4_layout": {
            "title": "实体编辑视图（上下关系）",
            "caption": "实体编辑视图（上下关系）",
            "viewtype": "DEEDITVIEW4",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView4_layout",
            "viewtag": "880efe9c98faa665c18ad955496112bf"
        },
        "ibizsoftwaresuiteditview": {
            "title": "软件编辑视图",
            "caption": "软件",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSoftwareSuitEditView",
            "viewtag": "88ca61cdf39cd0f97cf3863e9a6974b3"
        },
        "ibizcustomerusr3editview": {
            "title": "客户编辑视图",
            "caption": "按钮测试编辑视图",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerUsr3EditView",
            "viewtag": "89f50fe0180852e47ffbb486cdfaf305"
        },
        "ibizordercalendarexpview_layout": {
            "title": "实体日历导航视图",
            "caption": "实体日历导航视图",
            "viewtype": "DECALENDAREXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderCalendarExpView_layout",
            "viewtag": "8a29ee094e2f26c928d26ef24d29401f"
        },
        "ibizorderproivateplugingridview": {
            "title": "透视表插件示例",
            "caption": "透视表插件示例",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderProivatePluginGridView",
            "viewtag": "8A41D051-1CDD-4050-9B28-822A20EA0D40"
        },
        "ibizordertypeeditview": {
            "title": "订单类型编辑视图",
            "caption": "订单类型",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTypeEditView",
            "viewtag": "8aea047edee2521efed5745419d63553"
        },
        "ibizcustomerpickupview_layout": {
            "title": "客户数据选择视图",
            "caption": "客户",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerPickupView_layout",
            "viewtag": "8bb68e0800e34b41e92a18ffcf1f7e9f"
        },
        "ibizsample0001sf6editview": {
            "title": "扩展编辑器",
            "caption": "扩展编辑器",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001SF6EditView",
            "viewtag": "8c29a026990571a81823c5d28a7a65be"
        },
        "ibizbookusr3editview": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr3EditView",
            "viewtag": "8c6aee8340f4f2387a0a79e2fee40395"
        },
        "ibizbookgroupbycodelistkanbanview": {
            "title": "图书看板视图（代码表分组）",
            "caption": "图书",
            "viewtype": "DEKANBANVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKGroupByCodelistKanBanView",
            "viewtag": "8ca31cc35cee7ab74327dadd1dc7915e"
        },
        "ibizorderusr2editview": {
            "title": "编辑表单更新默认值",
            "caption": "编辑表单更新默认值",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr2EditView",
            "viewtag": "8cd3518b09373c8e68a33b07c8b13f24"
        },
        "ibizsample0021usr1116491232wfdynastartview": {
            "title": " 实体工作流动态启动视图",
            "caption": " 实体工作流动态启动视图",
            "viewtype": "DEWFDYNASTARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021Usr1116491232WFDynaStartView",
            "viewtag": "8F01A331-F098-4D05-8583-B6DA5574B43C"
        },
        "ibizorderdetaillistview": {
            "title": "订单明细列表视图",
            "caption": "订单明细",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailListView",
            "viewtag": "8f04b48c970ed3c24154be374d6a023f"
        },
        "ibizbookusr6listview": {
            "title": "图书列表视图",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr6ListView",
            "viewtag": "8f0dfc041422a40f4038eaf24f34a2a0"
        },
        "ibizsample0018gridview": {
            "title": "示例实体04表格视图",
            "caption": "示例实体18",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0018GridView",
            "viewtag": "8f5b91d3cdee485d7b826249fed986da"
        },
        "ibizbookexportandimportgridview": {
            "title": "图书表格视图(数据导入导出)",
            "caption": "数据导入导出",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKExportAndImportGridView",
            "viewtag": "918f62b79e5333024e3b8e122a36a021"
        },
        "ibizordergridview9": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderGridView9",
            "viewtag": "91bbbdfe28764098844c216c826756f4"
        },
        "ibizbookautogrouplistview": {
            "title": "图书列表视图（自动分组）",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKAutoGroupListView",
            "viewtag": "928a942475ba1a858fcf2877aa88fdfb"
        },
        "ibizappviewgridview": {
            "title": "应用视图表格视图",
            "caption": "应用视图",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPVIEWGridView",
            "viewtag": "94f14d66f3261878157fb55b65df50c7"
        },
        "ibizbookusr3listview": {
            "title": "图书列表视图",
            "caption": "列表主状态",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr3ListView",
            "viewtag": "9572c5a710d8b9ab714283a1ede5246a"
        },
        "ibizordersf6gridview": {
            "title": "订单表格视图",
            "caption": "后台界面行为",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF6GridView",
            "viewtag": "9667884b794c6475b8b2473b3986ec26"
        },
        "ibizbookmeditview9": {
            "title": "图书多表单编辑视图（多表单）",
            "caption": "图书",
            "viewtype": "DEMEDITVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKMEditView9",
            "viewtag": "976f539a818edcebd5be476bf86dd219"
        },
        "ibizbookusr2treeview": {
            "title": "实体树视图",
            "caption": "实体树视图",
            "viewtype": "DETREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2TreeView",
            "viewtag": "979100eb38d3859933d5e0b2c5931d00"
        },
        "ibizbookredirectview": {
            "title": "图书数据重定向视图",
            "caption": "图书",
            "viewtype": "DEREDIRECTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKRedirectView",
            "viewtag": "9826dd82f687825c543cc0598615dd5b"
        },
        "ibizuniproductpickupview": {
            "title": "统一产品数据选择视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductPickupView",
            "viewtag": "993e4b7a074b1585f383365fff297164"
        },
        "ibizorderradarchartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderRadarChartView",
            "viewtag": "9b26cac7654b87c53116eabebece20a1"
        },
        "ibizappctrllistview": {
            "title": "应用部件列表视图",
            "caption": "应用部件",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPCTRLListView",
            "viewtag": "9c022a86decf341d5f8939fff3cb6c60"
        },
        "ibizsample0013pickupview": {
            "title": "订单明细数据选择视图",
            "caption": "订单明细",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0013PickupView",
            "viewtag": "9c19ca387095474bf5e6bb61d45950e8"
        },
        "ibizsample0003sf2editview": {
            "title": "示例实体03编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SF2EditView",
            "viewtag": "9dae5acc9f234dc1a664e045648c8500"
        },
        "ibizorderlistexpview_layout": {
            "title": "实体列表导航视图",
            "caption": "实体列表导航视图",
            "viewtype": "DELISTEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderListExpView_layout",
            "viewtag": "9f9b1d63418a9d14b98cb6c7e0e20d74"
        },
        "ibizordertypeusr2editview": {
            "title": "订单类型编辑视图",
            "caption": "订单类型",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTypeUsr2EditView",
            "viewtag": "9ffe26dcfc5b5ecab85bd1a4c44599a9"
        },
        "ibizorderodsp_wfexpview": {
            "title": "订单工作流导航视图(订单审批)",
            "caption": "订单",
            "viewtype": "DEWFEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderODSP_WFExpView",
            "viewtag": "a0a119238910f773384f0b178b4332bd"
        },
        "ibizsample0014gridview": {
            "title": "员工表格视图",
            "caption": "员工",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0014GridView",
            "viewtag": "a1bbc77fe4a994281db89157f64adef5"
        },
        "ibizsample0003pickupview": {
            "title": "IBIZSAMPLE0003数据选择视图",
            "caption": "示例实体03",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003PickupView",
            "viewtag": "a2936c6b9623c39072407c14da37ba3c"
        },
        "ibizordersf7editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF7EditView",
            "viewtag": "a4a4cf34a667f154c69d2875c432174e"
        },
        "ibizbookusr2pickuptreeview": {
            "title": "图书选择树视图",
            "caption": "图书",
            "viewtype": "DEPICKUPTREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2PickupTreeView",
            "viewtag": "a4a69f429887f43271781be0e37b08b1"
        },
        "ibizorderdetailgridview9": {
            "title": "订单明细表格视图",
            "caption": "订单明细",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailGridView9",
            "viewtag": "a5c123887fed6734a6b04952d01f242d"
        },
        "ibizsample0021wfdynaactionview_layout": {
            "title": "订单工作流动态操作视图",
            "caption": "订单工作流动态操作视图",
            "viewtype": "DEWFDYNAACTIONVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021WFDynaActionView_layout",
            "viewtag": "a6d2ee3618dcfb23c3db981c9dbc4340"
        },
        "ibizorders2editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderS2EditView",
            "viewtag": "a7ea138e26f5c5ca0e27c034259737ef"
        },
        "ibizstorageeditview": {
            "title": "存储编辑视图",
            "caption": "存储",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZStorageEditView",
            "viewtag": "a919926d6265ab194b54cd5b8f658eec"
        },
        "ibizbookcustomview": {
            "title": "实体自定义视图",
            "caption": "实体自定义视图",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKCustomView",
            "viewtag": "a9ac702e20306caf5a733545d652cfa9"
        },
        "ibizbookusr4listview": {
            "title": "实体列表视图",
            "caption": "实体列表视图",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr4ListView",
            "viewtag": "a9bf3ff5d065c8b7fd383b4d0d4dbcfe"
        },
        "ibizcustomermpickupview": {
            "title": "客户数据多项选择视图",
            "caption": "客户",
            "viewtype": "DEMPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerMPickupView",
            "viewtag": "a9c3b7c4ff10dfd9ccc9dc04531b6db9"
        },
        "ibizorderdetailsgridview9": {
            "title": "订单明细表格视图",
            "caption": "订单明细",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSGridView9",
            "viewtag": "aa59a7578f3da5d69d6e28ab021d867c"
        },
        "ibizbookganttview": {
            "title": "图书甘特视图",
            "caption": "图书",
            "viewtype": "DEGANTTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKGanttView",
            "viewtag": "abc97503108bb23608d6da332717aa3c"
        },
        "ibizsample0021gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021GridView",
            "viewtag": "abe2803e82d60899ed92c9578f0bf9d7"
        },
        "ibizbookusr2dataview": {
            "title": "图书数据视图（自动分组）",
            "caption": "图书",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2DataView",
            "viewtag": "acfbd095f5b4bf51113864a002dd0018"
        },
        "ibizcustomer_intfpickupview": {
            "title": "客户数据选择视图",
            "caption": "客户",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomer_INTFPickupView",
            "viewtag": "ae2667cf4cdc114e553fe2f7e75eacf4"
        },
        "ibizhardwareeditview": {
            "title": "硬件编辑视图",
            "caption": "硬件",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZHardwareEditView",
            "viewtag": "ae320ac92ef292866895940a2f61be48"
        },
        "ibizsample0003streeexpview2": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003STreeExpView2",
            "viewtag": "ae9b552b78fba7a4cf9b2d132551e8cd"
        },
        "ibizsample0017f30editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017F30EditView",
            "viewtag": "af6e28e1498796c0fcc0121f6378482e"
        },
        "ibizsample0021editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021EditView",
            "viewtag": "afffdfdd3ba8340fdf33581ad0171996"
        },
        "ibizbookdataview": {
            "title": "实体数据视图（内置功能）",
            "caption": "实体数据视图（内置功能）",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKDataView",
            "viewtag": "b0c93f3f44b11b2fab1afa559b374b40"
        },
        "ibizorderareachartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderAreaChartView",
            "viewtag": "b2112afe1bfbc19a57ffe46053ee1381"
        },
        "ibizbookusrwizardview_plugin": {
            "title": "底部步骤条",
            "caption": "底部步骤条",
            "viewtype": "DEWIZARDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrWizardView_plugin",
            "viewtag": "B30A816C-D046-4B05-8AFB-B3B5A3275F4F"
        },
        "ibizbookusr6dataview": {
            "title": "图书数据视图",
            "caption": "图书",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr6DataView",
            "viewtag": "b452c4f5138dc61d5ad7491a9095cab0"
        },
        "ibizcustomusr1118668829editview": {
            "title": "测试插件编辑视图",
            "caption": "自定义",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomUsr1118668829EditView",
            "viewtag": "B5EBDDC5-FF69-41D2-A3AD-438D13EE14A7"
        },
        "ibizsample0018editview": {
            "title": "示例实体04编辑视图",
            "caption": "示例实体18",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0018EditView",
            "viewtag": "b6051ffde71a38f002578df12de6fc66"
        },
        "microcomponentgridview": {
            "title": "微组件表格视图",
            "caption": "微组件",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "microComponentGridView",
            "viewtag": "b7aecf54cd81c0c02c8b29b80512b986"
        },
        "ibizorderdetailsgridview": {
            "title": "订单明细表格视图",
            "caption": "订单明细",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSGridView",
            "viewtag": "b9bb43793e46dd754a82ae6928e5557d"
        },
        "ibizbookdataviewexpview": {
            "title": "图书卡片视图导航视图",
            "caption": "图书",
            "viewtype": "DEDATAVIEWEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKDataViewExpView",
            "viewtag": "bb3b65cf9ba40413db60adce27a94db7"
        },
        "ibizsample0001sf4editview": {
            "title": "默认数据类型",
            "caption": "默认数据类型",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001SF4EditView",
            "viewtag": "bb609fe4b67afe2ec2d2e29112101036"
        },
        "ibizorderredirectview": {
            "title": "订单数据重定向视图",
            "caption": "订单",
            "viewtype": "DEREDIRECTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderRedirectView",
            "viewtag": "bbfdcd8f2a068286f0431e509a6fbc97"
        },
        "ibizordertestclchartview": {
            "title": "测试布局面板（图表）",
            "caption": "测试布局面板（图表）",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTestCLChartView",
            "viewtag": "BD432FCA-7527-48B5-B553-AE51D75438A3"
        },
        "ibizbooknewdefaultvaluegridview": {
            "title": "表格新建默认值",
            "caption": "表格新建默认值",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKNewDefaultValueGridView",
            "viewtag": "be796b135f7a2f9a83e22a91a0d21db9"
        },
        "ibizsample0003sf4editview": {
            "title": "示例实体03编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SF4EditView",
            "viewtag": "bf5291d1f7b00bc11f70bd7fcb1d46f3"
        },
        "ibizsample0021reassignwfdynaactionview": {
            "title": "实体工作流动态操作视图（转办）",
            "caption": "实体工作流动态操作视图（转办）",
            "viewtype": "DEWFDYNAACTIONVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021REASSIGNWFDynaActionView",
            "viewtag": "BFE52920-D6CB-4E52-AEAE-9E6C572FE8FC"
        },
        "ibizbookpickupview": {
            "title": "图书数据选择视图",
            "caption": "图书",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKPickupView",
            "viewtag": "c00136c9f309c2b6b14f43fcf5a6338e"
        },
        "ibizorderf19editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF19EditView",
            "viewtag": "c02089205b1bd1236ced28b71a9df413"
        },
        "ibizbookusr3dataview": {
            "title": "图书数据视图（代码表分组）",
            "caption": "图书",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr3DataView",
            "viewtag": "c0427187cee43fa1a1ed01a405514c63"
        },
        "ibizorderf17editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF17EditView",
            "viewtag": "c0f41311897266e15dd962fa76e26ce9"
        },
        "ibizsample0003smpickupview2": {
            "title": "IBIZSAMPLE0003多项数据选择视图",
            "caption": "示例实体03",
            "viewtype": "DEMPICKUPVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SMPickupView2",
            "viewtag": "c17a76ac3d142faf6fe7c91bfc361e80"
        },
        "ibizsample0001usr3gridview": {
            "title": "示例实体01表格视图",
            "caption": "示例实体01",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001Usr3GridView",
            "viewtag": "c35e7b61999bfe39f582dd6f8e810bd7"
        },
        "ibizorderseditview3": {
            "title": "实体编辑视图（分页关系）",
            "caption": "实体编辑视图（分页关系）",
            "viewtype": "DEEDITVIEW3",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView3",
            "viewtag": "c49a553a6cf0eb372176797db3e14b08"
        },
        "ibizorderlistexpview": {
            "title": "实体列表导航视图",
            "caption": "实体列表导航视图",
            "viewtype": "DELISTEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderListExpView",
            "viewtag": "c49fda1f55b84da055e850e06093b843"
        },
        "ibizbookusr5editview": {
            "title": "图书编辑视图",
            "caption": "图书借阅管理",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr5EditView",
            "viewtag": "c547bc4885f57d117461a64387c6e966"
        },
        "ibizbookwizardview": {
            "title": "实体向导视图",
            "caption": "实体向导视图",
            "viewtype": "DEWIZARDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKWizardView",
            "viewtag": "c575c51d887b8d1cbd6f4440cdba57cc"
        },
        "ibizbookusr5listview": {
            "title": "图书列表视图",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr5ListView",
            "viewtag": "c680bdc2306ff1ea39102917225bdade"
        },
        "ibizbookusrgridview_plugin": {
            "title": "表格视图底部工具栏",
            "caption": "表格视图底部工具栏",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrGridView_plugin",
            "viewtag": "C7C7F318-9BB2-4A0D-BE93-8E211898625E"
        },
        "ibizsample0002mpickupview": {
            "title": "首页图表数据源数据多项选择视图",
            "caption": "示例实体02",
            "viewtype": "DEMPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0002MPickupView",
            "viewtag": "c80bc2c651e4b76d00bb67566714c307"
        },
        "ibizsample0021wfdynaexpgridview_layout": {
            "title": " 实体工作流动态导航表格视图",
            "caption": " 实体工作流动态导航表格视图",
            "viewtype": "DEWFDYNAEXPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021WFDynaExpGridView_layout",
            "viewtag": "c898d7238b770cd5350c8a37c312159b"
        },
        "ibizorderganttview": {
            "title": "实体甘特视图",
            "caption": "实体甘特视图",
            "viewtype": "DEGANTTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderGanttView",
            "viewtag": "c90383785f656c274d33370f2b58cdb7"
        },
        "ibizcustomer_intfpickupgridview": {
            "title": "客户选择表格视图",
            "caption": "客户",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomer_INTFPickupGridView",
            "viewtag": "ca77d5bafd522a52fd278e490ad79f2d"
        },
        "ibizbookusroptionview": {
            "title": "选项操作视图左侧按钮",
            "caption": "选项操作视图左侧按钮",
            "viewtype": "DEOPTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrOptionView",
            "viewtag": "CA7D75CA-7F3A-40F6-9DF9-587D0DAE8ECF"
        },
        "ibizbookwizardview_layout": {
            "title": "实体向导视图",
            "caption": "实体向导视图",
            "viewtype": "DEWIZARDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKWizardView_layout",
            "viewtag": "ca90f2d89734ba48161642abc9d2cbbd"
        },
        "ibizbooktabsearchview": {
            "title": "图书分页搜索视图",
            "caption": "图书",
            "viewtype": "DETABSEARCHVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTabSearchView",
            "viewtag": "cac82d0ff3dfbb0d7980d0d49a25d026"
        },
        "ibizbookinterfunckanbanview": {
            "title": "实体看板视图（内置功能）",
            "caption": "实体看板视图（内置功能）",
            "viewtype": "DEKANBANVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKInterFuncKanBanView",
            "viewtag": "cac88dba02a9043c06f3582f7d1c9ab6"
        },
        "ibizorderpickupgridview": {
            "title": "订单选择表格视图",
            "caption": "订单",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderPickupGridView",
            "viewtag": "cb616d70c0b3978802b768cb6c7a67b4"
        },
        "ibizsample0017gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017GridView",
            "viewtag": "cb70a29afafed2bc8bcc97ec475b68dc"
        },
        "ibizbookusrgridview_ctrlplugin": {
            "title": "表格部件插件-红色表格头",
            "caption": "表格部件插件-红色表格头",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrGridView_ctrlPlugin",
            "viewtag": "CBB075E1-BDC9-4F6A-BCF4-09EC4D7370EE"
        },
        "ibizsoftwaresuitgridview9": {
            "title": "软件表格视图",
            "caption": "软件",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZSoftwareSuitGridView9",
            "viewtag": "cbf09cbd2a5b6c65479dec84af3fe874"
        },
        "ibizsample0001sf5editview": {
            "title": "默认编辑器类型",
            "caption": "默认编辑器类型",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001SF5EditView",
            "viewtag": "cbfcd74d365d562cbfa3ba6deef39e86"
        },
        "ibizbookusr2customview": {
            "title": "图书自定义视图",
            "caption": "图书",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2CustomView",
            "viewtag": "cd8668cf71ef2c2a33882869195d41df"
        },
        "ibizbooklistexpview": {
            "title": "图书列表导航视图",
            "caption": "图书",
            "viewtype": "DELISTEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKListExpView",
            "viewtag": "ce761954d47de70419725c986316a6be"
        },
        "ibizbookpanelview": {
            "title": "图书面板视图",
            "caption": "图书",
            "viewtype": "DEPANELVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKPanelView",
            "viewtag": "ce76ac3e15df5bdc9ba9d8c87d3f6cd7"
        },
        "ibizbookhaspanellistview": {
            "title": "图书列表视图（嵌入面板）",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKHasPanelListView",
            "viewtag": "d0683173aefd706f451cf652552c5dd7"
        },
        "ibizorderdetailusr3editview": {
            "title": "订单明细编辑视图",
            "caption": "订单明细",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailUsr3EditView",
            "viewtag": "d1e103c50de1fa941638bec77683936c"
        },
        "ibizbookusr10gridview": {
            "title": "图书表格视图",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr10GridView",
            "viewtag": "d27b8d175939b908e96b44174c8adf9d"
        },
        "ibizorderseditview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView",
            "viewtag": "d2960a0c91791e31738caa6d8f0f2212"
        },
        "ibizbookcalendarview": {
            "title": "实体日历视图（内置功能）",
            "caption": "实体日历视图（内置功能）",
            "viewtype": "DECALENDARVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKCalendarView",
            "viewtag": "d4043ce4728d459ec224e5cef99eab35"
        },
        "ibizsample0003editview": {
            "title": "IBIZSAMPLE0003编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003EditView",
            "viewtag": "d423bf41a5e42bf315b81401b13b0ed6"
        },
        "ibizbookusrlistview_plugin": {
            "title": "列表视图斑马纹",
            "caption": "列表视图斑马纹",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrListView_plugin",
            "viewtag": "D4BB9A85-DE51-4CB3-810D-D33DF0B1F8AA"
        },
        "ibizbookupdatedefaultgridview": {
            "title": "表格更新默认值",
            "caption": "表格更新默认值",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUpdateDefaultGridView",
            "viewtag": "d54cede78592924ae6725eb401e369b9"
        },
        "ibizordertestcleditview2": {
            "title": "测试视图布局面板",
            "caption": "订单",
            "viewtype": "DEEDITVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTestCLEditView2",
            "viewtag": "D6D7779F-95C9-48C0-B2E1-ED4C20E5E157"
        },
        "ibizsample0017pickupview": {
            "title": "订单数据选择视图",
            "caption": "订单",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017PickupView",
            "viewtag": "d7cfa0f4fcb1e5bd92697847a4baa1ad"
        },
        "ibizordertreegridexview": {
            "title": "实体树表格视图（增强）",
            "caption": "实体树表格视图（增强）",
            "viewtype": "DETREEGRIDEXVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTreeGridExView",
            "viewtag": "d7f9470512d0d0ad2d4aba7b17e40b05"
        },
        "ibizorderstate10editview2": {
            "title": "订单编辑视图(未提交)",
            "caption": "订单",
            "viewtype": "DEEDITVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderState10EditView2",
            "viewtag": "d827fd85e8d9be1bb9348765c09cd465"
        },
        "ibizbookusrpickupview_plugin": {
            "title": "选择视图插件（vue3）",
            "caption": "选择视图插件（vue3）",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrPickupView_plugin",
            "viewtag": "D8DC4CF2-3FDF-4FF3-8914-2AEC6063C86F"
        },
        "ibizsample0017editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017EditView",
            "viewtag": "d955fcb0bfb083b8ca08210cce15527b"
        },
        "ibiztaskteameditview9": {
            "title": "任务团队编辑视图（临时模式）",
            "caption": "临时模式",
            "viewtype": "DEEDITVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZTASKTEAMEditView9",
            "viewtag": "d985337c61d3832ea28781561622a1cd"
        },
        "ibizordertestgridexpview": {
            "title": "订单表格导航视图",
            "caption": "订单",
            "viewtype": "DEGRIDEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTestGridExpView",
            "viewtag": "d98e54e4abc3bb0f21e0b594a7caf095"
        },
        "ibizappviewlistview": {
            "title": "应用视图列表视图",
            "caption": "应用视图",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPVIEWListView",
            "viewtag": "db57a81b119c5e77a63d183827c598e1"
        },
        "ibizsample0001editview": {
            "title": "IBIZSAMPLE0001编辑视图",
            "caption": "示例实体01",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001EditView",
            "viewtag": "de2220d784a140bd8400431c499d1ff2"
        },
        "ibizbookusr8editview": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr8EditView",
            "viewtag": "de37e360bd8ff1c2eea34c446c7f811d"
        },
        "ibizbooklistview": {
            "title": "图书列表视图（内置功能）",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKListView",
            "viewtag": "de45503483d6c321ff4ab1b3baadb4b2"
        },
        "ibizordertypepickupgridview": {
            "title": "订单类型选择表格视图",
            "caption": "订单类型",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTypePickupGridView",
            "viewtag": "de74e401c3a4070d619e5fc8a54f042e"
        },
        "ibizorderusr4editview": {
            "title": "订单实体编辑视图(临时模式)",
            "caption": "订单实体编辑视图(临时模式)",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr4EditView",
            "viewtag": "debaa644866c1a08584b7a12df271afb"
        },
        "ibizbookruleseditview": {
            "title": "图书编辑视图（值规则）",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKRulesEditView",
            "viewtag": "e03416faeeb9c0c865622b794599cc0e"
        },
        "ibizuniproductpickupgridview": {
            "title": "统一产品选择表格视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductPickupGridView",
            "viewtag": "e2a58ca376f6971899aaf50981edf7b2"
        },
        "ibizordertreeexpview": {
            "title": "实体树导航视图",
            "caption": "实体树导航视图",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTreeExpView",
            "viewtag": "e445494f8d658d87d054b1fc51831af1"
        },
        "ibizordersf1editview": {
            "title": "编辑表单新建默认值",
            "caption": "编辑表单新建默认值",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF1EditView",
            "viewtag": "e5906164ac1e621f61dc58171942293a"
        },
        "ibizbookpickupgridview": {
            "title": "图书选择表格视图",
            "caption": "图书",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKPickupGridView",
            "viewtag": "e62e63ceacd7852f687212fde5e80107"
        },
        "ibizbookusr2editview": {
            "title": "实体数据选择视图",
            "caption": "实体数据选择视图",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2EditView",
            "viewtag": "e6b64344b4671dee26c707efa2888c22"
        },
        "ibizorderstate40editview2": {
            "title": "订单编辑视图(未通过)",
            "caption": "订单",
            "viewtype": "DEEDITVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderState40EditView2",
            "viewtag": "e6b9fc2b5a23e89827909ccc050eb381"
        },
        "ibizbooktestlogiccustomview": {
            "title": "测试界面逻辑",
            "caption": "测试界面逻辑",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTestLogicCustomView",
            "viewtag": "E74D4E6C-CFF5-4CBA-8195-FD943B3B910F"
        },
        "ibizcustomerusr2pickupview_layout": {
            "title": "客户实体数据选择视图(树视图)",
            "caption": "客户",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerUsr2PickupView_layout",
            "viewtag": "e7f12b95864b12114256d9c4dbbb559c"
        },
        "ibizbookusr4listview_layout": {
            "title": "实体列表视图",
            "caption": "实体列表视图",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr4ListView_layout",
            "viewtag": "e7f8129ccc696b1cf45a18d0961705da"
        },
        "ibizordersf1gridview": {
            "title": "搜索表单内置功能",
            "caption": "搜索表单内置功能",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF1GridView",
            "viewtag": "e8271b561f5fcb9e1701252f7cb2e337"
        },
        "ibizbookusr5dataview": {
            "title": "图书数据视图（自定义插件）",
            "caption": "图书",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr5DataView",
            "viewtag": "e862ffe1a71d815675128622d97c75c4"
        },
        "ibizbookpickuptreeview": {
            "title": "图书选择树视图",
            "caption": "图书",
            "viewtype": "DEPICKUPTREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKPickupTreeView",
            "viewtag": "e8d0dc55a34b25ceb0cc20dfb301e88c"
        },
        "ibizordertreeexpview_layout": {
            "title": "实体树导航视图",
            "caption": "实体树导航视图",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTreeExpView_layout",
            "viewtag": "e9a38c4ae8ee81a86e3f25def14a0dbb"
        },
        "ibizordertestlogiccustomview": {
            "title": "测试界面逻辑（表格数据加载）",
            "caption": "测试界面逻辑（表格数据加载）",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTestLogicCustomView",
            "viewtag": "EAAC5BB9-2748-487E-933C-C76416BD32F7"
        },
        "ibizappextendeditoreditview": {
            "title": "扩展编辑器编辑视图",
            "caption": "扩展编辑器",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPEXTENDEDITOREditView",
            "viewtag": "eaca3fca32d48906a1ea949aa2acdbfa"
        },
        "ibizbookusr3gridview": {
            "title": "表格代码表分组",
            "caption": "表格代码表分组",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr3GridView",
            "viewtag": "ead4022bac3aa8cca83057d80db6eeaf"
        },
        "ibizordergridexpview": {
            "title": "实体表格导航视图",
            "caption": "实体表格导航视图",
            "viewtype": "DEGRIDEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderGridExpView",
            "viewtag": "eb7b89e6e628ba9fef4c9a684390b59e"
        },
        "ibizsample0015pickupgridview": {
            "title": "项目选择表格视图",
            "caption": "项目",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0015PickupGridView",
            "viewtag": "ec41920ca8a6a8e3ea7cc56e17686110"
        },
        "ibizsample0003mpickupview": {
            "title": "IBIZSAMPLE0003数据多项选择视图",
            "caption": "示例实体03",
            "viewtype": "DEMPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003MPickupView",
            "viewtag": "ed0d1572ab76a357fbb1f32f4b2c0350"
        },
        "ibizsample0014editview": {
            "title": "员工编辑视图",
            "caption": "员工",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0014EditView",
            "viewtag": "ed7706992d81668a4c9189922dc18643"
        },
        "ibizbookuiactiongridview": {
            "title": "图书表格视图（界面行为）",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUiActionGridView",
            "viewtag": "ed78366e2eee279c793da8d909b2a85a"
        },
        "ibizsample0021gridview_layout": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021GridView_layout",
            "viewtag": "ef0aa2f297f599cdbc14fc8393b78a1d"
        },
        "ibizorderpickupview": {
            "title": "订单数据选择视图",
            "caption": "订单",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderPickupView",
            "viewtag": "efefe92eef97af14a35603f0324861cb"
        },
        "ibizappctrlgridview": {
            "title": "应用部件表格视图",
            "caption": "应用部件",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPCTRLGridView",
            "viewtag": "f02f3853deeb0de73e6dc5ca60e98067"
        },
        "ibizcustomerpickupview": {
            "title": "客户数据选择视图",
            "caption": "客户",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerPickupView",
            "viewtag": "f083dd992abed44bf15a9930b45c3895"
        },
        "ibizbookusr4editview": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr4EditView",
            "viewtag": "f0e584392d060bfef6ad4cec29f73d0d"
        },
        "ibizordertabexpview": {
            "title": "实体分页导航视图",
            "caption": "实体分页导航视图",
            "viewtype": "DETABEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTabExpView",
            "viewtag": "f102adb54492a593c95a66e09402da81"
        },
        "ibizcustomergridview": {
            "title": "客户表格视图",
            "caption": "客户",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerGridView",
            "viewtag": "f184ae431c5fca62fddd870b8d7048a8"
        },
        "ibizbookeditview3": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW3",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKEditView3",
            "viewtag": "f1a9551d0bc6e13732ec8a471c74fe2b"
        },
        "ibizcustomcustomgridview": {
            "title": "自定义实现表格视图",
            "caption": "自定义实现表格视图",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomCustomGridView",
            "viewtag": "F25AC36D-6D69-43FA-89B4-BE7552CE99E2"
        },
        "ibizorderdetailf7gridview": {
            "title": "订单明细表格视图",
            "caption": "订单明细",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailF7GridView",
            "viewtag": "f3f5b351dbe910d8f15c0342a82976b3"
        },
        "ibizbookusr5gridview": {
            "title": "表格远程聚合",
            "caption": "表格远程聚合",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr5GridView",
            "viewtag": "f5c0f96d96b00d91622801fbcd628472"
        },
        "ibizorderusr2calendarexpview": {
            "title": "时间轴导航",
            "caption": "时间轴导航",
            "viewtype": "DECALENDAREXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr2CalendarExpView",
            "viewtag": "f607b539780782c46c34643913d06f4b"
        },
        "ibizbookusr2gridview": {
            "title": "表格自动分组",
            "caption": "表格自动分组",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2GridView",
            "viewtag": "f648af083c8e5e8246f5f36417007fac"
        },
        "ibizbookgroupbycodelistlistview": {
            "title": "图书列表视图（代码表分组）",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKGroupByCodelistListView",
            "viewtag": "f6975355692e6ed98980899d0813e095"
        },
        "ibizbookusr8gridview": {
            "title": "表格列重置",
            "caption": "表格列重置",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr8GridView",
            "viewtag": "f775b5fa118588587f6f02af5f79ec1f"
        },
        "ibizbookusreditview_actionplugin": {
            "title": "行为插件（vue3）",
            "caption": "行为插件（vue3）",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsrEditView_actionPlugin",
            "viewtag": "F7892096-9D26-49A7-A1E6-9D49CE5D60EA"
        },
        "ibizbooktreeexpview": {
            "title": "图书树导航视图",
            "caption": "图书",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTreeExpView",
            "viewtag": "f9b01dbeb8b738ebeab5e82f892593e3"
        },
        "ibizbookcustomview_layout": {
            "title": "实体自定义视图",
            "caption": "实体自定义视图",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKCustomView_layout",
            "viewtag": "fa2731c1873f3c86aa065e73cff4667b"
        },
        "ibizbookusr9gridview": {
            "title": "图书表格视图（主状态）",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr9GridView",
            "viewtag": "fbc25877298bbacf410c4d1a85bb053b"
        },
        "ibizorderdashboardview": {
            "title": "数据看板",
            "caption": "数据看板",
            "viewtype": "DEPORTALVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDashboardView",
            "viewtag": "fc7153dc2bad2d7b6242bb4e9df1f06a"
        },
        "ibizbookdashboardview_layout": {
            "title": "实体数据看板视图",
            "caption": "实体数据看板视图",
            "viewtype": "DEPORTALVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKDashboardView_layout",
            "viewtag": "fd181f2767ed6c82915d092a2ff51e01"
        },
        "ibizbookusr9editview": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr9EditView",
            "viewtag": "fd19ad69338d4d3e323c4b517667e754"
        },
        "ibizorderf13editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF13EditView",
            "viewtag": "fda00cd63e7ba8f89a3518e64b581433"
        },
        "ibizsample0021addstepbeforewfdynaactionview": {
            "title": " 实体工作流动态操作视图(前加签)",
            "caption": " 实体工作流动态操作视图(前加签)",
            "viewtype": "DEWFDYNAACTIONVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0021ADDSTEPBEFOREWFDynaActionView",
            "viewtag": "FE8FC98E-6465-4EB3-9336-BE1E90897170"
        },
        "ibizordersf3editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF3EditView",
            "viewtag": "fe9a43198dae9a3e4c169b82abfc45d9"
        },
        "ibizbookusr6editview": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr6EditView",
            "viewtag": "feb33293ff09babc44b9f366f04d06a8"
        },
        "ibizappextendeditorlistview": {
            "title": "扩展编辑器列表视图",
            "caption": "扩展编辑器",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZAPPEXTENDEDITORListView",
            "viewtag": "ff1c15c4e1ab04ec44c1ad38a794a843"
        },
        "apppanelview": {
            "title": "应用面板视图",
            "caption": "",
            "viewtype": "APPPANELVIEW",
            "viewmodule": "Ungroup",
            "viewname": "AppPanelView",
            "viewtag": "201acedb447253ee1add1c791fa31fd4"
        },
        "appindexview": {
            "title": "应用首页视图",
            "caption": "测试12231",
            "viewtype": "APPINDEXVIEW",
            "viewmodule": "Ungroup",
            "viewname": "AppIndexView",
            "viewtag": "2D42F3B7-3267-4276-9120-10F2D81E35AF"
        },
        "appwfsteptraceview": {
            "title": "应用流程跟踪视图",
            "caption": "应用流程跟踪视图",
            "viewtype": "APPWFSTEPTRACEVIEW",
            "viewmodule": "Ungroup",
            "viewname": "AppWFStepTraceView",
            "viewtag": "47F744B6-6308-4EFB-A7B7-B4BF8DC201C6"
        },
        "appportalview": {
            "title": "工作台",
            "caption": "工作台",
            "viewtype": "APPPORTALVIEW",
            "viewmodule": "Ungroup",
            "viewname": "AppPortalView",
            "viewtag": "96bc1e4d0d5d6b66d639f401966b375b"
        },
        "appwfredirectview": {
            "title": "应用流程工作重定向视图",
            "caption": "应用全局流程工作重定向视图",
            "viewtype": "APPWFREDIRECTVIEW",
            "viewmodule": "Ungroup",
            "viewname": "AppWFRedirectView",
            "viewtag": "C00515C5-465C-4847-8F9C-54B3B5D1D6F5"
        },
        "apppanelview2": {
            "title": "工作流待办",
            "caption": "工作流待办",
            "viewtype": "APPPANELVIEW",
            "viewmodule": "Ungroup",
            "viewname": "AppPanelView2",
            "viewtag": "C1022CE5-B44E-467C-86F0-6EDD0940B339"
        },
        "ibizordertestformmdctrleditview": {
            "title": "表单多数据部件测试",
            "caption": "表单多数据部件测试",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Ungroup",
            "viewname": "IBIZOrderTestFormMDCtrlEditView",
            "viewtag": "C7B14569-AFC1-4124-8822-C609232D1934"
        },
        "apploginview": {
            "title": "应用登录视图",
            "caption": "应用登录视图",
            "viewtype": "APPLOGINVIEW",
            "viewmodule": "Ungroup",
            "viewname": "AppLoginView",
            "viewtag": "DDD1152C-0A9F-44C5-82FA-7F6A469C5569"
        }
    }];
});

// 获取视图消息分组信息
mock.onGet('./assets/json/view-message-group.json').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status,{
        "VMGroup51":[
        {"tag":"ViewMsg50","position":"TOP","type":"ERROR"}
        ],
        "VMGroup65":[
        {"tag":"ViewMsg64","position":"TOP","type":"ERROR"}
        ],
        "VMGroup19":[
        {"tag":"ViewMsg18","position":"TOP","type":"ERROR"}
        ],
        "VMGroup77":[
        {"tag":"ViewMsg76","position":"TOP","type":"ERROR"}
        ],
        "VMGroup36":[
        {"tag":"ViewMsg35","position":"TOP","type":"ERROR"}
        ],
        "VMGroup18":[
        {"tag":"ViewMsg17","position":"TOP","type":"ERROR"}
        ],
        "VMGroup42":[
        {"tag":"ViewMsg41","position":"TOP","type":"ERROR"}
        ],
        "VMGroup70":[
        {"tag":"ViewMsg69","position":"TOP","type":"ERROR"}
        ],
        "VMGroup9":[
        {"tag":"DataViewDar","position":"TOP","type":"ERROR"}
        ],
        "VMGroup55":[
        {"tag":"ViewMsg54","position":"TOP","type":"ERROR"}
        ],
        "VMGroup69":[
        {"tag":"ViewMsg67","position":"TOP","type":"ERROR"}
        ],
        "VMGroup57":[
        {"tag":"ViewMsg56","position":"TOP","type":"ERROR"}
        ],
        "VMGroup27":[
        {"tag":"ViewMsg26","position":"TOP","type":"ERROR"}
        ],
        "VMGroup30":[
        {"tag":"ViewMsg28","position":"TOP","type":"ERROR"}
        ],
        "VMGroup26":[
        {"tag":"ViewMsg25","position":"TOP","type":"ERROR"}
        ],
        "VMGroup22":[
        {"tag":"ViewMsg21","position":"TOP","type":"ERROR"}
        ],
        "VMGroup75":[
        {"tag":"ViewMsg74","position":"TOP","type":"ERROR"}
        ],
        "VMGroup24":[
        {"tag":"ViewMsg23","position":"TOP","type":"ERROR"}
        ],
        "VMGroup49":[
        {"tag":"ViewMsg47","position":"TOP","type":"ERROR"}
        ],
        "VMGroup50":[
        {"tag":"ViewMsg49","position":"TOP","type":"ERROR"}
        ],
        "VMGroup91":[
        {"tag":"ViewMsg90","position":"TOP","type":"ERROR"}
        ],
        "VMGroup5":[
        {"tag":"ViewMsg5","position":"TOP","type":"ERROR"}
        ],
        "VMGroup38":[
        {"tag":"ViewMsg37","position":"TOP","type":"ERROR"}
        ],
        "VMGroup71":[
        {"tag":"ViewMsg70","position":"TOP","type":"ERROR"}
        ],
        "VMGroup72":[
        {"tag":"ViewMsg71","position":"TOP","type":"ERROR"}
        ],
        "VMGroup34":[
        {"tag":"ViewMsg33","position":"TOP","type":"ERROR"}
        ],
        "VMGroup56":[
        {"tag":"ViewMsg55","position":"TOP","type":"ERROR"}
        ],
        "VMGroup93":[
        {"tag":"ViewMsg92","position":"TOP","type":"ERROR"}
        ],
        "VMGroup98":[
        {"tag":"ViewMsg97","position":"TOP","type":"ERROR"}
        ],
        "VMGroup53":[
        {"tag":"ViewMsg52","position":"TOP","type":"ERROR"}
        ],
        "VMGroup16":[
        {"tag":"ViewMsg15","position":"TOP","type":"ERROR"}
        ],
        "VMGroup31":[
        {"tag":"ViewMsg29","position":"TOP","type":"ERROR"}
        ],
        "VMGroup64":[
        {"tag":"ViewMsg63","position":"TOP","type":"ERROR"}
        ],
        "VMGroup23":[
        {"tag":"ViewMsg22","position":"TOP","type":"ERROR"}
        ],
        "VMGroup32":[
        {"tag":"ViewMsg30","position":"TOP","type":"ERROR"}
        ],
        "VMGroup59":[
        {"tag":"ViewMsg58","position":"TOP","type":"ERROR"}
        ],
        "VMGroup90":[
        {"tag":"ViewMsg89","position":"TOP","type":"ERROR"}
        ],
        "VMGroup33":[
        {"tag":"ViewMsg32","position":"TOP","type":"ERROR"}
        ],
        "VMGroup67":[
        {"tag":"ViewMsg66","position":"TOP","type":"ERROR"}
        ],
        "VMGroup88":[
        {"tag":"ViewMsg87","position":"TOP","type":"ERROR"}
        ],
        "VMGroup20":[
        {"tag":"ViewMsg19","position":"TOP","type":"ERROR"}
        ],
        "VMGroup80":[
        {"tag":"ViewMsg79","position":"TOP","type":"ERROR"}
        ],
        "VMGroup54":[
        {"tag":"ViewMsg53","position":"TOP","type":"ERROR"}
        ],
        "VMGroup46":[
        {"tag":"ViewMsg46","position":"TOP","type":"ERROR"}
        ],
        "VMGroup58":[
        {"tag":"ViewMsg57","position":"TOP","type":"ERROR"}
        ],
        "VMGroup78":[
        {"tag":"ViewMsg77","position":"TOP","type":"ERROR"}
        ],
        "VMGroup3":[
        {"tag":"ViewMsg3","position":"TOP","type":"ERROR"}
        ],
        "VMGroup28":[
        {"tag":"ViewMsg27","position":"TOP","type":"ERROR"}
        ],
        "VMGroup73":[
        {"tag":"ViewMsg72","position":"TOP","type":"ERROR"}
        ],
        "VMGroup79":[
        {"tag":"ViewMsg78","position":"TOP","type":"ERROR"}
        ],
        "VMGroup66":[
        {"tag":"ViewMsg65","position":"TOP","type":"ERROR"}
        ],
        "VMGroup63":[
        {"tag":"ViewMsg62","position":"TOP","type":"ERROR"}
        ],
        "VMGroup76":[
        {"tag":"ViewMsg75","position":"TOP","type":"ERROR"}
        ],
        "VMGroup21":[
        {"tag":"ViewMsg20","position":"TOP","type":"ERROR"}
        ],
        "VMGroup95":[
        {"tag":"ViewMsg94","position":"TOP","type":"ERROR"}
        ],
        "VMGroup11":[
        {"tag":"ViewMsg10","position":"TOP","type":"ERROR"}
        ],
        "VMGroup61":[
        {"tag":"ViewMsg60","position":"TOP","type":"ERROR"}
        ],
        "VMGroup94":[
        {"tag":"ViewMsg93","position":"TOP","type":"ERROR"}
        ],
        "VMGroup97":[
        {"tag":"ViewMsg96","position":"TOP","type":"ERROR"}
        ],
        "VMGroup82":[
        {"tag":"ViewMsg81","position":"TOP","type":"ERROR"}
        ],
        "VMGroup45":[
        {"tag":"ViewMsg44","position":"TOP","type":"ERROR"}
        ],
        "VMGroup85":[
        {"tag":"ViewMsg84","position":"TOP","type":"ERROR"}
        ],
        "VMGroup96":[
        {"tag":"ViewMsg95","position":"TOP","type":"ERROR"}
        ],
        "VMGroup92":[
        {"tag":"ViewMsg91","position":"TOP","type":"ERROR"}
        ],
        "VMGroup40":[
        {"tag":"ViewMsg39","position":"TOP","type":"ERROR"}
        ],
        "VMGroup6":[
        {"tag":"ViewMsg6","position":"TOP","type":"ERROR"}
        ],
        "VMGroup81":[
        {"tag":"ViewMsg80","position":"TOP","type":"ERROR"}
        ],
        "VMGroup62":[
        {"tag":"ViewMsg61","position":"TOP","type":"ERROR"}
        ],
        "VMGroup":[
        {"tag":"ViewMsg","position":"TOP","type":"ERROR"}
        ],
        "VMGroup14":[
        {"tag":"ViewMsg13","position":"TOP","type":"ERROR"}
        ],
        "VMGroup41":[
        {"tag":"ViewMsg40","position":"TOP","type":"ERROR"}
        ],
        "VMGroup52":[
        {"tag":"ViewMsg51","position":"TOP","type":"ERROR"}
        ],
        "VMGroup2":[
        {"tag":"ViewMsg2","position":"TOP","type":"ERROR"}
        ],
        "VMGroup13":[
        {"tag":"ViewMsg12","position":"TOP","type":"ERROR"}
        ],
        "VMGroup25":[
        {"tag":"ViewMsg24","position":"TOP","type":"ERROR"}
        ],
        "VMGroup15":[
        {"tag":"ViewMsg14","position":"TOP","type":"ERROR"}
        ],
        "VMGroup10":[
        {"tag":"ViewMsg9","position":"TOP","type":"ERROR"}
        ],
        "VMGroup37":[
        {"tag":"ViewMsg36","position":"TOP","type":"ERROR"}
        ],
        "VMGroup48":[
        {"tag":"ViewMsg45","position":"TOP","type":"ERROR"}
        ],
        "VMGroup4":[
        {"tag":"ViewMsg4","position":"TOP","type":"ERROR"}
        ],
        "VMGroup39":[
        {"tag":"ViewMsg38","position":"TOP","type":"ERROR"}
        ],
        "VMGroup74":[
        {"tag":"ViewMsg73","position":"TOP","type":"ERROR"}
        ],
        "VMGroup8":[
        {"tag":"ViewMsg8","position":"TOP","type":"ERROR"}
        ],
        "VMGroup44":[
        {"tag":"ViewMsg43","position":"TOP","type":"ERROR"}
        ],
        "VMGroup17":[
        {"tag":"ViewMsg16","position":"TOP","type":"ERROR"}
        ],
        "VMGroup47":[
        {"tag":"ViewMsg48","position":"TOP","type":"ERROR"}
        ],
        "VMGroup7":[
        {"tag":"ViewMsg7","position":"TOP","type":"ERROR"}
        ],
        "VMGroup12":[
        {"tag":"ViewMsg11","position":"TOP","type":"ERROR"}
        ],
        "VMGroup43":[
        {"tag":"ViewMsg42","position":"TOP","type":"ERROR"}
        ],
        "VMGroup60":[
        {"tag":"ViewMsg59","position":"TOP","type":"ERROR"}
        ],
        "VMGroup68":[
        {"tag":"ViewMsg68","position":"TOP","type":"ERROR"}
        ]
    }];
});