package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSoftwareSuit;
import cn.ibizlab.core.sample.service.IBIZSoftwareSuitService;
import cn.ibizlab.core.sample.filter.IBIZSoftwareSuitSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"软件" })
@RestController("demoapi-ibizsoftwaresuit")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSoftwareSuitResource {

    @Autowired
    public IBIZSoftwareSuitService ibizSoftwareSuitService;

    @Autowired
    @Lazy
    public IBIZSoftwareSuitDTOMapping ibizSoftwareSuitDtoMapping;


    @ApiOperation(value = "创建Create", tags = {"软件" },  notes = "IBIZSoftwareSuit-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSoftwareSuit-Create-all') or hasPermission(this.ibizSoftwareSuitDtoMapping.toDomain(#dto),'DemoSys-IBIZSoftwareSuit-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsoftwaresuits")
    public ResponseEntity<IBIZSoftwareSuitDTO> create
            (@Validated @RequestBody IBIZSoftwareSuitDTO dto) {
        IBIZSoftwareSuit domain = ibizSoftwareSuitDtoMapping.toDomain(dto);
        ibizSoftwareSuitService.create(domain);
        IBIZSoftwareSuit rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSoftwareSuitDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"软件" },  notes = "IBIZSoftwareSuit-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSoftwareSuit-Get-all') or hasPermission(this.ibizSoftwareSuitDtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSoftwareSuit-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsoftwaresuits/{ibizSoftwareSuitId}")
    public ResponseEntity<IBIZSoftwareSuitDTO> getByIbizSoftwareSuitId
            (@PathVariable("ibizSoftwareSuitId") String ibizSoftwareSuitId) {
        IBIZSoftwareSuit rt = ibizSoftwareSuitService.get(ibizSoftwareSuitId);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSoftwareSuitDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"软件" },  notes = "IBIZSoftwareSuit-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSoftwareSuit-Remove-all') or hasPermission(this.ibizSoftwareSuitService.get(#ibizSoftwareSuitId),'DemoSys-IBIZSoftwareSuit-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsoftwaresuits/{ibizSoftwareSuitId}")
    public ResponseEntity<Boolean> removeByIbizSoftwareSuitId
            (@PathVariable("ibizSoftwareSuitId") String ibizSoftwareSuitId) {
        Boolean rt = ibizSoftwareSuitService.remove(ibizSoftwareSuitId);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"软件" },  notes = "IBIZSoftwareSuit-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSoftwareSuit-Update-all') or hasPermission(this.ibizSoftwareSuitService.get(#ibizSoftwareSuitId),'DemoSys-IBIZSoftwareSuit-Update')")
    @VersionCheck(entity = "ibizsoftwaresuit" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsoftwaresuits/{ibizSoftwareSuitId}")
    public ResponseEntity<IBIZSoftwareSuitDTO> updateByIbizSoftwareSuitId
            (@PathVariable("ibizSoftwareSuitId") String ibizSoftwareSuitId, @Validated @RequestBody IBIZSoftwareSuitDTO dto) {
        IBIZSoftwareSuit domain = ibizSoftwareSuitDtoMapping.toDomain(dto);
        domain.setIbizSoftwareSuitId(ibizSoftwareSuitId);
        ibizSoftwareSuitService.update(domain);
        IBIZSoftwareSuit rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSoftwareSuitDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"软件" },  notes = "IBIZSoftwareSuit-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsoftwaresuits/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSoftwareSuitDTO dto) {
        IBIZSoftwareSuit domain = ibizSoftwareSuitDtoMapping.toDomain(dto);
        Integer rt = ibizSoftwareSuitService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"软件" },  notes = "IBIZSoftwareSuit-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsoftwaresuits/getdraft")
    public ResponseEntity<IBIZSoftwareSuitDTO> getDraft
            (IBIZSoftwareSuitDTO dto) {
        IBIZSoftwareSuit domain = ibizSoftwareSuitDtoMapping.toDomain(dto);
        IBIZSoftwareSuit rt = ibizSoftwareSuitService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSoftwareSuitDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"软件" },  notes = "IBIZSoftwareSuit-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSoftwareSuit-Save-all') or hasPermission(this.ibizSoftwareSuitDtoMapping.toDomain(#dto),'DemoSys-IBIZSoftwareSuit-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsoftwaresuits/save")
    public ResponseEntity<IBIZSoftwareSuitDTO> save
            (@Validated @RequestBody IBIZSoftwareSuitDTO dto) {
        IBIZSoftwareSuit domain = ibizSoftwareSuitDtoMapping.toDomain(dto);
        ibizSoftwareSuitService.save(domain);
        IBIZSoftwareSuit rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSoftwareSuitDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"软件" },  notes = "IBIZSoftwareSuit-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSoftwareSuit-searchDefault-all','DemoSys-IBIZSoftwareSuit-Get-all') or hasPermission(#dto,'DemoSys-IBIZSoftwareSuit-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsoftwaresuits/fetchdefault")
    public ResponseEntity<List<IBIZSoftwareSuitDTO>> fetchDefault
            (IBIZSoftwareSuitSearchContext dto) {
        Page<IBIZSoftwareSuit> domains = ibizSoftwareSuitService.searchDefault(dto) ;
        List<IBIZSoftwareSuitDTO> list = ibizSoftwareSuitDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSoftwareSuit-Create-all')")
    @ApiOperation(value = "批量新建软件", tags = {"软件" },  notes = "批量新建软件")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsoftwaresuits/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSoftwareSuitDTO> dtos) {
        ibizSoftwareSuitService.createBatch(ibizSoftwareSuitDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSoftwareSuit-Update-all')")
    @ApiOperation(value = "批量更新软件", tags = {"软件" },  notes = "批量更新软件")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsoftwaresuits/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSoftwareSuitDTO> dtos) {
        ibizSoftwareSuitService.updateBatch(ibizSoftwareSuitDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSoftwareSuit-Save-all')")
    @ApiOperation(value = "批量保存软件", tags = {"软件" },  notes = "批量保存软件")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsoftwaresuits/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSoftwareSuitDTO> dtos) {
        ibizSoftwareSuitService.saveBatch(ibizSoftwareSuitDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSoftwareSuit-Save-all')")
    @ApiOperation(value = "批量导入软件", tags = {"软件" },  notes = "批量导入软件")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsoftwaresuits/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSoftwareSuitDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSoftwareSuit> list=ibizSoftwareSuitDtoMapping.toDomain(dtos);
            List<IBIZSoftwareSuit> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSoftwareSuitService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSoftwareSuit-Remove-all')")
    @ApiOperation(value = "批量删除软件", tags = {"软件" },  notes = "批量删除软件")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsoftwaresuits","/ibizsoftwaresuits/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSoftwareSuitService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
