package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0017;
import cn.ibizlab.core.sample.service.IBIZSample0017Service;
import cn.ibizlab.core.sample.filter.IBIZSample0017SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单" })
@RestController("demoapi-ibizsample0017")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0017Resource {

    @Autowired
    public IBIZSample0017Service ibizSample0017Service;

    @Autowired
    @Lazy
    public IBIZSample0017DTOMapping ibizSample0017DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"订单" },  notes = "IBIZSample0017-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0017-Create-all') or hasPermission(this.ibizSample0017DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0017-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0017s")
    public ResponseEntity<IBIZSample0017DTO> create
            (@Validated @RequestBody IBIZSample0017DTO dto) {
        IBIZSample0017 domain = ibizSample0017DtoMapping.toDomain(dto);
        ibizSample0017Service.create(domain);
        IBIZSample0017 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0017DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"订单" },  notes = "IBIZSample0017-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0017-Get-all') or hasPermission(this.ibizSample0017DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0017-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0017s/{ibizSample0017Id}")
    public ResponseEntity<IBIZSample0017DTO> getByIbizSample0017Id
            (@PathVariable("ibizSample0017Id") String ibizSample0017Id) {
        IBIZSample0017 rt = ibizSample0017Service.get(ibizSample0017Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0017DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"订单" },  notes = "IBIZSample0017-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0017-Remove-all') or hasPermission(this.ibizSample0017Service.get(#ibizSample0017Id),'DemoSys-IBIZSample0017-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0017s/{ibizSample0017Id}")
    public ResponseEntity<Boolean> removeByIbizSample0017Id
            (@PathVariable("ibizSample0017Id") String ibizSample0017Id) {
        Boolean rt = ibizSample0017Service.remove(ibizSample0017Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"订单" },  notes = "IBIZSample0017-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0017-Update-all') or hasPermission(this.ibizSample0017Service.get(#ibizSample0017Id),'DemoSys-IBIZSample0017-Update')")
    @VersionCheck(entity = "ibizsample0017" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0017s/{ibizSample0017Id}")
    public ResponseEntity<IBIZSample0017DTO> updateByIbizSample0017Id
            (@PathVariable("ibizSample0017Id") String ibizSample0017Id, @Validated @RequestBody IBIZSample0017DTO dto) {
        IBIZSample0017 domain = ibizSample0017DtoMapping.toDomain(dto);
        domain.setIbizSample0017Id(ibizSample0017Id);
        ibizSample0017Service.update(domain);
        IBIZSample0017 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0017DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"订单" },  notes = "IBIZSample0017-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0017s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0017DTO dto) {
        IBIZSample0017 domain = ibizSample0017DtoMapping.toDomain(dto);
        Integer rt = ibizSample0017Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"订单" },  notes = "IBIZSample0017-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0017s/getdraft")
    public ResponseEntity<IBIZSample0017DTO> getDraft
            (IBIZSample0017DTO dto) {
        IBIZSample0017 domain = ibizSample0017DtoMapping.toDomain(dto);
        IBIZSample0017 rt = ibizSample0017Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0017DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"订单" },  notes = "IBIZSample0017-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0017-Save-all') or hasPermission(this.ibizSample0017DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0017-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0017s/save")
    public ResponseEntity<IBIZSample0017DTO> save
            (@Validated @RequestBody IBIZSample0017DTO dto) {
        IBIZSample0017 domain = ibizSample0017DtoMapping.toDomain(dto);
        ibizSample0017Service.save(domain);
        IBIZSample0017 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0017DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"订单" },  notes = "IBIZSample0017-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0017-searchDefault-all','DemoSys-IBIZSample0017-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0017-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0017s/fetchdefault")
    public ResponseEntity<List<IBIZSample0017DTO>> fetchDefault
            (IBIZSample0017SearchContext dto) {
        Page<IBIZSample0017> domains = ibizSample0017Service.searchDefault(dto) ;
        List<IBIZSample0017DTO> list = ibizSample0017DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0017-Create-all')")
    @ApiOperation(value = "批量新建订单", tags = {"订单" },  notes = "批量新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0017s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0017DTO> dtos) {
        ibizSample0017Service.createBatch(ibizSample0017DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0017-Update-all')")
    @ApiOperation(value = "批量更新订单", tags = {"订单" },  notes = "批量更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0017s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0017DTO> dtos) {
        ibizSample0017Service.updateBatch(ibizSample0017DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0017-Save-all')")
    @ApiOperation(value = "批量保存订单", tags = {"订单" },  notes = "批量保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0017s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0017DTO> dtos) {
        ibizSample0017Service.saveBatch(ibizSample0017DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0017-Save-all')")
    @ApiOperation(value = "批量导入订单", tags = {"订单" },  notes = "批量导入订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0017s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0017DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0017> list=ibizSample0017DtoMapping.toDomain(dtos);
            List<IBIZSample0017> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0017Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0017-Remove-all')")
    @ApiOperation(value = "批量删除订单", tags = {"订单" },  notes = "批量删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0017s","/ibizsample0017s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0017Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
