package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0013;
import cn.ibizlab.core.sample.service.IBIZSample0013Service;
import cn.ibizlab.core.sample.filter.IBIZSample0013SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单明细" })
@RestController("demoapi-ibizsample0013")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0013Resource {

    @Autowired
    public IBIZSample0013Service ibizSample0013Service;

    @Autowired
    @Lazy
    public IBIZSample0013DTOMapping ibizSample0013DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"订单明细" },  notes = "IBIZSample0013-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0013-Create-all') or hasPermission(this.ibizSample0013DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0013-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0013s")
    public ResponseEntity<IBIZSample0013DTO> create
            (@Validated @RequestBody IBIZSample0013DTO dto) {
        IBIZSample0013 domain = ibizSample0013DtoMapping.toDomain(dto);
        ibizSample0013Service.create(domain);
        IBIZSample0013 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0013DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"订单明细" },  notes = "IBIZSample0013-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0013-Get-all') or hasPermission(this.ibizSample0013DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0013-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0013s/{ibizSample0013Id}")
    public ResponseEntity<IBIZSample0013DTO> getByIbizSample0013Id
            (@PathVariable("ibizSample0013Id") String ibizSample0013Id) {
        IBIZSample0013 rt = ibizSample0013Service.get(ibizSample0013Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0013DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"订单明细" },  notes = "IBIZSample0013-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0013-Remove-all') or hasPermission(this.ibizSample0013Service.get(#ibizSample0013Id),'DemoSys-IBIZSample0013-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0013s/{ibizSample0013Id}")
    public ResponseEntity<Boolean> removeByIbizSample0013Id
            (@PathVariable("ibizSample0013Id") String ibizSample0013Id) {
        Boolean rt = ibizSample0013Service.remove(ibizSample0013Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"订单明细" },  notes = "IBIZSample0013-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0013-Update-all') or hasPermission(this.ibizSample0013Service.get(#ibizSample0013Id),'DemoSys-IBIZSample0013-Update')")
    @VersionCheck(entity = "ibizsample0013" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0013s/{ibizSample0013Id}")
    public ResponseEntity<IBIZSample0013DTO> updateByIbizSample0013Id
            (@PathVariable("ibizSample0013Id") String ibizSample0013Id, @Validated @RequestBody IBIZSample0013DTO dto) {
        IBIZSample0013 domain = ibizSample0013DtoMapping.toDomain(dto);
        domain.setIbizSample0013Id(ibizSample0013Id);
        ibizSample0013Service.update(domain);
        IBIZSample0013 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0013DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"订单明细" },  notes = "IBIZSample0013-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0013s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0013DTO dto) {
        IBIZSample0013 domain = ibizSample0013DtoMapping.toDomain(dto);
        Integer rt = ibizSample0013Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"订单明细" },  notes = "IBIZSample0013-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0013s/getdraft")
    public ResponseEntity<IBIZSample0013DTO> getDraft
            (IBIZSample0013DTO dto) {
        IBIZSample0013 domain = ibizSample0013DtoMapping.toDomain(dto);
        IBIZSample0013 rt = ibizSample0013Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0013DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"订单明细" },  notes = "IBIZSample0013-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0013-Save-all') or hasPermission(this.ibizSample0013DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0013-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0013s/save")
    public ResponseEntity<IBIZSample0013DTO> save
            (@Validated @RequestBody IBIZSample0013DTO dto) {
        IBIZSample0013 domain = ibizSample0013DtoMapping.toDomain(dto);
        ibizSample0013Service.save(domain);
        IBIZSample0013 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0013DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"订单明细" },  notes = "IBIZSample0013-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0013-searchDefault-all','DemoSys-IBIZSample0013-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0013-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0013s/fetchdefault")
    public ResponseEntity<List<IBIZSample0013DTO>> fetchDefault
            (IBIZSample0013SearchContext dto) {
        Page<IBIZSample0013> domains = ibizSample0013Service.searchDefault(dto) ;
        List<IBIZSample0013DTO> list = ibizSample0013DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0013-Create-all')")
    @ApiOperation(value = "批量新建订单明细", tags = {"订单明细" },  notes = "批量新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0013s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0013DTO> dtos) {
        ibizSample0013Service.createBatch(ibizSample0013DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0013-Update-all')")
    @ApiOperation(value = "批量更新订单明细", tags = {"订单明细" },  notes = "批量更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0013s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0013DTO> dtos) {
        ibizSample0013Service.updateBatch(ibizSample0013DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0013-Save-all')")
    @ApiOperation(value = "批量保存订单明细", tags = {"订单明细" },  notes = "批量保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0013s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0013DTO> dtos) {
        ibizSample0013Service.saveBatch(ibizSample0013DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0013-Save-all')")
    @ApiOperation(value = "批量导入订单明细", tags = {"订单明细" },  notes = "批量导入订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0013s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0013DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0013> list=ibizSample0013DtoMapping.toDomain(dtos);
            List<IBIZSample0013> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0013Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0013-Remove-all')")
    @ApiOperation(value = "批量删除订单明细", tags = {"订单明细" },  notes = "批量删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0013s","/ibizsample0013s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0013Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
