package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0012;
import cn.ibizlab.core.sample.service.IBIZSample0012Service;
import cn.ibizlab.core.sample.filter.IBIZSample0012SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单" })
@RestController("demoapi-ibizsample0012")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0012Resource {

    @Autowired
    public IBIZSample0012Service ibizSample0012Service;

    @Autowired
    @Lazy
    public IBIZSample0012DTOMapping ibizSample0012DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"订单" },  notes = "IBIZSample0012-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0012-Create-all') or hasPermission(this.ibizSample0012DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0012-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0012s")
    public ResponseEntity<IBIZSample0012DTO> create
            (@Validated @RequestBody IBIZSample0012DTO dto) {
        IBIZSample0012 domain = ibizSample0012DtoMapping.toDomain(dto);
        ibizSample0012Service.create(domain);
        IBIZSample0012 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0012DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"订单" },  notes = "IBIZSample0012-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0012-Get-all') or hasPermission(this.ibizSample0012DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0012-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0012s/{ibizSample0012Id}")
    public ResponseEntity<IBIZSample0012DTO> getByIbizSample0012Id
            (@PathVariable("ibizSample0012Id") String ibizSample0012Id) {
        IBIZSample0012 rt = ibizSample0012Service.get(ibizSample0012Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0012DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"订单" },  notes = "IBIZSample0012-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0012-Remove-all') or hasPermission(this.ibizSample0012Service.get(#ibizSample0012Id),'DemoSys-IBIZSample0012-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0012s/{ibizSample0012Id}")
    public ResponseEntity<Boolean> removeByIbizSample0012Id
            (@PathVariable("ibizSample0012Id") String ibizSample0012Id) {
        Boolean rt = ibizSample0012Service.remove(ibizSample0012Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"订单" },  notes = "IBIZSample0012-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0012-Update-all') or hasPermission(this.ibizSample0012Service.get(#ibizSample0012Id),'DemoSys-IBIZSample0012-Update')")
    @VersionCheck(entity = "ibizsample0012" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0012s/{ibizSample0012Id}")
    public ResponseEntity<IBIZSample0012DTO> updateByIbizSample0012Id
            (@PathVariable("ibizSample0012Id") String ibizSample0012Id, @Validated @RequestBody IBIZSample0012DTO dto) {
        IBIZSample0012 domain = ibizSample0012DtoMapping.toDomain(dto);
        domain.setIbizSample0012Id(ibizSample0012Id);
        ibizSample0012Service.update(domain);
        IBIZSample0012 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0012DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"订单" },  notes = "IBIZSample0012-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0012s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0012DTO dto) {
        IBIZSample0012 domain = ibizSample0012DtoMapping.toDomain(dto);
        Integer rt = ibizSample0012Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"订单" },  notes = "IBIZSample0012-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0012s/getdraft")
    public ResponseEntity<IBIZSample0012DTO> getDraft
            (IBIZSample0012DTO dto) {
        IBIZSample0012 domain = ibizSample0012DtoMapping.toDomain(dto);
        IBIZSample0012 rt = ibizSample0012Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0012DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"订单" },  notes = "IBIZSample0012-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0012-Save-all') or hasPermission(this.ibizSample0012DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0012-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0012s/save")
    public ResponseEntity<IBIZSample0012DTO> save
            (@Validated @RequestBody IBIZSample0012DTO dto) {
        IBIZSample0012 domain = ibizSample0012DtoMapping.toDomain(dto);
        ibizSample0012Service.save(domain);
        IBIZSample0012 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0012DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"订单" },  notes = "IBIZSample0012-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0012-searchDefault-all','DemoSys-IBIZSample0012-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0012-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0012s/fetchdefault")
    public ResponseEntity<List<IBIZSample0012DTO>> fetchDefault
            (IBIZSample0012SearchContext dto) {
        Page<IBIZSample0012> domains = ibizSample0012Service.searchDefault(dto) ;
        List<IBIZSample0012DTO> list = ibizSample0012DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0012-Create-all')")
    @ApiOperation(value = "批量新建订单", tags = {"订单" },  notes = "批量新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0012s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0012DTO> dtos) {
        ibizSample0012Service.createBatch(ibizSample0012DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0012-Update-all')")
    @ApiOperation(value = "批量更新订单", tags = {"订单" },  notes = "批量更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0012s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0012DTO> dtos) {
        ibizSample0012Service.updateBatch(ibizSample0012DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0012-Save-all')")
    @ApiOperation(value = "批量保存订单", tags = {"订单" },  notes = "批量保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0012s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0012DTO> dtos) {
        ibizSample0012Service.saveBatch(ibizSample0012DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0012-Save-all')")
    @ApiOperation(value = "批量导入订单", tags = {"订单" },  notes = "批量导入订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0012s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0012DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0012> list=ibizSample0012DtoMapping.toDomain(dtos);
            List<IBIZSample0012> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0012Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0012-Remove-all')")
    @ApiOperation(value = "批量删除订单", tags = {"订单" },  notes = "批量删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0012s","/ibizsample0012s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0012Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
