package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0009;
import cn.ibizlab.core.sample.service.IBIZSample0009Service;
import cn.ibizlab.core.sample.filter.IBIZSample0009SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"商品价格明细" })
@RestController("demoapi-ibizsample0009")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0009Resource {

    @Autowired
    public IBIZSample0009Service ibizSample0009Service;

    @Autowired
    @Lazy
    public IBIZSample0009DTOMapping ibizSample0009DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"商品价格明细" },  notes = "IBIZSample0009-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0009-Create-all') or hasPermission(this.ibizSample0009DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0009-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0009s")
    public ResponseEntity<IBIZSample0009DTO> create
            (@Validated @RequestBody IBIZSample0009DTO dto) {
        IBIZSample0009 domain = ibizSample0009DtoMapping.toDomain(dto);
        ibizSample0009Service.create(domain);
        IBIZSample0009 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0009DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"商品价格明细" },  notes = "IBIZSample0009-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0009-Get-all') or hasPermission(this.ibizSample0009DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0009-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0009s/{ibizSample0009Id}")
    public ResponseEntity<IBIZSample0009DTO> getByIbizSample0009Id
            (@PathVariable("ibizSample0009Id") String ibizSample0009Id) {
        IBIZSample0009 rt = ibizSample0009Service.get(ibizSample0009Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0009DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"商品价格明细" },  notes = "IBIZSample0009-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0009-Remove-all') or hasPermission(this.ibizSample0009Service.get(#ibizSample0009Id),'DemoSys-IBIZSample0009-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0009s/{ibizSample0009Id}")
    public ResponseEntity<Boolean> removeByIbizSample0009Id
            (@PathVariable("ibizSample0009Id") String ibizSample0009Id) {
        Boolean rt = ibizSample0009Service.remove(ibizSample0009Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"商品价格明细" },  notes = "IBIZSample0009-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0009-Update-all') or hasPermission(this.ibizSample0009Service.get(#ibizSample0009Id),'DemoSys-IBIZSample0009-Update')")
    @VersionCheck(entity = "ibizsample0009" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0009s/{ibizSample0009Id}")
    public ResponseEntity<IBIZSample0009DTO> updateByIbizSample0009Id
            (@PathVariable("ibizSample0009Id") String ibizSample0009Id, @Validated @RequestBody IBIZSample0009DTO dto) {
        IBIZSample0009 domain = ibizSample0009DtoMapping.toDomain(dto);
        domain.setIbizSample0009Id(ibizSample0009Id);
        ibizSample0009Service.update(domain);
        IBIZSample0009 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0009DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"商品价格明细" },  notes = "IBIZSample0009-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0009s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0009DTO dto) {
        IBIZSample0009 domain = ibizSample0009DtoMapping.toDomain(dto);
        Integer rt = ibizSample0009Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"商品价格明细" },  notes = "IBIZSample0009-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0009s/getdraft")
    public ResponseEntity<IBIZSample0009DTO> getDraft
            (IBIZSample0009DTO dto) {
        IBIZSample0009 domain = ibizSample0009DtoMapping.toDomain(dto);
        IBIZSample0009 rt = ibizSample0009Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0009DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"商品价格明细" },  notes = "IBIZSample0009-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0009-Save-all') or hasPermission(this.ibizSample0009DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0009-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0009s/save")
    public ResponseEntity<IBIZSample0009DTO> save
            (@Validated @RequestBody IBIZSample0009DTO dto) {
        IBIZSample0009 domain = ibizSample0009DtoMapping.toDomain(dto);
        ibizSample0009Service.save(domain);
        IBIZSample0009 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0009DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"商品价格明细" },  notes = "IBIZSample0009-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0009-searchDefault-all','DemoSys-IBIZSample0009-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0009-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0009s/fetchdefault")
    public ResponseEntity<List<IBIZSample0009DTO>> fetchDefault
            (IBIZSample0009SearchContext dto) {
        Page<IBIZSample0009> domains = ibizSample0009Service.searchDefault(dto) ;
        List<IBIZSample0009DTO> list = ibizSample0009DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0009-Create-all')")
    @ApiOperation(value = "批量新建商品价格明细", tags = {"商品价格明细" },  notes = "批量新建商品价格明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0009s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0009DTO> dtos) {
        ibizSample0009Service.createBatch(ibizSample0009DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0009-Update-all')")
    @ApiOperation(value = "批量更新商品价格明细", tags = {"商品价格明细" },  notes = "批量更新商品价格明细")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0009s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0009DTO> dtos) {
        ibizSample0009Service.updateBatch(ibizSample0009DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0009-Save-all')")
    @ApiOperation(value = "批量保存商品价格明细", tags = {"商品价格明细" },  notes = "批量保存商品价格明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0009s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0009DTO> dtos) {
        ibizSample0009Service.saveBatch(ibizSample0009DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0009-Save-all')")
    @ApiOperation(value = "批量导入商品价格明细", tags = {"商品价格明细" },  notes = "批量导入商品价格明细")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0009s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0009DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0009> list=ibizSample0009DtoMapping.toDomain(dtos);
            List<IBIZSample0009> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0009Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0009-Remove-all')")
    @ApiOperation(value = "批量删除商品价格明细", tags = {"商品价格明细" },  notes = "批量删除商品价格明细")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0009s","/ibizsample0009s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0009Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
