package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0006;
import cn.ibizlab.core.sample.service.IBIZSample0006Service;
import cn.ibizlab.core.sample.filter.IBIZSample0006SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"嵌套流程（主）" })
@RestController("demoapi-ibizsample0006")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0006Resource {

    @Autowired
    public IBIZSample0006Service ibizSample0006Service;

    @Autowired
    @Lazy
    public IBIZSample0006DTOMapping ibizSample0006DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"嵌套流程（主）" },  notes = "IBIZSample0006-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0006-Create-all') or hasPermission(this.ibizSample0006DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0006-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0006s")
    public ResponseEntity<IBIZSample0006DTO> create
            (@Validated @RequestBody IBIZSample0006DTO dto) {
        IBIZSample0006 domain = ibizSample0006DtoMapping.toDomain(dto);
        ibizSample0006Service.create(domain);
        IBIZSample0006 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0006DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"嵌套流程（主）" },  notes = "IBIZSample0006-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0006-Get-all') or hasPermission(this.ibizSample0006DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0006-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0006s/{ibizSample0006Id}")
    public ResponseEntity<IBIZSample0006DTO> getByIbizSample0006Id
            (@PathVariable("ibizSample0006Id") String ibizSample0006Id) {
        IBIZSample0006 rt = ibizSample0006Service.get(ibizSample0006Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0006DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"嵌套流程（主）" },  notes = "IBIZSample0006-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0006-Remove-all') or hasPermission(this.ibizSample0006Service.get(#ibizSample0006Id),'DemoSys-IBIZSample0006-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0006s/{ibizSample0006Id}")
    public ResponseEntity<Boolean> removeByIbizSample0006Id
            (@PathVariable("ibizSample0006Id") String ibizSample0006Id) {
        Boolean rt = ibizSample0006Service.remove(ibizSample0006Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"嵌套流程（主）" },  notes = "IBIZSample0006-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0006-Update-all') or hasPermission(this.ibizSample0006Service.get(#ibizSample0006Id),'DemoSys-IBIZSample0006-Update')")
    @VersionCheck(entity = "ibizsample0006" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0006s/{ibizSample0006Id}")
    public ResponseEntity<IBIZSample0006DTO> updateByIbizSample0006Id
            (@PathVariable("ibizSample0006Id") String ibizSample0006Id, @Validated @RequestBody IBIZSample0006DTO dto) {
        IBIZSample0006 domain = ibizSample0006DtoMapping.toDomain(dto);
        domain.setIbizSample0006Id(ibizSample0006Id);
        ibizSample0006Service.update(domain);
        IBIZSample0006 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0006DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"嵌套流程（主）" },  notes = "IBIZSample0006-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0006s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0006DTO dto) {
        IBIZSample0006 domain = ibizSample0006DtoMapping.toDomain(dto);
        Integer rt = ibizSample0006Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"嵌套流程（主）" },  notes = "IBIZSample0006-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0006s/getdraft")
    public ResponseEntity<IBIZSample0006DTO> getDraft
            (IBIZSample0006DTO dto) {
        IBIZSample0006 domain = ibizSample0006DtoMapping.toDomain(dto);
        IBIZSample0006 rt = ibizSample0006Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0006DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"嵌套流程（主）" },  notes = "IBIZSample0006-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0006-Save-all') or hasPermission(this.ibizSample0006DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0006-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0006s/save")
    public ResponseEntity<IBIZSample0006DTO> save
            (@Validated @RequestBody IBIZSample0006DTO dto) {
        IBIZSample0006 domain = ibizSample0006DtoMapping.toDomain(dto);
        ibizSample0006Service.save(domain);
        IBIZSample0006 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0006DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"嵌套流程（主）" },  notes = "IBIZSample0006-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0006-searchDefault-all','DemoSys-IBIZSample0006-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0006-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0006s/fetchdefault")
    public ResponseEntity<List<IBIZSample0006DTO>> fetchDefault
            (IBIZSample0006SearchContext dto) {
        Page<IBIZSample0006> domains = ibizSample0006Service.searchDefault(dto) ;
        List<IBIZSample0006DTO> list = ibizSample0006DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0006-Create-all')")
    @ApiOperation(value = "批量新建嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "批量新建嵌套流程（主）")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0006s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0006DTO> dtos) {
        ibizSample0006Service.createBatch(ibizSample0006DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0006-Update-all')")
    @ApiOperation(value = "批量更新嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "批量更新嵌套流程（主）")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0006s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0006DTO> dtos) {
        ibizSample0006Service.updateBatch(ibizSample0006DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0006-Save-all')")
    @ApiOperation(value = "批量保存嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "批量保存嵌套流程（主）")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0006s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0006DTO> dtos) {
        ibizSample0006Service.saveBatch(ibizSample0006DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0006-Save-all')")
    @ApiOperation(value = "批量导入嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "批量导入嵌套流程（主）")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0006s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0006DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0006> list=ibizSample0006DtoMapping.toDomain(dtos);
            List<IBIZSample0006> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0006Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0006-Remove-all')")
    @ApiOperation(value = "批量删除嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "批量删除嵌套流程（主）")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0006s","/ibizsample0006s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0006Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
