package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0004;
import cn.ibizlab.core.sample.service.IBIZSample0004Service;
import cn.ibizlab.core.sample.filter.IBIZSample0004SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"多版本流程" })
@RestController("demoapi-ibizsample0004")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0004Resource {

    @Autowired
    public IBIZSample0004Service ibizSample0004Service;

    @Autowired
    @Lazy
    public IBIZSample0004DTOMapping ibizSample0004DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"多版本流程" },  notes = "IBIZSample0004-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0004-Create-all') or hasPermission(this.ibizSample0004DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0004-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0004s")
    public ResponseEntity<IBIZSample0004DTO> create
            (@Validated @RequestBody IBIZSample0004DTO dto) {
        IBIZSample0004 domain = ibizSample0004DtoMapping.toDomain(dto);
        ibizSample0004Service.create(domain);
        IBIZSample0004 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0004DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"多版本流程" },  notes = "IBIZSample0004-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0004-Get-all') or hasPermission(this.ibizSample0004DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0004-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0004s/{ibizSample0004Id}")
    public ResponseEntity<IBIZSample0004DTO> getByIbizSample0004Id
            (@PathVariable("ibizSample0004Id") String ibizSample0004Id) {
        IBIZSample0004 rt = ibizSample0004Service.get(ibizSample0004Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0004DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"多版本流程" },  notes = "IBIZSample0004-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0004-Remove-all') or hasPermission(this.ibizSample0004Service.get(#ibizSample0004Id),'DemoSys-IBIZSample0004-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0004s/{ibizSample0004Id}")
    public ResponseEntity<Boolean> removeByIbizSample0004Id
            (@PathVariable("ibizSample0004Id") String ibizSample0004Id) {
        Boolean rt = ibizSample0004Service.remove(ibizSample0004Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"多版本流程" },  notes = "IBIZSample0004-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0004-Update-all') or hasPermission(this.ibizSample0004Service.get(#ibizSample0004Id),'DemoSys-IBIZSample0004-Update')")
    @VersionCheck(entity = "ibizsample0004" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0004s/{ibizSample0004Id}")
    public ResponseEntity<IBIZSample0004DTO> updateByIbizSample0004Id
            (@PathVariable("ibizSample0004Id") String ibizSample0004Id, @Validated @RequestBody IBIZSample0004DTO dto) {
        IBIZSample0004 domain = ibizSample0004DtoMapping.toDomain(dto);
        domain.setIbizSample0004Id(ibizSample0004Id);
        ibizSample0004Service.update(domain);
        IBIZSample0004 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0004DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"多版本流程" },  notes = "IBIZSample0004-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0004s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0004DTO dto) {
        IBIZSample0004 domain = ibizSample0004DtoMapping.toDomain(dto);
        Integer rt = ibizSample0004Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"多版本流程" },  notes = "IBIZSample0004-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0004s/getdraft")
    public ResponseEntity<IBIZSample0004DTO> getDraft
            (IBIZSample0004DTO dto) {
        IBIZSample0004 domain = ibizSample0004DtoMapping.toDomain(dto);
        IBIZSample0004 rt = ibizSample0004Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0004DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"多版本流程" },  notes = "IBIZSample0004-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0004-Save-all') or hasPermission(this.ibizSample0004DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0004-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0004s/save")
    public ResponseEntity<IBIZSample0004DTO> save
            (@Validated @RequestBody IBIZSample0004DTO dto) {
        IBIZSample0004 domain = ibizSample0004DtoMapping.toDomain(dto);
        ibizSample0004Service.save(domain);
        IBIZSample0004 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0004DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"多版本流程" },  notes = "IBIZSample0004-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0004-searchDefault-all','DemoSys-IBIZSample0004-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0004-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0004s/fetchdefault")
    public ResponseEntity<List<IBIZSample0004DTO>> fetchDefault
            (IBIZSample0004SearchContext dto) {
        Page<IBIZSample0004> domains = ibizSample0004Service.searchDefault(dto) ;
        List<IBIZSample0004DTO> list = ibizSample0004DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0004-Create-all')")
    @ApiOperation(value = "批量新建多版本流程", tags = {"多版本流程" },  notes = "批量新建多版本流程")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0004s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0004DTO> dtos) {
        ibizSample0004Service.createBatch(ibizSample0004DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0004-Update-all')")
    @ApiOperation(value = "批量更新多版本流程", tags = {"多版本流程" },  notes = "批量更新多版本流程")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0004s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0004DTO> dtos) {
        ibizSample0004Service.updateBatch(ibizSample0004DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0004-Save-all')")
    @ApiOperation(value = "批量保存多版本流程", tags = {"多版本流程" },  notes = "批量保存多版本流程")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0004s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0004DTO> dtos) {
        ibizSample0004Service.saveBatch(ibizSample0004DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0004-Save-all')")
    @ApiOperation(value = "批量导入多版本流程", tags = {"多版本流程" },  notes = "批量导入多版本流程")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0004s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0004DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0004> list=ibizSample0004DtoMapping.toDomain(dtos);
            List<IBIZSample0004> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0004Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0004-Remove-all')")
    @ApiOperation(value = "批量删除多版本流程", tags = {"多版本流程" },  notes = "批量删除多版本流程")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0004s","/ibizsample0004s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0004Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
