package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import cn.ibizlab.core.sample.service.IBIZHardwareService;
import cn.ibizlab.core.sample.filter.IBIZHardwareSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"硬件" })
@RestController("demoapi-ibizhardware")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZHardwareResource {

    @Autowired
    public IBIZHardwareService ibizHardwareService;

    @Autowired
    @Lazy
    public IBIZHardwareDTOMapping ibizHardwareDtoMapping;


    @ApiOperation(value = "创建Create", tags = {"硬件" },  notes = "IBIZHardware-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZHardware-Create-all') or hasPermission(this.ibizHardwareDtoMapping.toDomain(#dto),'DemoSys-IBIZHardware-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizhardwares")
    public ResponseEntity<IBIZHardwareDTO> create
            (@Validated @RequestBody IBIZHardwareDTO dto) {
        IBIZHardware domain = ibizHardwareDtoMapping.toDomain(dto);
        ibizHardwareService.create(domain);
        IBIZHardware rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizHardwareDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"硬件" },  notes = "IBIZHardware-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZHardware-Get-all') or hasPermission(this.ibizHardwareDtoMapping.toDomain(returnObject.body),'DemoSys-IBIZHardware-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizhardwares/{ibizHardwareId}")
    public ResponseEntity<IBIZHardwareDTO> getByIbizHardwareId
            (@PathVariable("ibizHardwareId") String ibizHardwareId) {
        IBIZHardware rt = ibizHardwareService.get(ibizHardwareId);
        return ResponseEntity.status(HttpStatus.OK).body(ibizHardwareDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"硬件" },  notes = "IBIZHardware-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZHardware-Remove-all') or hasPermission(this.ibizHardwareService.get(#ibizHardwareId),'DemoSys-IBIZHardware-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizhardwares/{ibizHardwareId}")
    public ResponseEntity<Boolean> removeByIbizHardwareId
            (@PathVariable("ibizHardwareId") String ibizHardwareId) {
        Boolean rt = ibizHardwareService.remove(ibizHardwareId);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"硬件" },  notes = "IBIZHardware-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZHardware-Update-all') or hasPermission(this.ibizHardwareService.get(#ibizHardwareId),'DemoSys-IBIZHardware-Update')")
    @VersionCheck(entity = "ibizhardware" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizhardwares/{ibizHardwareId}")
    public ResponseEntity<IBIZHardwareDTO> updateByIbizHardwareId
            (@PathVariable("ibizHardwareId") String ibizHardwareId, @Validated @RequestBody IBIZHardwareDTO dto) {
        IBIZHardware domain = ibizHardwareDtoMapping.toDomain(dto);
        domain.setIbizHardwareId(ibizHardwareId);
        ibizHardwareService.update(domain);
        IBIZHardware rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizHardwareDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"硬件" },  notes = "IBIZHardware-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizhardwares/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZHardwareDTO dto) {
        IBIZHardware domain = ibizHardwareDtoMapping.toDomain(dto);
        Integer rt = ibizHardwareService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"硬件" },  notes = "IBIZHardware-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizhardwares/getdraft")
    public ResponseEntity<IBIZHardwareDTO> getDraft
            (IBIZHardwareDTO dto) {
        IBIZHardware domain = ibizHardwareDtoMapping.toDomain(dto);
        IBIZHardware rt = ibizHardwareService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizHardwareDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"硬件" },  notes = "IBIZHardware-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZHardware-Save-all') or hasPermission(this.ibizHardwareDtoMapping.toDomain(#dto),'DemoSys-IBIZHardware-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizhardwares/save")
    public ResponseEntity<IBIZHardwareDTO> save
            (@Validated @RequestBody IBIZHardwareDTO dto) {
        IBIZHardware domain = ibizHardwareDtoMapping.toDomain(dto);
        ibizHardwareService.save(domain);
        IBIZHardware rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizHardwareDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"硬件" },  notes = "IBIZHardware-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZHardware-searchDefault-all','DemoSys-IBIZHardware-Get-all') or hasPermission(#dto,'DemoSys-IBIZHardware-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizhardwares/fetchdefault")
    public ResponseEntity<List<IBIZHardwareDTO>> fetchDefault
            (IBIZHardwareSearchContext dto) {
        Page<IBIZHardware> domains = ibizHardwareService.searchDefault(dto) ;
        List<IBIZHardwareDTO> list = ibizHardwareDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZHardware-Create-all')")
    @ApiOperation(value = "批量新建硬件", tags = {"硬件" },  notes = "批量新建硬件")
	@RequestMapping(method = RequestMethod.POST, value = "ibizhardwares/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZHardwareDTO> dtos) {
        ibizHardwareService.createBatch(ibizHardwareDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZHardware-Update-all')")
    @ApiOperation(value = "批量更新硬件", tags = {"硬件" },  notes = "批量更新硬件")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizhardwares/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZHardwareDTO> dtos) {
        ibizHardwareService.updateBatch(ibizHardwareDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZHardware-Save-all')")
    @ApiOperation(value = "批量保存硬件", tags = {"硬件" },  notes = "批量保存硬件")
	@RequestMapping(method = RequestMethod.POST, value = "ibizhardwares/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZHardwareDTO> dtos) {
        ibizHardwareService.saveBatch(ibizHardwareDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZHardware-Save-all')")
    @ApiOperation(value = "批量导入硬件", tags = {"硬件" },  notes = "批量导入硬件")
	@RequestMapping(method = RequestMethod.POST, value = "ibizhardwares/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZHardwareDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZHardware> list=ibizHardwareDtoMapping.toDomain(dtos);
            List<IBIZHardware> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizHardwareService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZHardware-Remove-all')")
    @ApiOperation(value = "批量删除硬件", tags = {"硬件" },  notes = "批量删除硬件")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizhardwares","/ibizhardwares/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizHardwareService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
