package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZTASKTEAMDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("任务团队")
public class IBIZTASKTEAMDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 用户
     */
    @JsonProperty("account")
    @JSONField(name = "account")
    @ApiModelProperty("用户")
    private String account;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 任务团队标识
     */
    @JsonProperty("ibiztaskteamid")
    @JSONField(name = "ibiztaskteamid")
    @ApiModelProperty("任务团队标识")
    private String ibiztaskteamid;

    /**
     * 任务团队名称
     */
    @JsonProperty("ibiztaskteamname")
    @JSONField(name = "ibiztaskteamname")
    @ApiModelProperty("任务团队名称")
    private String ibiztaskteamName;

    /**
     * 角色
     */
    @JsonProperty("role")
    @JSONField(name = "role")
    @ApiModelProperty("角色")
    private String role;

    /**
     * 任务标识
     */
    @JsonProperty("root")
    @JSONField(name = "root")
    @ApiModelProperty("任务标识")
    private String root;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [用户]
     */
    public void setAccount(String account) {
        this.account = account;
        this.modify("account", account);
    }

    /**
     * 设置 [任务团队名称]
     */
    public void setIbiztaskteamName(String ibiztaskteamName) {
        this.ibiztaskteamName = ibiztaskteamName;
        this.modify("ibiztaskteamname", ibiztaskteamName);
    }

    /**
     * 设置 [角色]
     */
    public void setRole(String role) {
        this.role = role;
        this.modify("role", role);
    }

    /**
     * 设置 [任务标识]
     */
    public void setRoot(String root) {
        this.root = root;
        this.modify("root", root);
    }


}
