package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0016DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("项目成员")
public class IBIZSample0016DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 员工标识
     */
    @JsonProperty("ibizsample0014id")
    @JSONField(name = "ibizsample0014id")
    @ApiModelProperty("员工标识")
    private String ibizSample0014Id;

    /**
     * 员工名称
     */
    @JsonProperty("ibizsample0014name")
    @JSONField(name = "ibizsample0014name")
    @ApiModelProperty("员工名称")
    private String ibizSample0014Name;

    /**
     * 项目标识
     */
    @JsonProperty("ibizsample0015id")
    @JSONField(name = "ibizsample0015id")
    @ApiModelProperty("项目标识")
    private String ibizSample0015Id;

    /**
     * 项目名称
     */
    @JsonProperty("ibizsample0015name")
    @JSONField(name = "ibizsample0015name")
    @ApiModelProperty("项目名称")
    private String ibizSample0015Name;

    /**
     * 项目成员标识
     */
    @JsonProperty("ibizsample0016id")
    @JSONField(name = "ibizsample0016id")
    @ApiModelProperty("项目成员标识")
    private String ibizSample0016Id;

    /**
     * 项目成员名称
     */
    @JsonProperty("ibizsample0016name")
    @JSONField(name = "ibizsample0016name")
    @ApiModelProperty("项目成员名称")
    private String ibizSample0016Name;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [员工标识]
     */
    public void setIbizSample0014Id(String ibizSample0014Id) {
        this.ibizSample0014Id = ibizSample0014Id;
        this.modify("ibizsample0014id", ibizSample0014Id);
    }

    /**
     * 设置 [员工名称]
     */
    public void setIbizSample0014Name(String ibizSample0014Name) {
        this.ibizSample0014Name = ibizSample0014Name;
        this.modify("ibizsample0014name", ibizSample0014Name);
    }

    /**
     * 设置 [项目标识]
     */
    public void setIbizSample0015Id(String ibizSample0015Id) {
        this.ibizSample0015Id = ibizSample0015Id;
        this.modify("ibizsample0015id", ibizSample0015Id);
    }

    /**
     * 设置 [项目名称]
     */
    public void setIbizSample0015Name(String ibizSample0015Name) {
        this.ibizSample0015Name = ibizSample0015Name;
        this.modify("ibizsample0015name", ibizSample0015Name);
    }

    /**
     * 设置 [项目成员名称]
     */
    public void setIbizSample0016Name(String ibizSample0016Name) {
        this.ibizSample0016Name = ibizSample0016Name;
        this.modify("ibizsample0016name", ibizSample0016Name);
    }


}
