package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0011DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单明细")
public class IBIZSample0011DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 小计
     */
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty("小计")
    private BigDecimal amount;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 订单标识
     */
    @JsonProperty("ibizsample0010id")
    @JSONField(name = "ibizsample0010id")
    @ApiModelProperty("订单标识")
    private String ibizSample0010Id;

    /**
     * 订单名称
     */
    @JsonProperty("ibizsample0010name")
    @JSONField(name = "ibizsample0010name")
    @ApiModelProperty("订单名称")
    private String ibizSample0010Name;

    /**
     * 订单明细标识
     */
    @JsonProperty("ibizsample0011id")
    @JSONField(name = "ibizsample0011id")
    @ApiModelProperty("订单明细标识")
    private String ibizSample0011Id;

    /**
     * 订单明细名称
     */
    @JsonProperty("ibizsample0011name")
    @JSONField(name = "ibizsample0011name")
    @ApiModelProperty("订单明细名称")
    private String ibizSample0011Name;

    /**
     * 统一产品标识
     */
    @JsonProperty("ibizuniproductid")
    @JSONField(name = "ibizuniproductid")
    @ApiModelProperty("统一产品标识")
    private String ibizuniProductId;

    /**
     * 统一产品名称
     */
    @JsonProperty("ibizuniproductname")
    @JSONField(name = "ibizuniproductname")
    @ApiModelProperty("统一产品名称")
    private String ibizuniProductName;

    /**
     * 数量
     */
    @JsonProperty("quantity")
    @JSONField(name = "quantity")
    @ApiModelProperty("数量")
    private Integer quantity;

    /**
     * 单位
     */
    @JsonProperty("unit")
    @JSONField(name = "unit")
    @ApiModelProperty("单位")
    private String unit;

    /**
     * 单价
     */
    @JsonProperty("unitprice")
    @JSONField(name = "unitprice")
    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [小计]
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [订单标识]
     */
    public void setIbizSample0010Id(String ibizSample0010Id) {
        this.ibizSample0010Id = ibizSample0010Id;
        this.modify("ibizsample0010id", ibizSample0010Id);
    }

    /**
     * 设置 [订单名称]
     */
    public void setIbizSample0010Name(String ibizSample0010Name) {
        this.ibizSample0010Name = ibizSample0010Name;
        this.modify("ibizsample0010name", ibizSample0010Name);
    }

    /**
     * 设置 [订单明细名称]
     */
    public void setIbizSample0011Name(String ibizSample0011Name) {
        this.ibizSample0011Name = ibizSample0011Name;
        this.modify("ibizsample0011name", ibizSample0011Name);
    }

    /**
     * 设置 [统一产品标识]
     */
    public void setIbizuniProductId(String ibizuniProductId) {
        this.ibizuniProductId = ibizuniProductId;
        this.modify("ibizuniproductid", ibizuniProductId);
    }

    /**
     * 设置 [统一产品名称]
     */
    public void setIbizuniProductName(String ibizuniProductName) {
        this.ibizuniProductName = ibizuniProductName;
        this.modify("ibizuniproductname", ibizuniProductName);
    }

    /**
     * 设置 [数量]
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
        this.modify("quantity", quantity);
    }

    /**
     * 设置 [单位]
     */
    public void setUnit(String unit) {
        this.unit = unit;
        this.modify("unit", unit);
    }

    /**
     * 设置 [单价]
     */
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        this.modify("unitprice", unitPrice);
    }


}
