package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0009DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("商品价格明细")
public class IBIZSample0009DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 日期
     */
    @JsonProperty("date")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "date" , format = "yyyy-MM-dd")
    @ApiModelProperty("日期")
    private Timestamp date;

    /**
     * 商品价格明细标识
     */
    @JsonProperty("ibizsample0009id")
    @JSONField(name = "ibizsample0009id")
    @ApiModelProperty("商品价格明细标识")
    private String ibizSample0009Id;

    /**
     * 商品价格明细名称
     */
    @JsonProperty("ibizsample0009name")
    @JSONField(name = "ibizsample0009name")
    @ApiModelProperty("商品价格明细名称")
    private String ibizSample0009Name;

    /**
     * 开盘
     */
    @JsonProperty("kp")
    @JSONField(name = "kp")
    @ApiModelProperty("开盘")
    private BigDecimal kp;

    /**
     * 盘低
     */
    @JsonProperty("pd")
    @JSONField(name = "pd")
    @ApiModelProperty("盘低")
    private BigDecimal pd;

    /**
     * 盘高
     */
    @JsonProperty("pg")
    @JSONField(name = "pg")
    @ApiModelProperty("盘高")
    private BigDecimal pg;

    /**
     * 收盘
     */
    @JsonProperty("sp")
    @JSONField(name = "sp")
    @ApiModelProperty("收盘")
    private BigDecimal sp;

    /**
     * 商品名称
     */
    @JsonProperty("spmc")
    @JSONField(name = "spmc")
    @ApiModelProperty("商品名称")
    private String spmc;

    /**
     * 统计
     */
    @JsonProperty("tj")
    @JSONField(name = "tj")
    @ApiModelProperty("统计")
    private String tj;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [日期]
     */
    public void setDate(Timestamp date) {
        this.date = date;
        this.modify("date", date);
    }

    /**
     * 设置 [商品价格明细名称]
     */
    public void setIbizSample0009Name(String ibizSample0009Name) {
        this.ibizSample0009Name = ibizSample0009Name;
        this.modify("ibizsample0009name", ibizSample0009Name);
    }

    /**
     * 设置 [开盘]
     */
    public void setKp(BigDecimal kp) {
        this.kp = kp;
        this.modify("kp", kp);
    }

    /**
     * 设置 [盘低]
     */
    public void setPd(BigDecimal pd) {
        this.pd = pd;
        this.modify("pd", pd);
    }

    /**
     * 设置 [盘高]
     */
    public void setPg(BigDecimal pg) {
        this.pg = pg;
        this.modify("pg", pg);
    }

    /**
     * 设置 [收盘]
     */
    public void setSp(BigDecimal sp) {
        this.sp = sp;
        this.modify("sp", sp);
    }

    /**
     * 设置 [商品名称]
     */
    public void setSpmc(String spmc) {
        this.spmc = spmc;
        this.modify("spmc", spmc);
    }

    /**
     * 设置 [统计]
     */
    public void setTj(String tj) {
        this.tj = tj;
        this.modify("tj", tj);
    }


}
