package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZCPUDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("处理器")
public class IBIZCPUDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 处理器标识
     */
    @JsonProperty("ibizcpuid")
    @JSONField(name = "ibizcpuid")
    @ApiModelProperty("处理器标识")
    private String ibizcpuid;

    /**
     * 名称
     */
    @JsonProperty("ibizcpuname")
    @JSONField(name = "ibizcpuname")
    @ApiModelProperty("名称")
    private String ibizcpuName;

    /**
     * 分组类型
     */
    @JsonProperty("ibizhardwaretype")
    @JSONField(name = "ibizhardwaretype")
    @ApiModelProperty("分组类型")
    private String ibizHardwareType;

    /**
     * 生产厂商
     */
    @JsonProperty("producer")
    @JSONField(name = "producer")
    @ApiModelProperty("生产厂商")
    private String producer;

    /**
     * 产品编号
     */
    @JsonProperty("productuid")
    @JSONField(name = "productuid")
    @ApiModelProperty("产品编号")
    private String productUid;

    /**
     * 单位
     */
    @JsonProperty("unit")
    @JSONField(name = "unit")
    @ApiModelProperty("单位")
    private String unit;

    /**
     * 单价
     */
    @JsonProperty("unitprice")
    @JSONField(name = "unitprice")
    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [名称]
     */
    public void setIbizcpuName(String ibizcpuName) {
        this.ibizcpuName = ibizcpuName;
        this.modify("ibizcpuname", ibizcpuName);
    }

    /**
     * 设置 [分组类型]
     */
    public void setIbizHardwareType(String ibizHardwareType) {
        this.ibizHardwareType = ibizHardwareType;
        this.modify("ibizhardwaretype", ibizHardwareType);
    }

    /**
     * 设置 [生产厂商]
     */
    public void setProducer(String producer) {
        this.producer = producer;
        this.modify("producer", producer);
    }

    /**
     * 设置 [产品编号]
     */
    public void setProductUid(String productUid) {
        this.productUid = productUid;
        this.modify("productuid", productUid);
    }

    /**
     * 设置 [单位]
     */
    public void setUnit(String unit) {
        this.unit = unit;
        this.modify("unit", unit);
    }

    /**
     * 设置 [单价]
     */
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        this.modify("unitprice", unitPrice);
    }


}
