package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZViewMsg;
import cn.ibizlab.core.sample.filter.IBIZViewMsgSearchContext;
import cn.ibizlab.core.sample.service.IBIZViewMsgService;
import cn.ibizlab.core.sample.mapper.IBIZViewMsgMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[视图消息源] 服务对象接口实现
 */
@Slf4j
@Service("IBIZViewMsgService")
public class IBIZViewMsgServiceBase extends ServiceImpl<IBIZViewMsgMapper,IBIZViewMsg> implements IBIZViewMsgService {


    protected int batchSize = 500;

    public IBIZViewMsg get(IBIZViewMsg et) {
        IBIZViewMsg rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,视图消息源:"+et.getIbizViewMsgId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZViewMsg> getByEntities(List<IBIZViewMsg> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZViewMsg getDraft(IBIZViewMsg et) {
        return et;
    }

    public Integer checkKey(IBIZViewMsg et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizViewMsgId())) && this.count(Wrappers.<IBIZViewMsg>query().eq("ibizviewmsgid", et.getIbizViewMsgId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZViewMsg et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZViewMsg> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZViewMsg et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizviewmsgid", et.getIbizViewMsgId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZViewMsg> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZViewMsg et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZViewMsg> list) {
        List<IBIZViewMsg> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizViewMsgId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZViewMsg> _create=new ArrayList<>();
        List<IBIZViewMsg> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizViewMsgId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZViewMsg et) {
        String key = et.getIbizViewMsgId();

        if(!remove(new QueryWrapper<IBIZViewMsg>()
                .eq("ibizviewmsgid", et.getIbizViewMsgId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZViewMsg> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZViewMsg> searchDefault(IBIZViewMsgSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZViewMsg> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZViewMsg>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZViewMsg> listDefault(IBIZViewMsgSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }