package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0002;
import cn.ibizlab.core.sample.filter.IBIZSample0002SearchContext;
import cn.ibizlab.core.sample.service.IBIZSample0002Service;
import cn.ibizlab.core.sample.mapper.IBIZSample0002Mapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[示例实体02] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0002Service")
public class IBIZSample0002ServiceBase extends ServiceImpl<IBIZSample0002Mapper,IBIZSample0002> implements IBIZSample0002Service {


    protected int batchSize = 500;

    public IBIZSample0002 get(IBIZSample0002 et) {
        IBIZSample0002 rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,示例实体02:"+et.getIbizSample0002Id());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSample0002> getByEntities(List<IBIZSample0002> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZSample0002 getDraft(IBIZSample0002 et) {
        return et;
    }

    public Integer checkKey(IBIZSample0002 et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizSample0002Id())) && this.count(Wrappers.<IBIZSample0002>query().eq("ibizsample0002id", et.getIbizSample0002Id()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSample0002 et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSample0002> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSample0002 et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsample0002id", et.getIbizSample0002Id());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSample0002> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSample0002 et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSample0002> list) {
        List<IBIZSample0002> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizSample0002Id();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSample0002> _create=new ArrayList<>();
        List<IBIZSample0002> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizSample0002Id();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSample0002 et) {
        String key = et.getIbizSample0002Id();

        if(!remove(new QueryWrapper<IBIZSample0002>()
                .eq("ibizsample0002id", et.getIbizSample0002Id())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSample0002> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSample0002> searchDefault(IBIZSample0002SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0002> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0002>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0002> listDefault(IBIZSample0002SearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }