package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZCPU;
import cn.ibizlab.core.sample.filter.IBIZCPUSearchContext;
import cn.ibizlab.core.sample.service.IBIZCPUService;
import cn.ibizlab.core.sample.mapper.IBIZCPUMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import cn.ibizlab.core.sample.service.IBIZHardwareService;


/**
 * 实体[处理器] 服务对象接口实现
 */
@Slf4j
@Service("IBIZCPUService")
public class IBIZCPUServiceBase extends ServiceImpl<IBIZCPUMapper,IBIZCPU> implements IBIZCPUService {

    @Autowired
    @Lazy
    protected IBIZHardwareService ibizHardwareService;
   
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.mapping.IBIZCPUInheritMapping ibizcpuInheritMapping;

    protected int batchSize = 500;

    public IBIZCPU get(IBIZCPU et) {
        IBIZCPU rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,处理器:"+et.getIbizcpuid());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZCPU> getByEntities(List<IBIZCPU> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZCPU getDraft(IBIZCPU et) {
        return et;
    }

    public Integer checkKey(IBIZCPU et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizcpuid())) && this.count(Wrappers.<IBIZCPU>query().eq("ibizcpuid", et.getIbizcpuid()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZCPU et) {
        if(ObjectUtils.isEmpty(et.getIbizcpuid()))
            et.setIbizcpuid((String)et.getDefaultKey(true));
        IBIZHardware ibizHardware = ibizcpuInheritMapping.toIbizHardware(et);
        ibizHardwareService.create(ibizHardware);

        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZCPU> list) {
        for (IBIZCPU et : list) {
            getSelf().create(et);
        }
        return true;
    }

    @Transactional
    public boolean update(IBIZCPU et) {
        IBIZHardware ibizHardware = ibizcpuInheritMapping.toIbizHardware(et);
        ibizHardwareService.save(ibizHardware);

        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizcpuid", et.getIbizcpuid());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZCPU> list) {
        for (IBIZCPU et : list) {
            getSelf().update(et);
        }
        return true;
    }

    @Transactional
    public boolean save(IBIZCPU et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZCPU> list) {
        List<IBIZCPU> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizcpuid();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZCPU> _create=new ArrayList<>();
        List<IBIZCPU> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizcpuid();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZCPU et) {
        String key = et.getIbizcpuid();
        ibizHardwareService.remove(ibizcpuInheritMapping.toIbizHardware(et));


        if(!remove(new QueryWrapper<IBIZCPU>()
                .eq("ibizcpuid", et.getIbizcpuid())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZCPU> entities) {
        for (IBIZCPU et : entities) {
            if(!getSelf().remove(et))
                return false;
        }
        return true;
    }

    public Page<IBIZCPU> searchDefault(IBIZCPUSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZCPU> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZCPU>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZCPU> listDefault(IBIZCPUSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }