package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0020;
import cn.ibizlab.core.sample.filter.IBIZSample0020SearchContext;
import cn.ibizlab.core.sample.domain.IBIZSample0019;

public interface IBIZSample0020Service extends IService<IBIZSample0020> {

    default IBIZSample0020Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0020 get(IBIZSample0020 et);
    default IBIZSample0020 get(String key) {
        IBIZSample0020 et = new IBIZSample0020();
        et.setIbizsample0020Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0020> getByIds(Collection<String> ids) {
        List<IBIZSample0020> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0020 et = new IBIZSample0020();
            et.setIbizsample0020Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0020> getByEntities(List<IBIZSample0020> entities);

    IBIZSample0020 getDraft(IBIZSample0020 et);

    Integer checkKey(IBIZSample0020 et);

    boolean create(IBIZSample0020 et);
    boolean createBatch(List<IBIZSample0020> list);

    boolean update(IBIZSample0020 et);
    boolean updateBatch(List<IBIZSample0020> list);

    boolean save(IBIZSample0020 et);
    boolean saveBatch(List<IBIZSample0020> list);

    default boolean remove(String key) {
        IBIZSample0020 et = new IBIZSample0020();
        et.setIbizsample0020Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0020 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0020> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0020 et = new IBIZSample0020();
            et.setIbizsample0020Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0020> entities);

    Page<IBIZSample0020> searchDefault(IBIZSample0020SearchContext context);
    List<IBIZSample0020> listDefault(IBIZSample0020SearchContext context);

    List<IBIZSample0020> selectByIbizsample0019Id(String ibizsample0019Id);
    boolean removeByIbizsample0019Id(String ibizsample0019Id);
    boolean resetByIbizsample0019Id(String ibizsample0019Id);
    boolean saveByIbizsample0019(cn.ibizlab.core.sample.domain.IBIZSample0019 ibizSample0019,List<IBIZSample0020> list);
    default boolean saveByIbizsample0019Id(String ibizsample0019Id,List<IBIZSample0020> list) {
        cn.ibizlab.core.sample.domain.IBIZSample0019 et = new cn.ibizlab.core.sample.domain.IBIZSample0019();
        et.setIbizsample0019Id(ibizsample0019Id);
        return getSelf().saveByIbizsample0019(et,list);
    }

}